/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.debug;

import com.atmel.avr32.target.debug.IWatchable;
import com.atmel.avr32.target.internal.XMLWriter;
import com.atmel.avr32.target.part.model.AbstractModelInfo;
import com.atmel.avr32.target.part.model.IModelInfo;

public abstract class Watchable
extends AbstractModelInfo
implements IWatchable,
IModelInfo {
    private boolean fHasChanged;
    private boolean fHasValue;
    private int format = -1;
    private long fPreviousValue = -1L;
    private boolean fReadOnly;
    private long fValue = -1L;
    private boolean fWatched;

    @Override
    public void clearValue() {
        this.fHasValue = false;
        this.fHasChanged = false;
    }

    @Override
    public void resetValue() {
        this.fHasValue = false;
        this.fHasChanged = false;
        this.fPreviousValue = -1L;
        this.fValue = -1L;
    }

    public String descriptiveValue(long value) {
        return "<undefined>";
    }

    protected int getDefaultFormat() {
        return 2;
    }

    @Override
    public int getFormat() {
        return this.format;
    }

    @Override
    public String getFormattedValue() {
        return this.getFormattedValue(this.getValue());
    }

    @Override
    public String getFormattedValue(long value) {
        if (!this.hasValue()) {
            return "<undefined>";
        }
        StringBuffer sb = new StringBuffer();
        int f = this.format;
        if (f == -1) {
            f = this.getDefaultFormat();
        }
        switch (f) {
            case 0: {
                sb.append("0b");
                sb.append(Long.toBinaryString(value));
                break;
            }
            case 1: {
                sb.append(Long.toString(value));
                break;
            }
            case 2: {
                sb.append("0x");
                sb.append(Long.toHexString(value));
                break;
            }
            case 3: {
                sb.append(this.descriptiveValue(value));
            }
        }
        return sb.toString();
    }

    @Override
    public long getPreviousValue() {
        return this.fPreviousValue;
    }

    public String getTooltip() {
        StringBuffer sb = new StringBuffer();
        sb.append("<p>");
        sb.append("<b>" + this.getName() + "</b><br/>");
        sb.append(this.getDescription());
        sb.append("</p>");
        sb.append("<p>");
        sb.append("Current value:<br/>");
        if (this.hasValue()) {
            sb.append("0b");
            sb.append(Integer.toBinaryString((int)this.getValue()));
            sb.append(", ");
            sb.append(Long.toString(this.getValue()));
            sb.append(", ");
            sb.append("0x");
            sb.append(Long.toHexString(this.getValue()));
            sb.append("<br/>");
            sb.append(XMLWriter.getEscaped(this.descriptiveValue(this.fValue)).trim());
        } else {
            sb.append("Unknown");
        }
        sb.append("</p>");
        sb.append("<p>");
        sb.append("Previous value:<br/>");
        if (this.fPreviousValue > -1L) {
            sb.append("0b");
            sb.append(Integer.toBinaryString((int)this.fPreviousValue));
            sb.append(", ");
            sb.append(Long.toString(this.fPreviousValue));
            sb.append(", ");
            sb.append("0x");
            sb.append(Long.toHexString(this.fPreviousValue));
            sb.append("<br/>");
            sb.append(XMLWriter.getEscaped(this.descriptiveValue(this.fPreviousValue)).trim());
        } else {
            sb.append("Unknown");
        }
        sb.append("</p>");
        return sb.toString();
    }

    @Override
    public long getValue() {
        return this.fValue;
    }

    @Override
    public void gotValue() {
        this.fHasValue = true;
    }

    @Override
    public boolean hasChanged() {
        return this.fHasChanged;
    }

    @Override
    public boolean hasValue() {
        return this.fHasValue;
    }

    @Override
    public boolean isReadonly() {
        return this.fReadOnly;
    }

    @Override
    public boolean isWatched() {
        return this.fWatched;
    }

    @Override
    public void setChanged(boolean changedState) {
        this.fHasChanged = changedState;
    }

    @Override
    public void setFormat(int format) {
        this.format = format;
    }

    @Override
    public void setReadonly(boolean readonly) {
        this.fReadOnly = readonly;
    }

    @Override
    public void setValue(long value) {
        this.fPreviousValue = this.fValue;
        this.fValue = value;
    }

    @Override
    public void setWatched(boolean watched) {
        this.fWatched = watched;
    }

    @Override
    public boolean testValue(long value) {
        return this.getValue() != value;
    }
}

