/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target;

import com.atmel.avr32.target.internal.ToolExtensionPointReader;
import com.atmel.avr32.target.tool.model.Tool;
import java.util.ArrayList;
import java.util.Collections;

public class ToolRegistry {
    static ArrayList<Tool> tools;

    private static void initializeToolsList() {
        if (tools == null) {
            ToolExtensionPointReader eph = new ToolExtensionPointReader();
            tools = eph.getTools();
        }
    }

    public static Tool[] getTools(int types) {
        ToolRegistry.initializeToolsList();
        ArrayList<Tool> matches = new ArrayList<Tool>();
        for (Tool tool : tools) {
            if ((tool.getType() & types) == 0) continue;
            matches.add(tool);
        }
        Collections.sort(matches);
        return matches.toArray(new Tool[matches.size()]);
    }

    public static Tool getTool(String name) {
        ToolRegistry.initializeToolsList();
        for (Tool tool : tools) {
            if (!tool.getName().equals(name)) continue;
            return tool;
        }
        return null;
    }
}

