/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target;

import com.atmel.avr32.managedbuilder.ManagedbuildPlugin;
import com.atmel.avr32.target.ITarget;
import com.atmel.avr32.target.ITargetAction;
import com.atmel.avr32.target.ITargetFirmwareInterface;
import com.atmel.avr32.target.ITargetInterface;
import com.atmel.avr32.target.ITargetManager;
import com.atmel.avr32.target.Messages;
import com.atmel.avr32.target.PartRegistry;
import com.atmel.avr32.target.ToolRegistry;
import com.atmel.avr32.target.internal.InterfaceExtensionPointReader;
import com.atmel.avr32.target.internal.TargetActionComparator;
import com.atmel.avr32.target.internal.TargetManager;
import com.atmel.avr32.target.part.model.Part;
import com.atmel.avr32.target.tool.model.Capability;
import com.atmel.avr32.target.tool.model.TargetInterfaceDescription;
import com.atmel.avr32.target.tool.model.Tool;
import com.atmel.avr32.util.UtilPlugin;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.BundleContext;

public class TargetPlugin
extends AbstractUIPlugin {
    private static boolean fDebugging;
    public static final String AVR32_PROJECT_TARGET_CPU = "AVR32_PROJECT_TARGET_CPU";
    private static HashMap<String, ITargetAction> fActions;
    private static HashMap<String, TargetInterfaceDescription> fAdapterInterfaces;
    private static ITargetManager fTargetManager;
    public static final String ID_SYSTEMTYPE_AVR32LINUX = "com.atmel.avr32.linux";
    public static final String ID_TARGET_INTERFACES = "com.atmel.avr32.target.interfaces";
    public static final String IMAGE_DESC_HELP = "IMAGE_DESC_HELP";
    public static final String IMAGE_OVR_TGT_DEFAULT = "IMAGE_OVR_TGT_DEFAULT";
    public static final String IMAGE_OVR_TGT_DISABLED = "IMAGE_OVR_TGT_DISABLED";
    public static final String IMAGE_OVR_TGT_INVALID = "IMAGE_OVR_TGT_INVALID";
    public static final String IMAGE_OVR_TGT_WORKING = "IMAGE_OVR_TGT_WORKING";
    public static final String IMAGE_TARGET_ACTION_BANNER = "IMAGE_TARGET_ACTION_BANNER";
    static TargetPlugin plugin;
    public static final String PLUGIN_ID = "com.atmel.avr32.target";

    public static void errorMessage(final String title, final String message) {
        final Display display = TargetPlugin.getStandardDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = display.getActiveShell();
                if (shell == null) {
                    shell = new Shell(display);
                }
                MessageDialog.openError((Shell)shell, (String)title, (String)message);
            }
        });
    }

    public static TargetPlugin getDefault() {
        return plugin;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static ITargetManager getTargetManager() {
        if (fTargetManager == null) {
            fTargetManager = TargetManager.getDefault();
        }
        return fTargetManager;
    }

    public static void infoMessage(final String title, final String message) {
        final Display display = TargetPlugin.getStandardDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = display.getActiveShell();
                if (shell == null) {
                    shell = new Shell(display);
                }
                MessageDialog.openInformation((Shell)shell, (String)title, (String)message);
            }
        });
    }

    public static void operationStatusMessage(IStatus status) {
        switch (status.getSeverity()) {
            case 8: {
                TargetPlugin.warningMessage(Messages.TargetPlugin_Operation_Cancelled, status.getMessage());
                break;
            }
            case 2: {
                TargetPlugin.warningMessage(Messages.TargetPlugin_Operation_Cancelled, status.getMessage());
                break;
            }
            case 4: {
                TargetPlugin.errorMessage(Messages.TargetPlugin_Operation_Aborted, status.getMessage());
                break;
            }
            default: {
                TargetPlugin.infoMessage(Messages.TargetPlugin_Operation_Performed, status.getMessage());
            }
        }
    }

    public static void warningMessage(final String title, final String message) {
        final Display display = TargetPlugin.getStandardDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = display.getActiveShell();
                if (shell == null) {
                    shell = new Shell(display);
                }
                MessageDialog.openWarning((Shell)shell, (String)title, (String)message);
            }
        });
    }

    public TargetPlugin() {
        InterfaceExtensionPointReader reader = new InterfaceExtensionPointReader();
        fActions = reader.getTargetActions();
        fAdapterInterfaces = reader.getTargetInterfaces();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canExecute(ITarget target, ITargetAction action) {
        try {
            Capability requiror;
            ArrayList<Capability> requirements = action.getRequirements();
            if (action.getAppliesTo() == ITargetAction.TargetComponent.BOARD && !target.hasBoard()) {
                return false;
            }
            if (action.getAppliesTo() == ITargetAction.TargetComponent.MCU && !target.hasMCU()) {
                return false;
            }
            if (requirements == null) return true;
            if (action.getRequirements().size() == 0) {
                return true;
            }
            ArrayList<Capability> filteredCaps = this.getFilteredCapabilities(target);
            Iterator<Capability> iterator = requirements.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!this.isMatching(requiror = iterator.next(), filteredCaps));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public Part getPart(IProject project) {
        String id = ManagedbuildPlugin.getProjectMCU((IProject)project);
        return PartRegistry.getPart(id);
    }

    public ITargetAction getTargetAction(String id) {
        return fActions.get(id);
    }

    public ArrayList<ITargetAction> getTargetActions(ITarget target) {
        ArrayList<ITargetAction> targetActions = new ArrayList<ITargetAction>();
        for (ITargetAction action : fActions.values()) {
            action.setTarget(target);
            if (!action.needsConnection() || !this.canExecute(target, action)) continue;
            targetActions.add(action);
        }
        Collections.sort(targetActions, new TargetActionComparator());
        return targetActions;
    }

    public ITargetInterface getTargetInterface(ITarget target, boolean board) {
        String required = board ? ToolRegistry.getTool(target.getBoardName()).getId() : ToolRegistry.getTool(target.getAdapterName()).getId();
        String name = board ? target.getBoardName() : target.getAdapterName();
        TargetInterfaceDescription[] interfaces = this.getTargetInterfaces(target, required);
        if (interfaces.length > 0) {
            return interfaces[0].getInstance();
        }
        if (board) {
            TargetPlugin.warningMessage(Messages.TargetPlugin_Unsupported_Operation, MessageFormat.format(Messages.TargetPlugin_No_Such_Feature_2, name, required));
        } else {
            TargetPlugin.warningMessage(Messages.TargetPlugin_Unsupported_Operation, MessageFormat.format(Messages.TargetPlugin_No_Such_Feature_1, name, target.getAdapterName(), required));
        }
        return null;
    }

    public ITargetFirmwareInterface getTargetFirmwareInterface(ITarget target) {
        TargetInterfaceDescription[] interfaces;
        TargetInterfaceDescription[] targetInterfaceDescriptionArray = interfaces = this.getTargetInterfaces(target, CapabilityId.firmware.toString());
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            TargetInterfaceDescription targetInterfaceDescription = targetInterfaceDescriptionArray[n2];
            if (targetInterfaceDescription.getInstance() instanceof ITargetFirmwareInterface) {
                return (ITargetFirmwareInterface)((Object)targetInterfaceDescription.getInstance());
            }
            ++n2;
        }
        return null;
    }

    public ITargetInterface getTargetInterface(String name) {
        return fAdapterInterfaces.get(name).getInstance();
    }

    public ITargetInterface getTargetInterface(ITargetAction action) {
        return fAdapterInterfaces.get(action.getInterfaceId()).getInstance();
    }

    public TargetInterfaceDescription getTargetInterfaceDescriptor(String id) {
        return fAdapterInterfaces.get(id);
    }

    public TargetInterfaceDescription[] getTargetInterfaces(ITarget target, String id) {
        ArrayList<TargetInterfaceDescription> interfaces = new ArrayList<TargetInterfaceDescription>();
        ArrayList<Capability> filteredCaps = this.getFilteredCapabilities(target);
        block0: for (TargetInterfaceDescription tid : fAdapterInterfaces.values()) {
            Capability capability = tid.getCapability(id);
            if (capability == null) continue;
            if (capability.getRequires().size() == 0) {
                interfaces.add(tid);
            }
            for (Capability requiror : capability.getRequires()) {
                if (!this.isMatching(requiror, filteredCaps)) continue;
                interfaces.add(tid);
                continue block0;
            }
        }
        return interfaces.toArray(new TargetInterfaceDescription[interfaces.size()]);
    }

    private ArrayList<Capability> getFilteredCapabilities(ITarget target) {
        ArrayList<Capability> filteredCaps = new ArrayList<Capability>();
        Tool debugger = ToolRegistry.getTool(target.getAdapterName());
        if (debugger != null) {
            for (Capability capability : debugger.getCapabilities()) {
                if (capability.getRequires() != null && capability.getRequires().size() > 0) {
                    for (Capability ar : capability.getRequires()) {
                        if (!this.isValid(ar, target)) continue;
                        filteredCaps.add(capability);
                    }
                    continue;
                }
                filteredCaps.add(capability);
            }
        }
        return filteredCaps;
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        super.initializeImageRegistry(reg);
        reg.put(IMAGE_DESC_HELP, AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/lcl16/help.gif"));
        reg.put(IMAGE_OVR_TGT_DEFAULT, AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/ovr16/target_default.gif"));
        reg.put(IMAGE_OVR_TGT_DISABLED, AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/ovr16/target_disabled.gif"));
        reg.put(IMAGE_OVR_TGT_INVALID, AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/ovr16/target_invalid.gif"));
        reg.put(IMAGE_OVR_TGT_WORKING, AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/ovr16/target_working.gif"));
        reg.put(IMAGE_TARGET_ACTION_BANNER, AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/wizban/targetaction_wiz.png"));
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        if (super.isDebugging()) {
            fDebugging = true;
        }
        if (System.getProperty("no-hardware") != null) {
            System.out.println("\"no-hardware\" specified, not scanning targets.");
        } else {
            this.scanTargets();
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public boolean supportsCapability(TargetInterfaceDescription tid, ITarget target, CapabilityId capability) {
        return this.supportsCapability(tid, target, capability.toString());
    }

    private boolean supportsCapability(TargetInterfaceDescription ti, ITarget target, String id) {
        Capability capability = this.findCapability(this.getFilteredCapabilities(target), id);
        if (capability == null) {
            return false;
        }
        return this.isMatching(capability, ti.getCapabilities());
    }

    public boolean supportsCapability(ITarget target, String capability) {
        return this.findCapability(this.getFilteredCapabilities(target), capability) != null;
    }

    public boolean supportsCapability(String part, CapabilityId capability) {
        Part p = PartRegistry.getPart(part);
        if (p == null) {
            return false;
        }
        for (Capability tested : p.getCapabilities()) {
            if (!capability.toString().equals(tested.getId())) continue;
            return true;
        }
        return false;
    }

    private Capability findCapability(ArrayList<Capability> filteredCaps, String id) {
        for (Capability capability : filteredCaps) {
            if (!capability.getId().equals(id)) continue;
            return capability;
        }
        return null;
    }

    private boolean isMatching(Capability capability, ArrayList<Capability> testSet) {
        if (capability.isAndCollection()) {
            int matches = 0;
            for (Capability required : capability.getRequires()) {
                for (Capability tested : testSet) {
                    if (!required.getId().equals(tested.getId())) continue;
                    ++matches;
                }
            }
            return matches == capability.getRequires().size();
        }
        for (Capability tested : testSet) {
            if (!capability.getId().equals(tested.getId())) continue;
            return true;
        }
        return false;
    }

    private boolean isValid(Capability capability, ITarget target) {
        if (!target.isValid()) {
            return false;
        }
        ArrayList<Capability> aCaps = target.getPart().getCapabilities();
        ArrayList<Capability> bCaps = ToolRegistry.getTool(target.getBoardName()).getCapabilities();
        if (capability.isAndCollection()) {
            int matches = 0;
            for (Capability required : capability.getRequires()) {
                ArrayList<Capability> testSet = required.isBoard() ? bCaps : aCaps;
                for (Capability tested : testSet) {
                    if (!required.getId().equals(tested.getId())) continue;
                    ++matches;
                }
            }
            return matches == capability.getRequires().size();
        }
        ArrayList<Capability> testSet = capability.isBoard() ? bCaps : aCaps;
        for (Capability tested : testSet) {
            if (!capability.getId().equals(tested.getId())) continue;
            return true;
        }
        return false;
    }

    public static void debug(Object message) {
        if (fDebugging) {
            UtilPlugin.debug((Object)message);
        }
    }

    public boolean isDebugging() {
        return fDebugging;
    }

    public void scanTargets() {
        System.out.println("scanning");
        Job job = new Job(Messages.TargetPlugin_Scanning_Targets){

            public IStatus run(IProgressMonitor monitor) {
                ITarget[] iTargetArray = TargetPlugin.getTargetManager().getTargets();
                int n = iTargetArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITarget target = iTargetArray[n2];
                    target.setDetected(false);
                    ++n2;
                }
                ArrayList sortedList = new ArrayList();
                sortedList.addAll(fAdapterInterfaces.values());
                Collections.sort(sortedList, new Comparator<TargetInterfaceDescription>(){

                    @Override
                    public int compare(TargetInterfaceDescription o1, TargetInterfaceDescription o2) {
                        return o1.getScanPriority() - o2.getScanPriority();
                    }
                });
                ArrayList<String> executed = new ArrayList<String>();
                for (TargetInterfaceDescription targetInterfaceDescription : sortedList) {
                    ITargetInterface instance = targetInterfaceDescription.getInstance();
                    String name = instance.getClass().getName();
                    if (executed.contains(name)) continue;
                    IStatus status = instance.list(monitor);
                    if (status != null && status.getSeverity() == 4) {
                        StatusManager.getManager().handle(status, 2);
                    }
                    executed.add(name);
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(50);
        job.setSystem(false);
        job.schedule();
    }

    public static enum CapabilityId {
        run,
        debug,
        avr32jtag,
        intflash,
        fuses,
        nanotrace,
        auxtrace,
        daisychain,
        selftest,
        firmware,
        flashvault,
        simulator;

    }
}

