/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target;

import com.atmel.avr32.target.ITarget;
import com.atmel.avr32.target.Messages;
import com.atmel.avr32.target.PartRegistry;
import com.atmel.avr32.target.ToolRegistry;
import com.atmel.avr32.target.internal.TargetPropertySource;
import com.atmel.avr32.target.part.model.Part;
import com.atmel.avr32.target.tool.model.IMemoryBlock;
import com.atmel.avr32.target.tool.model.Tool;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.properties.IPropertySource;

public class Target
implements IAdaptable,
ITarget {
    private static final String DEFAULT_DEBUGGER_ICON = "icons/obj16/tools_icon_debug_tor.gif";
    private static final String EMPTY_STRING = "";
    private TargetPropertySource properties;
    private String name = "New Target";
    private String adapter = "";
    private String board = "";
    private String cpu = "";
    private String serial = "";
    private String comport = "";
    private String description = "";
    private String connectionType = "usb";
    private int Id = 0;
    private boolean working;
    private boolean fDefault;
    private String lastBinary = "";
    private long lastBinaryDateTime;
    private int fClockSource;
    private int daisyDevsBefore = 0;
    private int daisyDevsAfter = 0;
    private int daisyBitsBefore = 0;
    private int daisyBitsAfter = 0;
    private boolean dirty;
    private boolean daisyIsEnabled = false;
    private boolean fDetected;

    public Target() {
    }

    public Target(String name, String serial) {
        this();
        try {
            Long.parseLong(serial, 16);
        }
        catch (Exception exception) {
            throw new RuntimeException("Serial number must be an hexadecimal integer.");
        }
        this.name = name;
        this.serial = serial;
    }

    @Override
    public ArrayList<IMemoryBlock> getFlashList() {
        return this.getFlash(3);
    }

    @Override
    public ArrayList<IMemoryBlock> getFlash(int type) {
        ArrayList<IMemoryBlock> memories = new ArrayList<IMemoryBlock>();
        if (this.hasBoard() && (type & 1) == 1) {
            memories.addAll(ToolRegistry.getTool(this.board).getMemory());
        }
        if (this.hasMCU() && (type & 2) == 2) {
            memories.addAll(PartRegistry.getPart(this.getCpu()).getInternFlash());
        }
        return memories;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (!this.name.equals(name)) {
            this.dirty = true;
        }
        this.name = name;
    }

    @Override
    public String getCpu() {
        return this.cpu;
    }

    @Override
    public Part getPart() {
        return PartRegistry.getPart(this.cpu);
    }

    @Override
    public void setCpu(String cpu) {
        if (!this.cpu.equals(cpu)) {
            this.dirty = true;
        }
        this.cpu = cpu;
    }

    @Override
    public String getSerial() {
        return this.serial;
    }

    @Override
    public boolean hasBoard() {
        return !this.getBoardName().equals(EMPTY_STRING);
    }

    @Override
    public boolean hasAdapter() {
        return !this.getAdapterName().equals(EMPTY_STRING);
    }

    @Override
    public boolean hasMCU() {
        return this.getCpu() != null && !this.getCpu().equals(EMPTY_STRING);
    }

    @Override
    public void setSerial(String serial) {
        if (!this.serial.equals(serial)) {
            this.dirty = true;
        }
        this.serial = serial;
    }

    @Override
    public synchronized boolean isWorking() {
        return this.working;
    }

    @Override
    public synchronized void setWorking(boolean connected) {
        this.working = connected;
    }

    @Override
    public boolean isDefault() {
        return this.fDefault;
    }

    @Override
    public void setDefault(boolean value) {
        if (this.fDefault != value) {
            this.dirty = true;
        }
        this.fDefault = value;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IWorkbenchAdapter.class) {
            return this;
        }
        if (adapter == IPropertySource.class) {
            if (this.properties == null) {
                this.properties = new TargetPropertySource(this);
            }
            return this.properties;
        }
        return null;
    }

    @Override
    public HashMap<String, String> getAttributes() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", this.name);
        map.put("id", Integer.toString(this.Id));
        map.put("adapter", this.adapter);
        map.put("board", this.board);
        map.put("cpu", this.cpu);
        map.put("serial", this.serial);
        map.put("binary", this.lastBinary);
        map.put("binary-date", Long.toString(this.lastBinaryDateTime));
        map.put("connection-type", this.connectionType);
        map.put("comport", this.comport);
        map.put("clocksource", Integer.toString(this.fClockSource));
        map.put("default", new Boolean(this.fDefault).toString());
        map.put("daisyenabled", Boolean.toString(this.isDaisyChainConfigured()));
        map.put("daisydevsbefore", Integer.toString(this.getDaisyDevsBefore()));
        map.put("daisydevsafter", Integer.toString(this.getDaisyDevsAfter()));
        map.put("daisybitsbefore", Integer.toString(this.getDaisyBitsBefore()));
        map.put("daisybitsafter", Integer.toString(this.getDaisyBitsAfter()));
        return map;
    }

    @Override
    public String getAdapterName() {
        if (this.adapter == null) {
            return EMPTY_STRING;
        }
        return this.adapter;
    }

    @Override
    public ImageDescriptor getIcon() {
        Tool adapter = ToolRegistry.getTool(this.getAdapterName());
        if (!this.hasAdapter() || adapter == null) {
            return AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.atmel.avr32.target", (String)DEFAULT_DEBUGGER_ICON);
        }
        ImageDescriptor icon = adapter.getIcon();
        if (icon == null) {
            icon = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.atmel.avr32.target", (String)DEFAULT_DEBUGGER_ICON);
        }
        return icon;
    }

    @Override
    public void setAdapterName(String adapter) {
        if (!this.adapter.equals(adapter)) {
            this.dirty = true;
        }
        this.adapter = adapter;
    }

    @Override
    public String getBoardName() {
        if (this.adapter == null) {
            return EMPTY_STRING;
        }
        return this.board;
    }

    @Override
    public void setBoardName(String board) {
        if (!this.board.equals(board)) {
            this.dirty = true;
        }
        this.board = board;
    }

    @Override
    public String getConnectionType() {
        return this.connectionType;
    }

    @Override
    public void setConnectionType(String connectionType) {
        if (!this.connectionType.equals(connectionType)) {
            this.dirty = true;
        }
        this.connectionType = connectionType;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        if (!this.description.equals(description)) {
            this.dirty = true;
        }
        this.description = description;
    }

    @Override
    public int getId() {
        return this.Id;
    }

    @Override
    public void setId(int id) {
        if (this.Id != id) {
            this.dirty = true;
        }
        this.Id = id;
    }

    @Override
    public String getLastBinary() {
        return this.lastBinary;
    }

    @Override
    public void setLastBinary(String lastBinary) {
        if (!this.lastBinary.equals(lastBinary)) {
            this.dirty = true;
        }
        this.lastBinary = lastBinary;
    }

    @Override
    public long getLastBinaryDateTime() {
        return this.lastBinaryDateTime;
    }

    @Override
    public void setLastBinaryDateTime(long lastBinaryDateTime) {
        if (this.lastBinaryDateTime != lastBinaryDateTime) {
            this.dirty = true;
        }
        this.lastBinaryDateTime = lastBinaryDateTime;
    }

    @Override
    public boolean isValid() {
        block13: {
            block11: {
                Tool tool;
                block12: {
                    block10: {
                        block8: {
                            block9: {
                                if (!this.hasMCU()) {
                                    return false;
                                }
                                try {
                                    if (!this.hasAdapter()) break block8;
                                    tool = ToolRegistry.getTool(this.getAdapterName());
                                    if (tool != null) break block9;
                                    return false;
                                }
                                catch (CoreException coreException) {}
                            }
                            if (!tool.getTargetConfigurationValidator().isValid(this).isOK()) {
                                return false;
                            }
                            break block10;
                        }
                        return false;
                    }
                    if (!this.hasBoard()) break block11;
                    tool = ToolRegistry.getTool(this.getBoardName());
                    if (tool != null) break block12;
                    return false;
                }
                if (!tool.getTargetConfigurationValidator().isValid(this).isOK()) {
                    return false;
                }
                break block13;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Target)) {
            return false;
        }
        if (!this.name.equals(((Target)obj).name)) {
            return false;
        }
        if (!this.adapter.equals(((Target)obj).adapter)) {
            return false;
        }
        if (!this.board.equals(((Target)obj).board)) {
            return false;
        }
        if (!this.serial.equals(((Target)obj).serial)) {
            return false;
        }
        if (!this.cpu.equals(((Target)obj).cpu)) {
            return false;
        }
        if (!this.comport.equals(((Target)obj).comport)) {
            return false;
        }
        if (!this.connectionType.equals(((Target)obj).connectionType)) {
            return false;
        }
        return this.fClockSource == ((ITarget)obj).getClockSource();
    }

    @Override
    public String getComport() {
        return this.comport;
    }

    @Override
    public void setComport(String comport) {
        if (!comport.equals(this.comport)) {
            this.dirty = true;
        }
        this.comport = comport;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean flag) {
        this.dirty = flag;
    }

    @Override
    public String getTooltip() {
        StringBuffer sb = new StringBuffer();
        if (!this.isValid()) {
            sb.append(Messages.Target_1);
            if (!this.hasAdapter()) {
                sb.append(Messages.Target_2);
            }
            if (!this.hasBoard()) {
                sb.append(Messages.Target_3);
            }
            if (!this.hasMCU()) {
                sb.append(Messages.Target_4);
            }
        } else {
            sb.append(this.getName());
        }
        return sb.toString();
    }

    @Override
    public int getClockSource() {
        return this.fClockSource;
    }

    @Override
    public void setClockSource(int clockSource) {
        if (this.fClockSource != clockSource) {
            this.dirty = true;
        }
        this.fClockSource = clockSource;
    }

    @Override
    public int getDaisyBitsAfter() {
        return this.daisyBitsAfter;
    }

    @Override
    public int getDaisyBitsBefore() {
        return this.daisyBitsBefore;
    }

    @Override
    public int getDaisyDevsAfter() {
        return this.daisyDevsAfter;
    }

    @Override
    public int getDaisyDevsBefore() {
        return this.daisyDevsBefore;
    }

    @Override
    public void setDaisyBitsAfter(int value) {
        if (this.daisyBitsAfter != value) {
            this.dirty = true;
        }
        this.daisyBitsAfter = value;
    }

    @Override
    public void setDaisyBitsBefore(int value) {
        if (this.daisyBitsBefore != value) {
            this.dirty = true;
        }
        this.daisyBitsBefore = value;
    }

    @Override
    public void setDaisyDevsAfter(int value) {
        if (this.daisyDevsAfter != value) {
            this.dirty = true;
        }
        this.daisyDevsAfter = value;
    }

    @Override
    public void setDaisyDevsBefore(int value) {
        if (this.daisyDevsBefore != value) {
            this.dirty = true;
        }
        this.daisyDevsBefore = value;
    }

    @Override
    public boolean isDaisyChainConfigured() {
        return this.daisyIsEnabled;
    }

    @Override
    public void enableDaisyChain(Boolean id) {
        if (this.daisyIsEnabled != id) {
            this.dirty = true;
        }
        this.daisyIsEnabled = id;
    }

    @Override
    public boolean isDetected() {
        return this.fDetected;
    }

    @Override
    public void setDetected(boolean detected) {
        this.fDetected = detected;
    }
}

