/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target;

import com.atmel.avr32.target.DeviceSeriesCollator;
import com.atmel.avr32.target.Messages;
import com.atmel.avr32.target.TargetPlugin;
import com.atmel.avr32.target.part.internal.FuseFileParser;
import com.atmel.avr32.target.part.internal.XMLPartDescriptionFileHandler;
import com.atmel.avr32.target.part.model.DebugSystem;
import com.atmel.avr32.target.part.model.DeviceSeries;
import com.atmel.avr32.target.part.model.Part;
import com.atmel.avr32.target.tool.model.Capability;
import com.atmel.avr32.util.UtilPlugin;
import com.atmel.avr32.util.xml.IXMLNodeHandler;
import com.atmel.avr32.util.xml.SAXUtils;
import com.atmel.avr32.util.xml.StackedXMLHandler;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class PartRegistry {
    private static final String COMMA = ",";
    private static final String VALUES = "values";
    private static final String PART = "part";
    private static final String ATTR_FAMILY = "family";
    private static final String RESET_VECTOR = "resetVector";
    private static final String NTAP = "ntap";
    private static final String ID = "id";
    private static final String CAPABILITY = "capability";
    private static final String PROVIDES = "provides";
    private static final String TYPE = "type";
    private static final String DWORD_ACCESS = "dword-access";
    private static final String DATA_RANGE = "data-range";
    private static final String AUXILIARY_PORT_OVERRIDE = "auxiliary-port-override";
    private static final String ENABLE = "enable";
    private static final String FEATURE = "feature";
    private static final String CLOCKABLE = "clockable";
    private static final String DATA_MODULES = "data-modules";
    private static final String DESCRIPTION = "description";
    private static final String FEATURES_VALIDATION = "http://xml.org/sax/features/validation";
    private static final String FEATURES_VALIDATION_SCHEMA = "http://apache.org/xml/features/validation/schema";
    private static final String FEATURES_VALIDATION_SCHEMA_FULL_CHECKING = "http://apache.org/xml/features/validation/schema-full-checking";
    private static final String FUSES = "fuses";
    private static final String NAME = "name";
    private static final String NO_NAMESPACE_SCHEMA_LOCATION = "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation";
    private static final String OCD_SYSTEM = "ocd-system";
    private static final String OPTIONS = "options";
    private static HashMap<String, Part> parts = new HashMap();
    private static ArrayList<DeviceSeries> deviceSeries = null;
    private static final String PARTS_EXTENSIONPOINT_ID = "com.atmel.avr32.target.parts";
    private static final String PROGRAM_MODULES = "program-modules";
    private static final String PROJECT_TYPES = "projectTypes";
    private static final String SCHEMA_FUSES_XSD = "/schema/fuses.xsd";
    private static final String START_DATA_TRACE = "start-data-trace";
    private static final String START_PROGRAM_TRACE = "start-program-trace";
    private static final String STOP_DATA_TRACE = "stop-data-trace";
    private static final String STOP_PROGRAM_TRACE = "stop-program-trace";
    private static ArrayList<String> fPartNames;

    private static void addFuseDescriptions(Part part, String name) throws IOException {
        IConfigurationElement[] points;
        String bundleID = null;
        String description = null;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(PARTS_EXTENSIONPOINT_ID);
        IConfigurationElement[] iConfigurationElementArray = points = extensionPoint.getConfigurationElements();
        int n = points.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getAttribute(NAME).equals(name)) {
                bundleID = element.getContributor().getName();
                description = element.getAttribute(FUSES);
            }
            ++n2;
        }
        if (description == null) {
            return;
        }
        Path path = new Path(description);
        URL schemaURL = FileLocator.find((Bundle)TargetPlugin.getDefault().getBundle(), (IPath)new Path(SCHEMA_FUSES_XSD), null);
        URL schemaFile = FileLocator.toFileURL((URL)schemaURL);
        try {
            InputStream st = FileLocator.openStream((Bundle)Platform.getBundle((String)bundleID), (IPath)path, (boolean)false);
            FuseFileParser parser = new FuseFileParser(part);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            XMLReader reader = saxParser.getXMLReader();
            reader.setFeature(FEATURES_VALIDATION, true);
            reader.setFeature(FEATURES_VALIDATION_SCHEMA, true);
            reader.setFeature(FEATURES_VALIDATION_SCHEMA_FULL_CHECKING, true);
            reader.setProperty(NO_NAMESPACE_SCHEMA_LOCATION, schemaFile.toString());
            reader.setContentHandler(parser);
            reader.setErrorHandler(parser);
            InputSource input = new InputSource(st);
            reader.parse(input);
            if (parser.hasErrors()) {
                part.clearFuses();
                TargetPlugin.errorMessage(Messages.PartRegistry_Could_Not_Add_Fuse_Descriptions, MessageFormat.format(Messages.PartRegistry_Fuse_File_Error, path, name, parser.getErrorMessages()));
            }
            if (parser.hasWarnings()) {
                TargetPlugin.warningMessage(Messages.PartRegistry_Problem_In_Fuse_Description, MessageFormat.format(Messages.PartRegistry_Fuse_File_Warning, path, name, parser.getWarningMessages()));
            }
        }
        catch (Exception e) {
            part.clearFuses();
            TargetPlugin.errorMessage(Messages.PartRegistry_Could_Not_Add_Fuse_Descriptions, MessageFormat.format(Messages.PartRegistry_Fuse_File_Fatal, path, name, e.getMessage()));
        }
    }

    private static Attribute[] getAttributes(IConfigurationElement element) {
        String[] names = element.getAttributeNames();
        Attribute[] attributes = new Attribute[element.getAttributeNames().length];
        int a = 0;
        while (a < names.length) {
            Attribute attribute = new Attribute();
            attribute.name = names[a];
            attribute.value = element.getAttribute(names[a]);
            attributes[a] = attribute;
            ++a;
        }
        return attributes;
    }

    private static IConfigurationElement getConfigurationElement(String partName) {
        IConfigurationElement[] points;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(PARTS_EXTENSIONPOINT_ID);
        IConfigurationElement[] iConfigurationElementArray = points = extensionPoint.getConfigurationElements();
        int n = points.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getAttribute(NAME).equals(partName)) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    public static String getDefaultPart() {
        List<String> set = PartRegistry.getPartNames();
        if (set.isEmpty()) {
            return "<NO PARTS!>";
        }
        return set.iterator().next();
    }

    public static Part getPart(String name) {
        Part model;
        if (name != null && !parts.containsKey(name) && (model = PartRegistry.getPartModel(name)) != null) {
            parts.put(model.getName(), model);
        }
        return parts.get(name);
    }

    public static DeviceSeries[] getDeviceSeries() {
        if (deviceSeries == null) {
            IConfigurationElement[] points;
            HashMap<String, DeviceSeries> tempSeries = new HashMap<String, DeviceSeries>();
            HashMap<String, IConfigurationElement> parts = new HashMap<String, IConfigurationElement>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint(PARTS_EXTENSIONPOINT_ID);
            IConfigurationElement[] iConfigurationElementArray = points = extensionPoint.getConfigurationElements();
            int n = points.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                if (configurationElement.getName().equals("series")) {
                    DeviceSeries pf = new DeviceSeries(configurationElement.getAttribute(ID), configurationElement.getAttribute(NAME));
                    tempSeries.put(pf.getId(), pf);
                } else if (configurationElement.getName().equals(PART)) {
                    parts.put(configurationElement.getAttribute(NAME), configurationElement);
                }
                ++n2;
            }
            for (IConfigurationElement iConfigurationElement : parts.values()) {
                DeviceSeries pf;
                String family = iConfigurationElement.getAttribute("series");
                if (family == null || (pf = (DeviceSeries)tempSeries.get(family)) == null) continue;
                pf.addDeviceId(iConfigurationElement.getAttribute(NAME));
            }
            deviceSeries = new ArrayList(tempSeries.values());
            Collections.sort(deviceSeries, new DeviceSeriesCollator());
        }
        return deviceSeries.toArray(new DeviceSeries[deviceSeries.size()]);
    }

    private static Part getPartModel(String name) {
        IConfigurationElement source;
        String description;
        String bundleID;
        block10: {
            bundleID = null;
            description = null;
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint(PARTS_EXTENSIONPOINT_ID);
            IConfigurationElement[] points = extensionPoint.getConfigurationElements();
            source = null;
            IConfigurationElement[] iConfigurationElementArray = points;
            int n = points.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (element.getAttribute(NAME).equals(name) && element.getName().equals(PART)) {
                    bundleID = element.getContributor().getName();
                    description = element.getAttribute(DESCRIPTION);
                    source = element;
                    break;
                }
                ++n2;
            }
            if (description != null) break block10;
            return null;
        }
        try {
            Path path = new Path(description);
            InputStream st = FileLocator.openStream((Bundle)Platform.getBundle(bundleID), (IPath)path, (boolean)false);
            String partFamilyId = source.getAttribute(ATTR_FAMILY);
            Part part = new Part(partFamilyId);
            StackedXMLHandler parser = new StackedXMLHandler((IXMLNodeHandler)new XMLPartDescriptionFileHandler(part));
            SAXUtils.parse((InputStream)st, (ContentHandler)parser);
            if (source.getChildren(PROVIDES).length > 0) {
                ArrayList<Capability> caps = PartRegistry.retrieveCapabilities(source.getChildren(PROVIDES)[0]);
                part.setCapabilities(caps);
            }
            PartRegistry.addFuseDescriptions(part, name);
            if (source.getAttribute(CLOCKABLE) != null) {
                part.setClockable(Boolean.parseBoolean(source.getAttribute(CLOCKABLE)));
            }
            if (source.getAttribute(RESET_VECTOR) != null) {
                part.setResetVector(source.getAttribute(RESET_VECTOR));
            }
            PartRegistry.getOCDSystem(source, part);
            return part;
        }
        catch (ParserConfigurationException e) {
            UtilPlugin.error((Object)("ParserConfigurationException occured while parsing part description file for " + name + ": " + e));
        }
        catch (SAXException e) {
            UtilPlugin.error((Object)("Error while parsing part description file for " + name + ": " + e));
        }
        catch (IOException e) {
            UtilPlugin.error((Object)("File error while reading part description file for " + name + ": " + e));
        }
        return null;
    }

    private static void getOCDSystem(IConfigurationElement source, Part newPart) {
        IConfigurationElement[] features;
        IConfigurationElement ocd = source.getChildren(OCD_SYSTEM)[0];
        DebugSystem ds = newPart.getDebugSystem();
        ds.setDataModules(Integer.parseInt(ocd.getAttribute(DATA_MODULES)));
        ds.setProgramModules(Integer.parseInt(ocd.getAttribute(PROGRAM_MODULES)));
        if (ocd.getAttribute(START_PROGRAM_TRACE) != null) {
            ds.setStartPTW(Integer.parseInt(ocd.getAttribute(START_PROGRAM_TRACE)));
        }
        if (ocd.getAttribute(STOP_PROGRAM_TRACE) != null) {
            ds.setStopPTW(Integer.parseInt(ocd.getAttribute(STOP_PROGRAM_TRACE)));
        }
        if (ocd.getAttribute(START_DATA_TRACE) != null) {
            ds.setStartDTW(Integer.parseInt(ocd.getAttribute(START_DATA_TRACE)));
        }
        if (ocd.getAttribute(STOP_DATA_TRACE) != null) {
            ds.setStopDTW(Integer.parseInt(ocd.getAttribute(STOP_DATA_TRACE)));
        }
        IConfigurationElement[] iConfigurationElementArray = features = ocd.getChildren(FEATURE);
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            if (configurationElement.getAttribute(TYPE).equals(AUXILIARY_PORT_OVERRIDE)) {
                ds.setAuxiliaryPortOverrideSupported(true);
                ds.setAuxiliaryPortValues(configurationElement.getAttribute(VALUES).split(COMMA));
            }
            if (configurationElement.getAttribute(TYPE).equals(DATA_RANGE)) {
                ds.setDataRangeSupported(true);
            }
            if (configurationElement.getAttribute(TYPE).equals(DWORD_ACCESS)) {
                ds.setDwordAccessSupported(true);
            }
            if (configurationElement.getAttribute(TYPE).equals(NTAP)) {
                ds.setNTAPSupported(true);
            }
            ++n2;
        }
    }

    public static synchronized List<String> getPartNames() {
        if (fPartNames == null) {
            IConfigurationElement[] points;
            fPartNames = new ArrayList();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint(PARTS_EXTENSIONPOINT_ID);
            IConfigurationElement[] iConfigurationElementArray = points = extensionPoint.getConfigurationElements();
            int n = points.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (element.getName().equals(PART)) {
                    fPartNames.add(element.getAttribute(NAME).trim());
                }
                ++n2;
            }
            Collections.sort(fPartNames, Collator.getInstance());
        }
        return fPartNames;
    }

    public static String[] getProjectTypes(String partName) {
        if (partName == null || partName.length() == 0) {
            return new String[0];
        }
        String allowedTypeList = PartRegistry.getConfigurationElement(partName).getAttribute(PROJECT_TYPES);
        String[] allowedTypes = new String[]{};
        if (allowedTypeList != null) {
            allowedTypes = allowedTypeList.split(COMMA);
        }
        IProjectType[] projectTypes = ManagedBuildManager.getDefinedProjectTypes();
        ArrayList<String> filteredTypes = new ArrayList<String>();
        IProjectType[] iProjectTypeArray = projectTypes;
        int n = projectTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IProjectType projectType = iProjectTypeArray[n2];
            String[] stringArray = allowedTypes;
            int n3 = allowedTypes.length;
            int n4 = 0;
            while (n4 < n3) {
                String allowedType = stringArray[n4];
                if (allowedType.equals(projectType.getBaseId()) && !projectType.isAbstract()) {
                    filteredTypes.add(projectType.getId());
                }
                ++n4;
            }
            ++n2;
        }
        return filteredTypes.toArray(new String[filteredTypes.size()]);
    }

    public static String getToolchainOption(String partName) {
        return PartRegistry.getConfigurationElement(partName).getAttribute(OPTIONS);
    }

    private static ArrayList<Capability> retrieveCapabilities(IConfigurationElement root) {
        IConfigurationElement[] children;
        ArrayList<Capability> capabilities = new ArrayList<Capability>();
        IConfigurationElement[] iConfigurationElementArray = children = root.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement capabilityElement = iConfigurationElementArray[n2];
            if (capabilityElement.getName().equals(CAPABILITY)) {
                Attribute[] attributes = PartRegistry.getAttributes(capabilityElement);
                Capability capability = new Capability();
                int a = 0;
                while (a < attributes.length) {
                    String name = attributes[a].name;
                    String value = attributes[a].value;
                    if (name.equals(NAME)) {
                        capability.setName(value);
                    }
                    if (name.equals(ID)) {
                        capability.setId(value);
                    }
                    ++a;
                }
                capabilities.add(capability);
            }
            ++n2;
        }
        return capabilities;
    }

    private static class Attribute {
        protected String name;
        protected String value;

        private Attribute() {
        }
    }
}

