/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target;

import com.atmel.avr32.target.PartRegistry;
import com.atmel.avr32.target.part.model.Fuse;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;

public class FuseRegisterSettings {
    private static final String HEX_PREFIX = "0x";
    private static final String MCU = "MCU";
    private String group = "gp";
    private IStatus status;
    private long value;
    private Properties values = new Properties();

    public FuseRegisterSettings() {
    }

    public FuseRegisterSettings(IPath file) throws CoreException, IOException {
        this.load(file);
    }

    public FuseRegisterSettings(String mcu) {
        this.values.setProperty(MCU, mcu);
    }

    private void compose() {
        this.value = 0L;
        String mcu = this.values.getProperty(MCU);
        ArrayList<Fuse> fuses = PartRegistry.getPart(mcu).getFuses();
        for (Fuse fuse : fuses) {
            String sval;
            if (!fuse.getGroup().equals(this.getGroup()) || (sval = this.values.getProperty(fuse.getName())) == null) continue;
            long fval = Long.decode(sval);
            this.value |= fval << (int)fuse.getOffset();
        }
    }

    public boolean containsFuse(String id) {
        return this.values.containsKey(id);
    }

    private void decompose() {
        String mcu = this.values.getProperty(MCU);
        ArrayList<Fuse> fuses = PartRegistry.getPart(mcu).getFuses();
        for (Fuse fuse : fuses) {
            if (!fuse.getGroup().equals(this.getGroup())) continue;
            long fval = (long)((1 << fuse.getLength()) - 1) & this.value >> (int)fuse.getOffset();
            this.values.setProperty(fuse.getName(), HEX_PREFIX + Long.toHexString(fval));
        }
    }

    public String getGroup() {
        return this.group;
    }

    public String getPartId() {
        return this.values.getProperty(MCU);
    }

    public String getFuseValue(String key) {
        return this.values.getProperty(key);
    }

    public IStatus getStatus() {
        return this.status;
    }

    public long getRegisterValue() {
        this.compose();
        return this.value;
    }

    public Properties getValues() {
        return this.values;
    }

    public void load(IPath file) throws CoreException, IOException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile f = root.getFile(file);
        f.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
        this.values.load(f.getContents());
        f.getContents().close();
        this.compose();
    }

    public void save(IPath file) throws IOException, CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile f = root.getFile(file);
        FileOutputStream fos = new FileOutputStream(f.getLocation().toFile());
        this.values.store(fos, null);
        fos.close();
        f.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setFuseValue(String key, String value) {
        this.values.setProperty(key, value);
    }

    public void setStatus(IStatus status) {
        this.status = status;
    }

    public void setRegisterValue(long value) {
        this.value = value;
        this.decompose();
    }

    public void setValues(Properties values) {
        this.values = values;
    }
}

