/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target;

import com.atmel.avr32.managedbuilder.WindowsBuildPathResolver;
import com.atmel.avr32.target.ITarget;
import com.atmel.avr32.target.ITargetInterface;
import com.atmel.avr32.target.Messages;
import com.atmel.avr32.target.TargetCommandStatus;
import com.atmel.avr32.target.TargetPlugin;
import com.atmel.avr32.target.launch.ErrorStreamConsumer;
import com.atmel.avr32.target.launch.OutputStreamConsumer;
import com.atmel.avr32.util.UtilPlugin;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;

public abstract class AbstractAdapterInterface
implements ITargetInterface {
    private static final String EQUALS = "=";
    private static final String OPTION_C = "/C";
    private static final String PATH = "PATH";
    private static final String CMD_EXE = "cmd.exe";
    private ITarget target;

    @Deprecated
    protected IStatus createProcess(ArrayList<String> args, boolean wait, ILaunch launch, IProgressMonitor monitor) {
        return this.createProcess(args, wait ? WaitMode.WAIT : WaitMode.NO_WAIT, launch, monitor);
    }

    protected TargetCommandStatus createProcess(ArrayList<String> args, WaitMode mode, ILaunch launch, IProgressMonitor monitor) {
        String path = WindowsBuildPathResolver.getBinPath();
        if (path == null) {
            return new TargetCommandStatus(4, "com.atmel.avr32.target", Messages.AbstractAdapterInterface_NoSearchPath, null);
        }
        ArrayList<String> envp = new ArrayList<String>();
        if (WindowsBuildPathResolver.isWindows()) {
            path = "PATH=" + path.replaceAll("/", "\\\\");
        }
        envp.add(path);
        Map<String, String> vars = System.getenv();
        for (String string : vars.keySet()) {
            if (!string.equals(PATH)) {
                envp.add(String.valueOf(string) + EQUALS + vars.get(string));
                continue;
            }
            envp.add("PATH=" + path);
        }
        if (WindowsBuildPathResolver.isWindows()) {
            args.add(0, OPTION_C);
            args.add(0, CMD_EXE);
        }
        return this.createProcess(args, envp, mode, launch, monitor);
    }

    @Deprecated
    protected IStatus createProcess(ArrayList<String> args, ArrayList<String> envp, boolean wait, ILaunch launch, IProgressMonitor monitor) {
        return this.createProcess(args, envp, wait ? WaitMode.WAIT : WaitMode.NO_WAIT, launch, monitor);
    }

    protected TargetCommandStatus createProcess(ArrayList<String> args, ArrayList<String> envp, WaitMode mode, ILaunch launch, IProgressMonitor monitor) {
        block17: {
            ErrorStreamConsumer esc = null;
            OutputStreamConsumer osc = null;
            StringBuffer command = new StringBuffer();
            for (String string : args) {
                command.append(string);
                command.append(' ');
            }
            long start = System.currentTimeMillis();
            UtilPlugin.println((Object)MessageFormat.format(Messages.AbstractAdapterInterface_Executing, command.toString(), mode.toString()));
            Process process = null;
            try {
                String label = args.get(0).equalsIgnoreCase(CMD_EXE) ? args.get(2) : args.get(0);
                process = ProcessFactory.getFactory().exec(args.toArray(new String[args.size()]), envp.toArray(new String[envp.size()]));
                IProcess p = null;
                if (launch != null) {
                    launch.setAttribute("org.eclipse.debug.core.capture_output", null);
                    p = DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)label);
                    p.setAttribute(IProcess.ATTR_CMDLINE, command.toString());
                    p.setAttribute(IProcess.ATTR_PROCESS_TYPE, args.get(0));
                }
                if (launch != null) {
                    esc = new ErrorStreamConsumer(monitor, p);
                    osc = new OutputStreamConsumer(monitor, p);
                } else {
                    esc = new ErrorStreamConsumer(process, monitor);
                    osc = new OutputStreamConsumer(process, monitor);
                }
                if (mode == WaitMode.WAIT) {
                    process.waitFor();
                    TargetPlugin.debug(MessageFormat.format(Messages.AbstractAdapterInterface_Done, new Long(System.currentTimeMillis() - start)));
                    if (process.exitValue() != 0) {
                        return this.handleError(esc, process.exitValue(), label);
                    }
                    return new TargetCommandStatus(0, "com.atmel.avr32.target", command.toString(), osc.getResult());
                }
                if (mode == WaitMode.NO_WAIT) {
                    Thread.sleep(1500L);
                    try {
                        TargetPlugin.debug(MessageFormat.format(Messages.AbstractAdapterInterface_Done, new Long(System.currentTimeMillis() - start)));
                        if (process.exitValue() != 0) {
                            return this.handleError(esc, process.exitValue(), label);
                        }
                        break block17;
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {}
                    break block17;
                }
                if (mode != WaitMode.PROGRESS) break block17;
                boolean running = true;
                int exit = 0;
                while (running && !esc.isDone()) {
                    try {
                        exit = process.exitValue();
                        running = false;
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {}
                    Thread.sleep(100L);
                }
                TargetPlugin.debug(MessageFormat.format(Messages.AbstractAdapterInterface_Done, new Long(System.currentTimeMillis() - start)));
                if (exit != 0) {
                    return this.handleError(esc, exit, label);
                }
            }
            catch (IOException e) {
                return new TargetCommandStatus(4, "com.atmel.avr32.target", e.getMessage(), null, e);
            }
            catch (InterruptedException e) {
                return new TargetCommandStatus(4, "com.atmel.avr32.target", Messages.AbstractAdapterInterface_FailedInterrupted, null, e);
            }
        }
        return TargetCommandStatus.OK_STATUS;
    }

    private TargetCommandStatus handleError(ErrorStreamConsumer esc, int exitCode, String label) {
        UtilPlugin.error((Object)MessageFormat.format(Messages.AbstractAdapterInterface_FailedWithCode, new Integer(exitCode)));
        String reason = esc.getResult();
        if (reason != null) {
            return new TargetCommandStatus(4, "com.atmel.avr32.target", exitCode, reason, null, null);
        }
        return new TargetCommandStatus(4, "com.atmel.avr32.target", MessageFormat.format(Messages.AbstractAdapterInterface_Failed, label), null);
    }

    public ITarget getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(ITarget target) {
        this.target = target;
    }

    protected String[] splitLines(String lines) {
        return lines.split("\\n|\\r\\n|\\r");
    }

    @Override
    public TargetCommandStatus getStatus() {
        return TargetCommandStatus.CANCEL_STATUS;
    }

    public static enum WaitMode {
        NO_WAIT,
        WAIT,
        PROGRESS;

    }
}

