/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.tool.avrfwupgrade.internal;

import com.atmel.avr32.target.ToolRegistry;
import com.atmel.avr32.target.tool.model.Tool;
import com.atmel.avr32.target.ui.TargetAction;
import com.atmel.avr32.tool.avrfwupgrade.internal.AVRFWUpgradeInterface;
import com.atmel.avr32.tool.avrfwupgrade.internal.Firmware;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class ProgramFirmwareActionMenu
extends TargetAction {
    public IContributionItem getContents() {
        MenuManager menu = new MenuManager("Upgrade firmware");
        if (this.fSelectedTarget == null) {
            return menu;
        }
        Firmware defaultFirmware = AVRFWUpgradeInterface.getDefaultFirmware(this.fSelectedTarget);
        if (defaultFirmware != null) {
            menu.add((IContributionItem)this.getInstallAction("Latest Version", defaultFirmware));
        }
        Firmware[] firmwares = AVRFWUpgradeInterface.getAvailableFirmware();
        Tool tool = ToolRegistry.getTool((String)this.fSelectedTarget.getAdapterName());
        Firmware[] firmwareArray = firmwares;
        int n = firmwares.length;
        int n2 = 0;
        while (n2 < n) {
            Firmware firmware = firmwareArray[n2];
            if (firmware.getTool().equals(tool.getId()) && !firmware.isInstall() && firmware.getTitle() != null && firmware.getTitle().length() > 0) {
                menu.add((IContributionItem)this.getInstallAction(firmware.getTitle(), firmware));
            }
            ++n2;
        }
        if (menu.isEmpty() && defaultFirmware == null) {
            return null;
        }
        if (menu.getItems().length == 1) {
            ContributionItem ci = this.getInstallAction("Upgrade Firmware", defaultFirmware);
            return ci;
        }
        return menu;
    }

    private ContributionItem getInstallAction(final String title, final Firmware defaultFirmware) {
        ContributionItem ci = new ContributionItem(){

            public void fill(Menu menu, int index) {
                MenuItem mi = new MenuItem(menu, 0, index);
                mi.setText(title);
                mi.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        AVRFWUpgradeInterface.forceInstall(ProgramFirmwareActionMenu.this.fSelectedTarget, defaultFirmware);
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
            }
        };
        return ci;
    }
}

