/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.tool.avrfwupgrade.internal;

import com.atmel.avr32.target.AbstractAdapterInterface;
import com.atmel.avr32.target.GenericTargetInterface;
import com.atmel.avr32.target.ITarget;
import com.atmel.avr32.target.ITargetFirmwareInterface;
import com.atmel.avr32.target.TargetCommandStatus;
import com.atmel.avr32.target.TargetJob;
import com.atmel.avr32.target.TargetPlugin;
import com.atmel.avr32.target.ToolRegistry;
import com.atmel.avr32.target.tool.model.Tool;
import com.atmel.avr32.target.ui.TargetAction;
import com.atmel.avr32.tool.avrfwupgrade.internal.Firmware;
import com.atmel.avr32.tool.avrfwupgrade.internal.Messages;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class AVRFWUpgradeInterface
extends GenericTargetInterface
implements ITargetFirmwareInterface {
    private static final String STATUS_UNKNOWN = "unknown";
    private static final String FIRMWARE_EXTENSION_ID = "com.atmel.avr32.target.firmware";
    private static final String CLEAN_OPTION = "--clean";
    private static final String FORCE_OPTION = "--force";
    private static final String UPGRADE_REQUIRED = "UpgradeRequired";
    private static final String UPGRADE_RECOMMENDED = "UpgradeRecommended";
    private static final String AVRFWUPGRADE = "avrfwupgrade";
    private static final String FIRMWARE_OPTION = "--archive";
    private static final String PLATFORM_OPTION = "--platform";
    private static final String INFO_OPTION = "--info";
    private static final String GUI_OPTION = "--gui";
    private static final String SERIAL_NR_OPTION = "--serialnum";
    private static final String PLUGIN_ID = "com.atmel.avr32.tool.avrfwupgrade";
    private ReentrantLock fLock = new ReentrantLock();

    public IStatus list(IProgressMonitor monitor) {
        ITarget[] targets;
        Firmware[] fw = AVRFWUpgradeInterface.getAvailableFirmware();
        ITarget[] iTargetArray = targets = TargetPlugin.getTargetManager().getTargets();
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            ITarget target = iTargetArray[n2];
            Tool tool = ToolRegistry.getTool((String)target.getAdapterName());
            if (tool != null && target.getSerial().length() > 0 && target.isDetected()) {
                Firmware[] firmwareArray = fw;
                int n3 = fw.length;
                int n4 = 0;
                while (n4 < n3) {
                    Firmware firmware = firmwareArray[n4];
                    if (firmware.tool.equals(tool.getId()) && firmware.isInstall()) {
                        this.testAndUpdate(target, firmware, false);
                        break;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    public static Firmware[] getAvailableFirmware() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(FIRMWARE_EXTENSION_ID);
        IConfigurationElement[] frameworks = extensionPoint.getConfigurationElements();
        ArrayList<Firmware> fw = new ArrayList<Firmware>();
        IConfigurationElement[] iConfigurationElementArray = frameworks;
        int n = frameworks.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            Firmware firmware = new Firmware();
            firmware.file = configurationElement.getAttribute("file");
            firmware.tool = configurationElement.getAttribute("tool");
            firmware.title = configurationElement.getAttribute("name");
            firmware.bundle = Platform.getBundle((String)configurationElement.getContributor().getName());
            firmware.install = Boolean.parseBoolean(configurationElement.getAttribute("install"));
            fw.add(firmware);
            ++n2;
        }
        return fw.toArray(new Firmware[fw.size()]);
    }

    private void testAndUpdate(final ITarget target, final Firmware firmware, final boolean tell) {
        TargetJob tj = new TargetJob(MessageFormat.format(Messages.AVRFWUpgradeInterface_TestJobTitle, target.getName()), target){

            protected IStatus run(IProgressMonitor monitor) {
                TargetCommandStatus status = TargetCommandStatus.OK_STATUS;
                try {
                    if (AVRFWUpgradeInterface.this.fLock.tryLock(30L, TimeUnit.SECONDS)) {
                        File f = AVRFWUpgradeInterface.this.extractFirmware(firmware);
                        String filePath = f.getAbsolutePath();
                        status = AVRFWUpgradeInterface.this.testFirmwareVersions(target, firmware, filePath);
                        f.delete();
                        if (status.isOK()) {
                            AVRFWUpgradeInterface.this.notifyAndUpgrade(target, firmware, tell, status.getResult());
                        } else if (!tell) {
                            IStatus iStatus = Status.OK_STATUS;
                            return iStatus;
                        }
                    }
                }
                catch (Exception e) {
                    status = new TargetCommandStatus(4, "com.atmel.avr32.target", Messages.AVRFWUpgradeInterface_UpgradeError, null, (Throwable)e);
                }
                finally {
                    AVRFWUpgradeInterface.this.fLock.unlock();
                }
                return status;
            }
        };
        tj.setUser(false);
        tj.schedule();
    }

    public TargetCommandStatus execute(TargetAction action, IProgressMonitor monitor) {
        return this.upgradeAsJob(action.getTarget(), true);
    }

    private void upgrade(final ITarget target, final Firmware firmware, IProgressMonitor monitor) {
        TargetJob tj = new TargetJob(MessageFormat.format(Messages.AVRFWUpgradeInterface_UpgradeJobTitle, target.getName()), target){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    File f = AVRFWUpgradeInterface.this.extractFirmware(firmware);
                    String filePath = f.getAbsolutePath();
                    IStatus status = AVRFWUpgradeInterface.this.upgradeFirmware(target, firmware, filePath, monitor);
                    if (f != null && f.exists()) {
                        f.delete();
                    }
                    return status;
                }
                catch (Exception e) {
                    monitor.setCanceled(true);
                    return new Status(4, AVRFWUpgradeInterface.PLUGIN_ID, Messages.AVRFWUpgradeInterface_UpgradeError, (Throwable)e);
                }
            }
        };
        tj.setPriority(30);
        tj.setUser(false);
        tj.schedule();
    }

    private File extractFirmware(Firmware firmware) throws IOException, FileNotFoundException {
        File f = File.createTempFile("firmware", ".zip");
        InputStream is = FileLocator.openStream((Bundle)firmware.bundle, (IPath)new Path(firmware.file), (boolean)false);
        FileOutputStream fw = new FileOutputStream(f);
        int data = -1;
        while ((data = is.read()) != -1) {
            fw.write(data);
        }
        is.close();
        fw.close();
        return f;
    }

    private void notifyAndUpgrade(ITarget target, Firmware firmware, boolean tell, String result) {
        if (this.updateRecommended(result) || this.updateRequired(result)) {
            if (this.notifyUserUpdateRequired(target)) {
                this.upgrade(target, firmware, (IProgressMonitor)new NullProgressMonitor());
            }
        } else if (tell) {
            this.informUserTargetHasLatest(target);
        }
    }

    private boolean notifyUserUpdateRequired(ITarget target) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        RunnableUpdateDialog update = new RunnableUpdateDialog(display, Messages.AVRFWUpgradeInterface_UpgradeMessage, target, false);
        display.syncExec((Runnable)update);
        return true;
    }

    private boolean askUserUpdate(ITarget target) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        RunnableUpdateDialog update = new RunnableUpdateDialog(display, Messages.AVRFWUpgradeInterface_UpgradeAvailable, target, true);
        display.syncExec((Runnable)update);
        return update.okClicked;
    }

    private boolean updateRequired(String result) {
        return result.indexOf(UPGRADE_REQUIRED) > -1 || this.unknownFirmwareStatus(result);
    }

    private boolean unknownFirmwareStatus(String result) {
        return result.toLowerCase().indexOf(STATUS_UNKNOWN) > -1;
    }

    private boolean updateRecommended(String result) {
        return result.indexOf(UPGRADE_RECOMMENDED) > -1;
    }

    private void informUserTargetHasLatest(final ITarget target) {
        final Display display = PlatformUI.getWorkbench().getDisplay();
        Runnable update = new Runnable(){

            @Override
            public void run() {
                MessageDialog.openInformation((Shell)display.getActiveShell(), (String)Messages.AVRFWUpgradeInterface_UpgradeTitle, (String)MessageFormat.format(Messages.AVRFWUpgradeInterface_HasLatest, target.getAdapterName(), target.getSerial()));
            }
        };
        display.syncExec(update);
    }

    private TargetCommandStatus upgradeAsJob(ITarget target, boolean interactive) {
        Firmware firmware = AVRFWUpgradeInterface.getDefaultFirmware(target);
        if (firmware == null) {
            return new TargetCommandStatus(4, PLUGIN_ID, Messages.AVRFWUpgradeInterface_CannotFind, null);
        }
        this.testAndUpdate(target, firmware, interactive);
        return TargetCommandStatus.OK_STATUS;
    }

    public static IStatus forceInstall(ITarget target, Firmware firmware) {
        AVRFWUpgradeInterface i = new AVRFWUpgradeInterface();
        i.upgrade(target, firmware, (IProgressMonitor)new NullProgressMonitor());
        return TargetCommandStatus.OK_STATUS;
    }

    public IStatus upgrade(ITarget target, boolean interactive) {
        Firmware firmware = AVRFWUpgradeInterface.getDefaultFirmware(target);
        if (firmware == null) {
            return new Status(4, PLUGIN_ID, Messages.AVRFWUpgradeInterface_CannotFind);
        }
        File f = null;
        try {
            f = this.extractFirmware(firmware);
            String filePath = f.getAbsolutePath();
            TargetCommandStatus status = this.testFirmwareVersions(target, firmware, filePath);
            if (!status.isOK()) {
                TargetCommandStatus targetCommandStatus = status;
                return targetCommandStatus;
            }
            String result = status.getResult();
            if (this.updateRequired(result)) {
                if (this.notifyUserUpdateRequired(target)) {
                    IStatus iStatus = this.upgradeFirmware(target, firmware, filePath, (IProgressMonitor)new NullProgressMonitor());
                    return iStatus;
                }
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            if (this.updateRecommended(result)) {
                if (this.askUserUpdate(target)) {
                    IStatus iStatus = this.upgradeFirmware(target, firmware, filePath, (IProgressMonitor)new NullProgressMonitor());
                    return iStatus;
                }
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            if (interactive) {
                this.informUserTargetHasLatest(target);
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (Exception e) {
            e.printStackTrace();
            Status status = new Status(4, "com.atmel.avr32.target", Messages.AVRFWUpgradeInterface_UpgradeError, (Throwable)e);
            return status;
        }
        finally {
            if (f != null) {
                f.delete();
            }
        }
    }

    public static Firmware getDefaultFirmware(ITarget target) {
        Firmware[] fw;
        Firmware[] firmwareArray = fw = AVRFWUpgradeInterface.getAvailableFirmware();
        int n = fw.length;
        int n2 = 0;
        while (n2 < n) {
            Firmware f = firmwareArray[n2];
            Tool tool = ToolRegistry.getTool((String)target.getAdapterName());
            if (f.tool.equals(tool.getId()) && f.install) {
                return f;
            }
            ++n2;
        }
        return null;
    }

    private ArrayList<String> buildCommandLine(ITarget target, String filePath, String tool) {
        ArrayList<String> commandline = new ArrayList<String>();
        commandline.add(AVRFWUPGRADE);
        commandline.add(GUI_OPTION);
        String serial = target.getSerial();
        if (serial != null && serial.length() > 0) {
            commandline.add(SERIAL_NR_OPTION);
            commandline.add(serial);
        }
        commandline.add(PLATFORM_OPTION);
        commandline.add(tool);
        commandline.add(FIRMWARE_OPTION);
        commandline.add(filePath);
        return commandline;
    }

    private TargetCommandStatus testFirmwareVersions(ITarget target, Firmware firmware, String filePath) {
        ArrayList<String> commandline = this.buildCommandLine(target, filePath, firmware.tool);
        commandline.add(INFO_OPTION);
        TargetCommandStatus status = this.createProcess(commandline, AbstractAdapterInterface.WaitMode.WAIT, null, (IProgressMonitor)new NullProgressMonitor());
        return status;
    }

    private IStatus upgradeFirmware(ITarget target, Firmware firmware, String filePath, IProgressMonitor monitor) {
        ArrayList<String> commandline = this.buildCommandLine(target, filePath, firmware.tool);
        commandline.add(FORCE_OPTION);
        commandline.add(CLEAN_OPTION);
        monitor.beginTask(Messages.AVRFWUpgradeInterface_TaskName, -1);
        TargetCommandStatus status = this.createProcess(commandline, AbstractAdapterInterface.WaitMode.WAIT, null, monitor);
        monitor.done();
        return status;
    }

    private class RunnableUpdateDialog
    implements Runnable {
        private boolean okClicked;
        private final String messageFormat;
        private final ITarget target;
        private final Display display;
        private boolean allowCancel;

        public RunnableUpdateDialog(Display display, String messageFormat, ITarget target, boolean allowCancel) {
            this.display = display;
            this.messageFormat = messageFormat;
            this.allowCancel = allowCancel;
            this.target = target;
        }

        @Override
        public void run() {
            if (this.allowCancel) {
                this.okClicked = MessageDialog.openConfirm((Shell)this.display.getActiveShell(), (String)Messages.AVRFWUpgradeInterface_UpgradeTitle, (String)MessageFormat.format(this.messageFormat, this.target.getAdapterName(), this.target.getSerial()));
            } else {
                this.okClicked = true;
                MessageDialog.openInformation((Shell)this.display.getActiveShell(), (String)Messages.AVRFWUpgradeInterface_UpgradeTitle, (String)MessageFormat.format(this.messageFormat, this.target.getAdapterName(), this.target.getSerial()));
            }
        }

        public boolean okClicked() {
            return this.okClicked;
        }
    }
}

