/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.core.data;

import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskMapper
implements ITaskMapping {
    private final boolean createNonExistingAttributes;
    private final TaskData taskData;

    public TaskMapper(TaskData taskData) {
        this(taskData, false);
    }

    public TaskMapper(TaskData taskData, boolean createNonExistingAttributes) {
        this.createNonExistingAttributes = createNonExistingAttributes;
        Assert.isNotNull((Object)taskData);
        this.taskData = taskData;
    }

    public boolean applyTo(ITask task) {
        boolean changed = false;
        if (this.hasChanges(task.getCompletionDate(), this.getCompletionDate(), "task.common.date.completed")) {
            task.setCompletionDate(this.getCompletionDate());
            changed = true;
        }
        if (this.hasChanges(task.getCreationDate(), this.getCreationDate(), "task.common.date.created")) {
            task.setCreationDate(this.getCreationDate());
            changed = true;
        }
        if (this.hasChanges(task.getModificationDate(), this.getModificationDate(), "task.common.date.modified")) {
            task.setModificationDate(this.getModificationDate());
            changed = true;
        }
        if (this.hasChanges(task.getDueDate(), this.getDueDate(), "task.common.date.due")) {
            task.setDueDate(this.getDueDate());
            changed = true;
        }
        if (this.hasChanges(task.getOwner(), this.getOwner(), "task.common.user.assigned")) {
            task.setOwner(this.getOwner());
            changed = true;
        }
        if (this.hasChanges(task.getPriority(), this.getPriorityLevelString(), "task.common.priority")) {
            task.setPriority(this.getPriorityLevelString());
            changed = true;
        }
        if (this.hasChanges(task.getSummary(), this.getSummary(), "task.common.summary")) {
            task.setSummary(this.getSummary());
            changed = true;
        }
        if (this.hasChanges(task.getTaskKey(), this.getTaskKey(), "task.common.key")) {
            task.setTaskKey(this.getTaskKey());
            changed = true;
        }
        if (this.hasChanges(task.getTaskKind(), this.getTaskKind(), "task.common.kind")) {
            task.setTaskKind(this.getTaskKind());
            changed = true;
        }
        if (this.hasChanges(task.getUrl(), this.getTaskUrl(), "task.common.url")) {
            task.setUrl(this.getTaskUrl());
            changed = true;
        }
        return changed;
    }

    private String getPriorityLevelString() {
        return this.getPriorityLevel() != null ? this.getPriorityLevel().toString() : ITask.PriorityLevel.getDefault().toString();
    }

    private boolean hasChanges(Object existingValue, Object newValue, String attributeId) {
        TaskAttribute attribute = this.taskData.getRoot().getMappedAttribute(attributeId);
        if (attribute != null) {
            return this.areNotEquals(existingValue, newValue);
        }
        return false;
    }

    private boolean areNotEquals(Object existingProperty, Object newProperty) {
        return existingProperty != null ? !existingProperty.equals(newProperty) : newProperty != null;
    }

    private void copyAttributeValue(TaskAttribute sourceAttribute, TaskAttribute targetAttribute) {
        block5: {
            if (targetAttribute == null) {
                return;
            }
            if (targetAttribute.getMetaData().isReadOnly()) break block5;
            targetAttribute.clearValues();
            if (targetAttribute.getOptions().size() > 0) {
                List<String> values = sourceAttribute.getValues();
                for (String value : values) {
                    if (!targetAttribute.getOptions().containsKey(value)) continue;
                    targetAttribute.addValue(value);
                }
            } else {
                List<String> values = sourceAttribute.getValues();
                for (String value : values) {
                    targetAttribute.addValue(value);
                }
            }
        }
    }

    @Override
    public void merge(ITaskMapping source) {
        if (source.getTaskData() != null && this.getTaskData() != null && source.getTaskData().getConnectorKind().equals(this.getTaskData().getConnectorKind())) {
            for (TaskAttribute sourceAttribute : source.getTaskData().getRoot().getAttributes().values()) {
                this.copyAttributeValue(sourceAttribute, this.getTaskData().getRoot().getAttribute(sourceAttribute.getId()));
            }
        } else {
            if (source.getCc() != null) {
                this.setCc(source.getCc());
            }
            if (source.getDescription() != null) {
                this.setDescription(source.getDescription());
            }
            if (source.getComponent() != null) {
                this.setComponent(source.getComponent());
            }
            if (source.getKeywords() != null) {
                this.setKeywords(source.getKeywords());
            }
            if (source.getOwner() != null) {
                this.setOwner(source.getOwner());
            }
            if (source.getPriorityLevel() != null) {
                this.setPriorityLevel(source.getPriorityLevel());
            }
            if (source.getProduct() != null) {
                this.setProduct(source.getProduct());
            }
            if (source.getSeverity() != null) {
                this.setSeverity(source.getSeverity());
            }
            if (source.getSummary() != null) {
                this.setSummary(source.getSummary());
            }
            if (source.getVersion() != null) {
                this.setVersion(source.getVersion());
            }
        }
    }

    private TaskAttribute createAttribute(String attributeKey, String type) {
        attributeKey = this.taskData.getAttributeMapper().mapToRepositoryKey(this.taskData.getRoot(), attributeKey);
        TaskAttribute attribute = this.taskData.getRoot().createAttribute(attributeKey);
        attribute.getMetaData().defaults().setType(type);
        return attribute;
    }

    @Override
    public List<String> getCc() {
        return this.getValues("task.common.user.cc");
    }

    @Override
    public Date getCompletionDate() {
        return this.getDateValue("task.common.date.completed");
    }

    @Override
    public String getComponent() {
        return this.getValue("task.common.component");
    }

    @Override
    public Date getCreationDate() {
        return this.getDateValue("task.common.date.created");
    }

    private Date getDateValue(String attributeKey) {
        TaskAttribute attribute = this.taskData.getRoot().getMappedAttribute(attributeKey);
        if (attribute != null) {
            return this.taskData.getAttributeMapper().getDateValue(attribute);
        }
        return null;
    }

    @Override
    public String getDescription() {
        return this.getValue("task.common.description");
    }

    @Override
    public Date getDueDate() {
        return this.getDateValue("task.common.date.due");
    }

    @Override
    public List<String> getKeywords() {
        return this.getValues("task.common.keywords");
    }

    private TaskAttribute getWriteableAttribute(String attributeKey, String type) {
        TaskAttribute attribute = this.taskData.getRoot().getMappedAttribute(attributeKey);
        if (this.createNonExistingAttributes) {
            if (attribute == null) {
                attribute = this.createAttribute(attributeKey, type);
            }
        } else if (attribute != null && attribute.getMetaData().isReadOnly()) {
            return null;
        }
        return attribute;
    }

    @Override
    public Date getModificationDate() {
        return this.getDateValue("task.common.date.modified");
    }

    @Override
    public String getOwner() {
        return this.getValue("task.common.user.assigned");
    }

    @Override
    public String getPriority() {
        return this.getValue("task.common.priority");
    }

    @Override
    public ITask.PriorityLevel getPriorityLevel() {
        String value = this.getPriority();
        return value != null ? ITask.PriorityLevel.fromString(value) : null;
    }

    @Override
    public String getProduct() {
        return this.getValue("task.common.product");
    }

    @Override
    public String getReporter() {
        return this.getValue("task.common.user.reporter");
    }

    @Override
    public String getResolution() {
        return this.getValue("task.common.resolution");
    }

    @Override
    public String getSeverity() {
        return this.getValue("task.common.severity");
    }

    @Override
    public String getSummary() {
        return this.getValue("task.common.summary");
    }

    @Override
    public String getStatus() {
        return this.getValue("task.common.status");
    }

    @Override
    public TaskData getTaskData() {
        return this.taskData;
    }

    @Override
    public String getTaskKey() {
        return this.getValue("task.common.key");
    }

    @Override
    public String getTaskKind() {
        return this.getValue("task.common.kind");
    }

    @Override
    public String getTaskStatus() {
        return this.getValue("task.common.status");
    }

    @Override
    public String getTaskUrl() {
        return this.getValue("task.common.url");
    }

    public String getValue(String attributeKey) {
        TaskAttribute attribute = this.taskData.getRoot().getMappedAttribute(attributeKey);
        if (attribute != null) {
            return this.taskData.getAttributeMapper().getValueLabel(attribute);
        }
        return null;
    }

    private List<String> getValues(String attributeKey) {
        TaskAttribute attribute = this.taskData.getRoot().getMappedAttribute(attributeKey);
        if (attribute != null) {
            return this.taskData.getAttributeMapper().getValueLabels(attribute);
        }
        return null;
    }

    @Override
    public String getVersion() {
        return this.getValue("task.common.version");
    }

    public boolean hasChanges(ITask task) {
        boolean changed = false;
        changed |= this.hasChanges(task.getCompletionDate(), this.getCompletionDate(), "task.common.date.completed");
        changed |= this.hasChanges(task.getCreationDate(), this.getCreationDate(), "task.common.date.created");
        changed |= this.hasChanges(task.getModificationDate(), this.getModificationDate(), "task.common.date.modified");
        changed |= this.hasChanges(task.getDueDate(), this.getDueDate(), "task.common.date.due");
        changed |= this.hasChanges(task.getOwner(), this.getOwner(), "task.common.user.assigned");
        changed |= this.hasChanges(task.getPriority(), this.getPriorityLevelString(), "task.common.priority");
        changed |= this.hasChanges(task.getSummary(), this.getSummary(), "task.common.summary");
        changed |= this.hasChanges(task.getTaskKey(), this.getTaskKey(), "task.common.key");
        changed |= this.hasChanges(task.getTaskKind(), this.getTaskKind(), "task.common.kind");
        return changed |= this.hasChanges(task.getUrl(), this.getTaskUrl(), "task.common.url");
    }

    public void setCc(List<String> cc) {
        this.setValues("task.common.user.cc", cc);
    }

    public void setCompletionDate(Date dateCompleted) {
        this.setDateValue("task.common.date.completed", dateCompleted);
    }

    public void setComponent(String component) {
        this.setValue("task.common.component", component);
    }

    public void setCreationDate(Date dateCreated) {
        this.setDateValue("task.common.date.created", dateCreated);
    }

    private TaskAttribute setDateValue(String attributeKey, Date value) {
        TaskAttribute attribute = this.getWriteableAttribute(attributeKey, "date");
        if (attribute != null) {
            this.taskData.getAttributeMapper().setDateValue(attribute, value);
        }
        return attribute;
    }

    public void setDescription(String description) {
        this.setValue("task.common.description", description);
    }

    public void setDueDate(Date value) {
        this.setDateValue("task.common.date.due", value);
    }

    public void setKeywords(List<String> keywords) {
        this.setValues("task.common.keywords", keywords);
    }

    public void setModificationDate(Date dateModified) {
        this.setDateValue("task.common.date.modified", dateModified);
    }

    public void setOwner(String owner) {
        this.setValue("task.common.user.assigned", owner);
    }

    public void setPriority(String priority) {
        this.setValue("task.common.priority", priority);
    }

    public void setPriorityLevel(ITask.PriorityLevel priority) {
        this.setPriority(priority.toString());
    }

    public void setProduct(String product) {
        this.setValue("task.common.product", product);
    }

    public void setReporter(String reporter) {
        this.setValue("task.common.user.reporter", reporter);
    }

    public void setSeverity(String severity) {
        this.setValue("task.common.severity", severity);
    }

    public void setSummary(String summary) {
        this.setValue("task.common.summary", summary);
    }

    public void setStatus(String status) {
        this.setValue("task.common.status", status);
    }

    public void setTaskKind(String taskKind) {
        this.setValue("task.common.kind", taskKind);
    }

    public void setTaskUrl(String taskUrl) {
        this.setValue("task.common.url", taskUrl);
    }

    public void setVersion(String version) {
        this.setValue("task.common.version", version);
    }

    public TaskAttribute setValue(String attributeKey, String value) {
        TaskAttribute attribute = this.getWriteableAttribute(attributeKey, "shortText");
        if (attribute != null) {
            this.taskData.getAttributeMapper().setValue(attribute, value);
        }
        return attribute;
    }

    private TaskAttribute setValues(String attributeKey, List<String> values) {
        TaskAttribute attribute = this.getWriteableAttribute(attributeKey, "shortText");
        if (attribute != null) {
            this.taskData.getAttributeMapper().setValues(attribute, values);
        }
        return attribute;
    }
}

