/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.events;

import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.mi.service.command.events.MIStoppedEvent;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConst;
import org.eclipse.cdt.dsf.mi.service.command.output.MIFrame;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;

@Immutable
public class MIBreakpointHitEvent
extends MIStoppedEvent {
    int bkptno;

    protected MIBreakpointHitEvent(IRunControl.IExecutionDMContext ctx, int token, MIResult[] results, MIFrame frame, int bkptno) {
        super(ctx, token, results, frame);
        this.bkptno = bkptno;
    }

    public int getNumber() {
        return this.bkptno;
    }

    public static MIBreakpointHitEvent parse(IRunControl.IExecutionDMContext dmc, int token, MIResult[] results) {
        int bkptno = -1;
        int i = 0;
        while (i < results.length) {
            String var = results[i].getVariable();
            MIValue value = results[i].getMIValue();
            String str = "";
            if (value != null && value instanceof MIConst) {
                str = ((MIConst)value).getString();
            }
            if (var.equals("bkptno")) {
                try {
                    bkptno = Integer.parseInt(str.trim());
                }
                catch (NumberFormatException numberFormatException) {}
            }
            ++i;
        }
        MIStoppedEvent stoppedEvent = MIStoppedEvent.parse(dmc, token, results);
        return new MIBreakpointHitEvent((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), token, results, stoppedEvent.getFrame(), bkptno);
    }

    public static /* bridge */ /* synthetic */ MIStoppedEvent parse(IRunControl.IExecutionDMContext iExecutionDMContext, int n, MIResult[] mIResultArray) {
        return MIBreakpointHitEvent.parse(iExecutionDMContext, n, mIResultArray);
    }
}

