/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.launching;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DefaultDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.dsf.concurrent.ThreadSafeAndProhibitedFromDsfExecutor;
import org.eclipse.cdt.dsf.debug.model.DsfMemoryBlockRetrieval;
import org.eclipse.cdt.dsf.debug.service.IDsfDebugServicesFactory;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.launching.ITracedLaunch;
import org.eclipse.cdt.dsf.gdb.launching.ShutdownSequence;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.IMIProcesses;
import org.eclipse.cdt.dsf.mi.service.command.AbstractCLIProcess;
import org.eclipse.cdt.dsf.mi.service.command.MIInferiorProcess;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.ITerminate;

@ThreadSafe
public class GdbLaunch
extends Launch
implements ITerminate,
IDisconnect,
ITracedLaunch {
    private DefaultDsfExecutor fExecutor;
    private DsfSession fSession;
    private DsfServicesTracker fTracker;
    private boolean fInitialized = false;
    private boolean fShutDown = false;
    private DsfMemoryBlockRetrieval fMemRetrieval;
    private IDsfDebugServicesFactory fServiceFactory;

    public GdbLaunch(ILaunchConfiguration launchConfiguration, String mode, ISourceLocator locator) {
        super(launchConfiguration, mode, locator);
        DefaultDsfExecutor dsfExecutor = new DefaultDsfExecutor("org.eclipse.cdt.dsf.gdb");
        dsfExecutor.prestartCoreThread();
        this.fExecutor = dsfExecutor;
        this.fSession = DsfSession.startSession((DsfExecutor)this.fExecutor, (String)"org.eclipse.cdt.dsf.gdb");
    }

    public DsfExecutor getDsfExecutor() {
        return this.fExecutor;
    }

    public IDsfDebugServicesFactory getServiceFactory() {
        return this.fServiceFactory;
    }

    public void initialize() {
        DsfRunnable initRunnable = new DsfRunnable(){

            public void run() {
                GdbLaunch.this.fTracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), GdbLaunch.this.fSession.getId());
                GdbLaunch.this.fSession.addServiceEventListener((Object)GdbLaunch.this, null);
                GdbLaunch.this.fInitialized = true;
                GdbLaunch.this.fireChanged();
            }
        };
        try {
            this.fExecutor.submit((Runnable)initRunnable).get();
        }
        catch (InterruptedException e) {
            new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Error initializing launch", (Throwable)e);
        }
        catch (ExecutionException e) {
            new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Error initializing launch", (Throwable)e);
        }
    }

    public void initializeControl() throws CoreException {
        try {
            this.fExecutor.submit((Callable)new Callable<Object>(){

                @Override
                public Object call() throws CoreException {
                    ICommandControlService commandControl = (ICommandControlService)GdbLaunch.this.fTracker.getService(ICommandControlService.class);
                    IMIProcesses procService = (IMIProcesses)GdbLaunch.this.fTracker.getService(IMIProcesses.class);
                    if (commandControl != null && procService != null) {
                        GdbLaunch.this.fMemRetrieval = new DsfMemoryBlockRetrieval("org.eclipse.cdt.dsf.gdb", GdbLaunch.this.getLaunchConfiguration(), GdbLaunch.this.fSession);
                        GdbLaunch.this.fSession.registerModelAdapter(IMemoryBlockRetrieval.class, (Object)GdbLaunch.this.fMemRetrieval);
                        IProcesses.IProcessDMContext procDmc = procService.createProcessContext(commandControl.getContext(), "");
                        IMemory.IMemoryDMContext memoryDmc = (IMemory.IMemoryDMContext)procService.createContainerContext(procDmc, "");
                        GdbLaunch.this.fMemRetrieval.initialize(memoryDmc);
                    }
                    return null;
                }
            }).get();
        }
        catch (InterruptedException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 0, "Interrupted while waiting for get process callable.", (Throwable)e));
        }
        catch (ExecutionException e) {
            throw (CoreException)e.getCause();
        }
        catch (RejectedExecutionException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 0, "Debugger shut down before launch was completed.", (Throwable)e));
        }
    }

    public DsfSession getSession() {
        return this.fSession;
    }

    @ThreadSafeAndProhibitedFromDsfExecutor(value="getDsfExecutor()")
    public void addInferiorProcess(String label) throws CoreException {
        try {
            MIInferiorProcess inferiorProc = (MIInferiorProcess)this.getDsfExecutor().submit((Callable)new Callable<MIInferiorProcess>(){

                @Override
                public MIInferiorProcess call() throws CoreException {
                    IGDBControl gdb = (IGDBControl)GdbLaunch.this.fTracker.getService(IGDBControl.class);
                    if (gdb != null) {
                        return gdb.getInferiorProcess();
                    }
                    return null;
                }
            }).get();
            DebugPlugin.newProcess((ILaunch)this, (Process)inferiorProc, (String)label);
        }
        catch (InterruptedException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 0, "Interrupted while waiting for get process callable.", (Throwable)e));
        }
        catch (ExecutionException e) {
            throw (CoreException)e.getCause();
        }
        catch (RejectedExecutionException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 0, "Debugger shut down before launch was completed.", (Throwable)e));
        }
    }

    @ThreadSafeAndProhibitedFromDsfExecutor(value="getDsfExecutor()")
    public void addCLIProcess(String label) throws CoreException {
        try {
            AbstractCLIProcess cliProc = (AbstractCLIProcess)this.getDsfExecutor().submit((Callable)new Callable<AbstractCLIProcess>(){

                @Override
                public AbstractCLIProcess call() throws CoreException {
                    IGDBControl gdb = (IGDBControl)GdbLaunch.this.fTracker.getService(IGDBControl.class);
                    if (gdb != null) {
                        return gdb.getCLIProcess();
                    }
                    return null;
                }
            }).get();
            DebugPlugin.newProcess((ILaunch)this, (Process)cliProc, (String)label);
        }
        catch (InterruptedException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 0, "Interrupted while waiting for get process callable.", (Throwable)e));
        }
        catch (ExecutionException e) {
            throw (CoreException)e.getCause();
        }
        catch (RejectedExecutionException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 0, "Debugger shut down before launch was completed.", (Throwable)e));
        }
    }

    public void setServiceFactory(IDsfDebugServicesFactory factory) {
        this.fServiceFactory = factory;
    }

    @DsfServiceEventHandler
    public void eventDispatched(ICommandControlService.ICommandControlShutdownDMEvent event) {
        this.shutdownSession(new RequestMonitor(ImmediateExecutor.getInstance(), null));
    }

    public boolean canTerminate() {
        return this.fInitialized && super.canTerminate();
    }

    public boolean canDisconnect() {
        return this.canTerminate();
    }

    public boolean isDisconnected() {
        return this.isTerminated();
    }

    public void disconnect() throws DebugException {
        this.terminate();
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    public void shutdownSession(final RequestMonitor rm) {
        if (this.fShutDown) {
            rm.done();
            return;
        }
        this.fShutDown = true;
        ShutdownSequence shutdownSeq = new ShutdownSequence(this.getDsfExecutor(), this.fSession.getId(), new RequestMonitor((Executor)this.fSession.getExecutor(), rm){

            public void handleCompleted() {
                GdbLaunch.this.fSession.removeServiceEventListener((Object)GdbLaunch.this);
                if (!this.isSuccess()) {
                    GdbPlugin.getDefault().getLog().log((IStatus)new MultiStatus("org.eclipse.cdt.dsf.gdb", -1, new IStatus[]{this.getStatus()}, "Session shutdown failed", null));
                }
                GdbLaunch.this.fTracker.dispose();
                GdbLaunch.this.fTracker = null;
                DsfSession.endSession((DsfSession)GdbLaunch.this.fSession);
                GdbLaunch.this.fMemRetrieval.saveMemoryBlocks();
                GdbLaunch.this.fExecutor.shutdown();
                GdbLaunch.this.fExecutor = null;
                GdbLaunch.this.fireTerminate();
                rm.setStatus(this.getStatus());
                rm.done();
            }
        });
        this.fExecutor.execute((Runnable)((Object)shutdownSeq));
    }

    public Object getAdapter(Class adapter) {
        Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
        return super.getAdapter(adapter);
    }
}

