/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.breakpointactions;

import java.util.ArrayList;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.breakpointactions.IBreakpointAction;
import org.eclipse.cdt.debug.ui.breakpointactions.ActionDialog;
import org.eclipse.cdt.debug.ui.breakpointactions.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class GlobalActionsList
extends Composite {
    private Button attachButton = null;
    private Button deleteButton = null;
    private Button editButton = null;
    private Button newButton = null;
    private Table table = null;

    public GlobalActionsList(Composite parent, int style, boolean useAttachButton) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 5;
        this.setLayout((Layout)gridLayout);
        this.table = new Table((Composite)this, 67586);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GlobalActionsList.this.updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                GlobalActionsList.this.HandleEditButton();
            }
        });
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 5;
        this.table.setLayoutData((Object)gridData);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn nameTableColumn = new TableColumn(this.table, 0);
        nameTableColumn.setWidth(120);
        nameTableColumn.setText(Messages.getString("GlobalActionsList.0"));
        TableColumn typeTableColumn = new TableColumn(this.table, 0);
        typeTableColumn.setWidth(120);
        typeTableColumn.setText(Messages.getString("GlobalActionsList.1"));
        TableColumn summaryTableColumn = new TableColumn(this.table, 0);
        summaryTableColumn.setWidth(120);
        summaryTableColumn.setText(Messages.getString("GlobalActionsList.2"));
        ArrayList actions = CDebugCorePlugin.getDefault().getBreakpointActionManager().getBreakpointActions();
        boolean hasActions = actions.size() > 0;
        for (IBreakpointAction element : CDebugCorePlugin.getDefault().getBreakpointActionManager().getBreakpointActions()) {
            TableItem tableItem = new TableItem(this.table, 0);
            tableItem.setText(0, element.getName());
            tableItem.setText(1, element.getTypeName());
            tableItem.setText(2, element.getSummary());
            tableItem.setData((Object)element);
        }
        if (useAttachButton) {
            this.attachButton = new Button((Composite)this, 0);
            this.attachButton.setLayoutData((Object)new GridData(512));
            this.attachButton.setText(Messages.getString("GlobalActionsList.3"));
        }
        this.newButton = new Button((Composite)this, 0);
        this.newButton.setLayoutData((Object)new GridData());
        this.newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    GlobalActionsList.this.HandleNewButton();
                }
                catch (CoreException coreException) {}
            }
        });
        this.newButton.setText(Messages.getString("GlobalActionsList.4"));
        this.newButton.setEnabled(CDebugCorePlugin.getDefault().getBreakpointActionManager().getBreakpointActionExtensions().length > 0);
        this.editButton = new Button((Composite)this, 0);
        this.editButton.setText(Messages.getString("GlobalActionsList.5"));
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GlobalActionsList.this.HandleEditButton();
            }
        });
        if (!useAttachButton) {
            this.editButton.setLayoutData((Object)new GridData(640));
        }
        this.editButton.setEnabled(hasActions);
        this.deleteButton = new Button((Composite)this, 0);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GlobalActionsList.this.HandleDeleteButton();
            }
        });
        this.deleteButton.setLayoutData((Object)new GridData(128));
        this.deleteButton.setText(Messages.getString("GlobalActionsList.6"));
        this.deleteButton.setEnabled(hasActions);
    }

    public Button getAttachButton() {
        return this.attachButton;
    }

    public IBreakpointAction[] getSelectedActions() {
        TableItem[] selectedItems = this.table.getSelection();
        IBreakpointAction[] actionList = new IBreakpointAction[selectedItems.length];
        int actionCount = 0;
        int i = 0;
        while (i < selectedItems.length) {
            actionList[actionCount++] = (IBreakpointAction)selectedItems[i].getData();
            ++i;
        }
        return actionList;
    }

    protected void HandleDeleteButton() {
        TableItem[] selectedItems = this.table.getSelection();
        int i = 0;
        while (i < selectedItems.length) {
            IBreakpointAction action = (IBreakpointAction)selectedItems[i].getData();
            CDebugCorePlugin.getDefault().getBreakpointActionManager().deleteAction(action);
            ++i;
        }
        this.table.remove(this.table.getSelectionIndices());
        if (this.table.getItemCount() > 0) {
            this.table.select(this.table.getItemCount() - 1);
        }
        this.updateButtons();
    }

    protected void HandleEditButton() {
        TableItem[] selectedItems = this.table.getSelection();
        IBreakpointAction action = (IBreakpointAction)selectedItems[0].getData();
        ActionDialog dialog = new ActionDialog(this.getShell(), action);
        int result = dialog.open();
        if (result == 0) {
            action.setName(dialog.getActionName());
            selectedItems[0].setText(0, action.getName());
            selectedItems[0].setText(1, action.getTypeName());
            selectedItems[0].setText(2, action.getSummary());
        }
    }

    protected void HandleNewButton() throws CoreException {
        ActionDialog dialog = new ActionDialog(this.getShell(), null);
        int result = dialog.open();
        if (result == 0) {
            IBreakpointAction action = dialog.getBreakpointAction();
            action.setName(dialog.getActionName());
            CDebugCorePlugin.getDefault().getBreakpointActionManager().addAction(action);
            TableItem tableItem = new TableItem(this.table, 0);
            tableItem.setText(0, action.getName());
            tableItem.setText(1, action.getTypeName());
            tableItem.setText(2, action.getSummary());
            tableItem.setData((Object)action);
        }
    }

    public void updateButtons() {
        TableItem[] selectedItems = this.table.getSelection();
        if (this.attachButton != null) {
            this.attachButton.setEnabled(selectedItems.length > 0);
        }
        this.deleteButton.setEnabled(selectedItems.length > 0);
        this.editButton.setEnabled(selectedItems.length > 0);
    }
}

