/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.internal.ui.actions.IMoveToLineTarget;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;

public class MoveToLineActionDelegate
implements IEditorActionDelegate,
IViewActionDelegate,
IActionDelegate2 {
    private IWorkbenchPart fActivePart = null;
    private IMoveToLineTarget fPartTarget = null;
    private IAction fAction = null;
    private ISelectionListener fSelectionListener = new DebugSelectionListener();
    protected ISuspendResume fTargetElement = null;

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.init(action);
        this.bindTo((IWorkbenchPart)targetEditor);
    }

    public void init(IAction action) {
        this.fAction = action;
    }

    public void dispose() {
        this.fActivePart.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener("org.eclipse.debug.ui.DebugView", this.fSelectionListener);
        this.fActivePart = null;
        this.fPartTarget = null;
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void run(IAction action) {
        if (this.fPartTarget != null && this.fTargetElement != null) {
            try {
                this.fPartTarget.moveToLine(this.fActivePart, this.fActivePart.getSite().getSelectionProvider().getSelection(), this.fTargetElement);
            }
            catch (CoreException e) {
                ErrorDialog.openError((Shell)this.fActivePart.getSite().getWorkbenchWindow().getShell(), (String)ActionMessages.getString("MoveToLineActionDelegate.1"), (String)ActionMessages.getString("MoveToLineActionDelegate.2"), (IStatus)e.getStatus());
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fAction = action;
        this.update();
    }

    protected void update() {
        ISelectionProvider selectionProvider;
        IWorkbenchPartSite site;
        if (this.fAction == null) {
            return;
        }
        boolean enabled = false;
        if (this.fPartTarget != null && this.fTargetElement != null && (site = this.fActivePart.getSite()) != null && (selectionProvider = site.getSelectionProvider()) != null) {
            ISelection selection = selectionProvider.getSelection();
            enabled = this.fTargetElement.isSuspended() && this.fPartTarget.canMoveToLine(this.fActivePart, selection, this.fTargetElement);
        }
        this.fAction.setEnabled(enabled);
    }

    public void init(IViewPart view) {
        this.bindTo((IWorkbenchPart)view);
    }

    private void bindTo(IWorkbenchPart part) {
        this.fActivePart = part;
        if (part != null) {
            IAdapterManager adapterManager;
            part.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener("org.eclipse.debug.ui.DebugView", this.fSelectionListener);
            this.fPartTarget = (IMoveToLineTarget)part.getAdapter(IMoveToLineTarget.class);
            if (this.fPartTarget == null && (adapterManager = Platform.getAdapterManager()).hasAdapter((Object)part, IMoveToLineTarget.class.getName())) {
                this.fPartTarget = (IMoveToLineTarget)adapterManager.loadAdapter((Object)part, IMoveToLineTarget.class.getName());
            }
            ISelection selection = part.getSite().getWorkbenchWindow().getSelectionService().getSelection("org.eclipse.debug.ui.DebugView");
            this.fSelectionListener.selectionChanged(part, selection);
        }
        this.update();
    }

    class DebugSelectionListener
    implements ISelectionListener {
        DebugSelectionListener() {
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            Object object;
            IStructuredSelection ss;
            MoveToLineActionDelegate.this.fTargetElement = null;
            if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (object = ss.getFirstElement()) instanceof ISuspendResume) {
                MoveToLineActionDelegate.this.fTargetElement = (ISuspendResume)object;
            }
            MoveToLineActionDelegate.this.update();
        }
    }
}

