/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.discovery.core.model;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.discovery.core.model.AbstractDiscoverySource;
import org.eclipse.mylyn.internal.discovery.core.model.AbstractDiscoveryStrategy;
import org.eclipse.mylyn.internal.discovery.core.model.BundleDiscoverySource;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorDiscoveryExtensionReader;
import org.eclipse.mylyn.internal.discovery.core.model.DiscoveryCategory;
import org.eclipse.mylyn.internal.discovery.core.model.DiscoveryConnector;
import org.eclipse.mylyn.internal.discovery.core.model.Messages;
import org.eclipse.mylyn.internal.discovery.core.model.Policy;
import org.eclipse.mylyn.internal.discovery.core.model.ValidationException;
import org.eclipse.osgi.util.NLS;

public class BundleDiscoveryStrategy
extends AbstractDiscoveryStrategy {
    public void performDiscovery(IProgressMonitor monitor) throws CoreException {
        if (this.connectors == null || this.categories == null) {
            throw new IllegalStateException();
        }
        IExtensionPoint extensionPoint = this.getExtensionRegistry().getExtensionPoint("org.eclipse.mylyn.discovery.core.connectorDiscovery");
        IExtension[] extensions = extensionPoint.getExtensions();
        monitor.beginTask(Messages.BundleDiscoveryStrategy_task_loading_local_extensions, extensions.length == 0 ? 1 : extensions.length);
        try {
            if (extensions.length > 0) {
                this.processExtensions((IProgressMonitor)new SubProgressMonitor(monitor, extensions.length), extensions);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void processExtensions(IProgressMonitor monitor, IExtension[] extensions) {
        monitor.beginTask(Messages.BundleDiscoveryStrategy_task_processing_extensions, extensions.length == 0 ? 1 : extensions.length);
        try {
            ConnectorDiscoveryExtensionReader extensionReader = new ConnectorDiscoveryExtensionReader();
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                AbstractDiscoverySource discoverySource = this.computeDiscoverySource(extension.getContributor());
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    block13: {
                        IConfigurationElement element = iConfigurationElementArray[n4];
                        if (monitor.isCanceled()) {
                            return;
                        }
                        try {
                            if ("connectorDescriptor".equals(element.getName())) {
                                DiscoveryConnector descriptor = extensionReader.readConnectorDescriptor(element, DiscoveryConnector.class);
                                descriptor.setSource(discoverySource);
                                this.connectors.add(descriptor);
                                break block13;
                            }
                            if ("connectorCategory".equals(element.getName())) {
                                DiscoveryCategory category = extensionReader.readConnectorCategory(element, DiscoveryCategory.class);
                                category.setSource(discoverySource);
                                if (!discoverySource.getPolicy().isPermitCategories()) {
                                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.discovery.core", NLS.bind((String)Messages.BundleDiscoveryStrategy_categoryDisallowed, (Object[])new Object[]{category.getName(), category.getId(), element.getContributor().getName()}), null));
                                } else {
                                    this.categories.add(category);
                                }
                                break block13;
                            }
                            throw new ValidationException(NLS.bind((String)Messages.BundleDiscoveryStrategy_unexpected_element, (Object)element.getName()));
                        }
                        catch (ValidationException e) {
                            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.discovery.core", NLS.bind((String)Messages.BundleDiscoveryStrategy_3, (Object)element.getContributor().getName(), (Object)e.getMessage()), (Throwable)((Object)e)));
                        }
                    }
                    ++n4;
                }
                monitor.worked(1);
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    protected AbstractDiscoverySource computeDiscoverySource(IContributor contributor) {
        Policy policy = new Policy(true);
        BundleDiscoverySource bundleDiscoverySource = new BundleDiscoverySource(Platform.getBundle((String)contributor.getName()));
        bundleDiscoverySource.setPolicy(policy);
        return bundleDiscoverySource;
    }

    protected IExtensionRegistry getExtensionRegistry() {
        return Platform.getExtensionRegistry();
    }
}

