/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.ui.viewmodel.properties;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.ui.viewmodel.VMViewerUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IPropertiesUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.jface.viewers.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VMPropertiesUpdate
extends VMViewerUpdate
implements IPropertiesUpdate {
    private final Set<String> fProperties;
    private boolean fCreatedOwnMap = false;
    private Map<String, Object> fValues = Collections.emptyMap();

    public VMPropertiesUpdate(Set<String> properties, IViewerUpdate parentUpdate, DataRequestMonitor<Map<String, Object>> rm) {
        super(parentUpdate, (RequestMonitor)rm);
        this.fProperties = properties;
    }

    public VMPropertiesUpdate(Set<String> properties, TreePath elementPath, Object viewerInput, IPresentationContext presentationContext, DataRequestMonitor<Map<String, Object>> rm) {
        super(elementPath, viewerInput, presentationContext, (RequestMonitor)rm);
        this.fProperties = properties;
    }

    @Override
    public Set<String> getProperties() {
        return this.fProperties;
    }

    @Override
    public synchronized void setProperty(String property, Object value) {
        if (!this.fCreatedOwnMap) {
            this.fCreatedOwnMap = true;
            Map<String, Object> curValues = this.fValues;
            this.fValues = new HashMap<String, Object>(this.fProperties.size() * 4 / 3, 0.75f);
            if (curValues != null) {
                this.fValues.putAll(curValues);
            }
        }
        this.fValues.put(property, value);
    }

    @Override
    public synchronized void setAllProperties(Map<String, Object> properties) {
        if (this.fCreatedOwnMap) {
            this.fValues.putAll(properties);
        } else {
            this.fValues = properties;
        }
    }

    @Override
    public void done() {
        DataRequestMonitor rm = (DataRequestMonitor)this.getRequestMonitor();
        rm.setData(this.fValues);
        super.done();
    }

    public String toString() {
        return "VMPropertiesUpdate:" + this.getElement() + " " + this.fProperties;
    }
}

