/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.viewmodel.expression;

import java.util.LinkedList;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.expression.ExpressionVMProvider;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.expression.ExpressionsChangedEvent;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.expression.InvalidExpressionVMContext;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.expression.MessagesForExpressionVM;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.expression.VMExpressionUpdate;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.expression.WatchExpressionCellModifier;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerCountingRequestMonitor;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.VMDelta;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementEditor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.widgets.Composite;

public class ExpressionManagerVMNode
extends AbstractVMNode
implements IElementLabelProvider,
IElementEditor {
    private IExpressionManager fManager = DebugPlugin.getDefault().getExpressionManager();
    private WatchExpressionCellModifier fWatchExpressionCellModifier = new WatchExpressionCellModifier();

    public ExpressionManagerVMNode(ExpressionVMProvider provider) {
        super(provider);
    }

    public String toString() {
        return "ExpressionManagerVMNode";
    }

    private ExpressionVMProvider getExpressionVMProvider() {
        return (ExpressionVMProvider)this.getVMProvider();
    }

    public void update(IHasChildrenUpdate[] updates) {
        int i = 0;
        while (i < updates.length) {
            updates[i].setHasChilren(this.fManager.getExpressions().length != 0);
            updates[i].done();
            ++i;
        }
    }

    public void update(IChildrenCountUpdate[] updates) {
        IChildrenCountUpdate[] iChildrenCountUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            IChildrenCountUpdate update = iChildrenCountUpdateArray[n2];
            if (this.checkUpdate((IViewerUpdate)update)) {
                update.setChildCount(this.fManager.getExpressions().length + 1);
                update.done();
            }
            ++n2;
        }
    }

    public void update(IChildrenUpdate[] updates) {
        IChildrenUpdate[] iChildrenUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            IChildrenUpdate update = iChildrenUpdateArray[n2];
            this.doUpdateChildren(update);
            ++n2;
        }
    }

    public void doUpdateChildren(final IChildrenUpdate update) {
        int length;
        IExpression[] expressions = this.fManager.getExpressions();
        final ViewerCountingRequestMonitor multiRm = new ViewerCountingRequestMonitor(this.getVMProvider().getExecutor(), (IViewerUpdate)update);
        int multiRmCount = 0;
        int lowOffset = update.getOffset();
        if (lowOffset < 0) {
            lowOffset = 0;
        }
        if ((length = update.getLength()) <= 0) {
            length = expressions.length;
        }
        int highOffset = lowOffset + length;
        int i = lowOffset;
        while (i < highOffset && i < expressions.length + 1) {
            if (i < expressions.length) {
                ++multiRmCount;
                final int childIndex = i;
                final IExpression expression = expressions[i];
                ((ExpressionVMProvider)this.getVMProvider()).update(new VMExpressionUpdate((IViewerUpdate)update, expression, new DataRequestMonitor<Object>(this.getVMProvider().getExecutor(), (RequestMonitor)multiRm){

                    protected void handleSuccess() {
                        update.setChild(this.getData(), childIndex);
                        multiRm.done();
                    }

                    protected void handleError() {
                        update.setChild((Object)new InvalidExpressionVMContext(ExpressionManagerVMNode.this, expression), childIndex);
                        multiRm.done();
                    }
                }));
            } else {
                update.setChild((Object)new NewExpressionVMC(), i);
            }
            ++i;
        }
        multiRm.setDoneCount(multiRmCount);
    }

    public void update(ILabelUpdate[] updates) {
        ILabelUpdate[] iLabelUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            ILabelUpdate update = iLabelUpdateArray[n2];
            if (update.getElement() instanceof NewExpressionVMC) {
                this.updateNewExpressionVMCLabel(update, (NewExpressionVMC)update.getElement());
            } else {
                update.done();
            }
            ++n2;
        }
    }

    private void updateNewExpressionVMCLabel(ILabelUpdate update, NewExpressionVMC vmc) {
        String[] stringArray;
        if (update.getColumnIds() != null) {
            stringArray = update.getColumnIds();
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "org.eclipse.cdt.dsf.ui.COLUMN_ID__NAME";
        }
        String[] columnIds = stringArray;
        int i = 0;
        while (i < columnIds.length) {
            if ("org.eclipse.cdt.dsf.ui.COLUMN_ID__EXPRESSION".equals(columnIds[i])) {
                update.setLabel(MessagesForExpressionVM.ExpressionManagerLayoutNode__newExpression_label, i);
                update.setFontData(JFaceResources.getFontDescriptor((String)"org.eclipse.debug.ui.VariableTextFont").getFontData()[0], i);
            } else {
                update.setLabel("", i);
            }
            ++i;
        }
        update.done();
    }

    public int getDeltaFlags(Object event) {
        int retVal = 0;
        if (event instanceof ExpressionsChangedEvent) {
            retVal |= 0x413;
        }
        IExpression[] iExpressionArray = this.fManager.getExpressions();
        int n = iExpressionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExpression expression = iExpressionArray[n2];
            retVal |= this.getExpressionVMProvider().getDeltaFlagsForExpression(expression, event);
            ++n2;
        }
        return retVal;
    }

    public void buildDelta(Object event, VMDelta parentDelta, int nodeOffset, RequestMonitor requestMonitor) {
        if (event instanceof ExpressionsChangedEvent) {
            this.buildDeltaForExpressionsChangedEvent((ExpressionsChangedEvent)event, parentDelta, nodeOffset, requestMonitor);
        } else {
            CountingRequestMonitor multiRm = new CountingRequestMonitor(this.getExecutor(), requestMonitor);
            int buildDeltaForExpressionCallCount = 0;
            IExpression[] expressions = this.fManager.getExpressions();
            int i = 0;
            while (i < expressions.length) {
                int flags = this.getExpressionVMProvider().getDeltaFlagsForExpression(expressions[i], event);
                if (flags != 0) {
                    int elementOffset = nodeOffset >= 0 ? nodeOffset + i : -1;
                    this.getExpressionVMProvider().buildDeltaForExpression(expressions[i], elementOffset, event, parentDelta, this.getTreePathFromDelta((IModelDelta)parentDelta), new RequestMonitor(this.getExecutor(), (RequestMonitor)multiRm));
                    ++buildDeltaForExpressionCallCount;
                }
                ++i;
            }
            multiRm.setDoneCount(buildDeltaForExpressionCallCount);
        }
    }

    private void buildDeltaForExpressionsChangedEvent(ExpressionsChangedEvent event, VMDelta parentDelta, int nodeOffset, RequestMonitor requestMonitor) {
        CountingRequestMonitor multiRm = new CountingRequestMonitor(this.getExecutor(), requestMonitor);
        int i = 0;
        while (i < event.getExpressions().length) {
            int expIndex = event.getIndex() != -1 ? nodeOffset + event.getIndex() + i : -1;
            this.getExpressionVMProvider().buildDeltaForExpression(event.getExpressions()[i], expIndex, event, parentDelta, this.getTreePathFromDelta((IModelDelta)parentDelta), new RequestMonitor(this.getExecutor(), (RequestMonitor)multiRm));
            ++i;
        }
        multiRm.setDoneCount(event.getExpressions().length);
    }

    private TreePath getTreePathFromDelta(IModelDelta delta) {
        LinkedList<Object> elementList = new LinkedList<Object>();
        IModelDelta listDelta = delta;
        elementList.add(0, listDelta.getElement());
        while (listDelta.getParentDelta() != null) {
            elementList.add(0, listDelta.getElement());
            listDelta = listDelta.getParentDelta();
        }
        return new TreePath(elementList.toArray());
    }

    public CellEditor getCellEditor(IPresentationContext context, String columnId, Object element, Composite parent) {
        if ("org.eclipse.cdt.dsf.ui.COLUMN_ID__EXPRESSION".equals(columnId)) {
            return new TextCellEditor(parent);
        }
        return null;
    }

    public ICellModifier getCellModifier(IPresentationContext context, Object element) {
        return this.fWatchExpressionCellModifier;
    }

    class NewExpressionVMC
    extends AbstractVMContext {
        public NewExpressionVMC() {
            super(ExpressionManagerVMNode.this);
        }

        public Object getAdapter(Class adapter) {
            return super.getAdapter(adapter);
        }

        public boolean equals(Object obj) {
            return obj instanceof NewExpressionVMC;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }
}

