/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui.disassembly;

import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.DisassemblyRulerColumn;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.model.AddressRangePosition;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.model.DisassemblyDocument;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.model.DisassemblyPosition;
import org.eclipse.jface.text.BadLocationException;

public class FunctionOffsetRulerColumn
extends DisassemblyRulerColumn {
    private static final int MAXWIDTH = 40;

    protected String createDisplayString(int line) {
        DisassemblyDocument doc = (DisassemblyDocument)this.getParentRuler().getTextViewer().getDocument();
        try {
            int offset = doc.getLineOffset(line);
            AddressRangePosition pos = doc.getDisassemblyPosition(offset);
            if (pos instanceof DisassemblyPosition && pos.length > 0 && pos.offset == offset && pos.fValid) {
                DisassemblyPosition disassPos = (DisassemblyPosition)pos;
                int length = disassPos.fFunction.length;
                if (length > 40) {
                    return "..." + new String(disassPos.fFunction, length - 40 + 3, 37);
                }
                return new String(disassPos.fFunction);
            }
            if (pos != null && !pos.fValid) {
                return "......................................................................".substring(0, Math.min(40, doc.getMaxFunctionLength()));
            }
        }
        catch (BadLocationException badLocationException) {}
        return "";
    }

    protected int computeNumberOfCharacters() {
        DisassemblyDocument doc = (DisassemblyDocument)this.getParentRuler().getTextViewer().getDocument();
        return Math.min(40, doc.getMaxFunctionLength());
    }
}

