/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.ui;

import java.util.HashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ImageDescriptorRegistry {
    private HashMap<ImageDescriptor, Image> fRegistry;
    private static Display fDisplay;

    public ImageDescriptorRegistry() {
        fDisplay = Display.getDefault();
        this(fDisplay);
    }

    public ImageDescriptorRegistry(Display display) {
        this.fRegistry = new HashMap(10);
        fDisplay = display;
        Assert.isNotNull((Object)fDisplay);
        this.hookDisplay();
    }

    public Image get(ImageDescriptor descriptor) {
        Image result;
        if (descriptor == null) {
            descriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        if ((result = this.fRegistry.get(descriptor)) != null) {
            return result;
        }
        result = descriptor.createImage();
        if (result != null) {
            this.fRegistry.put(descriptor, result);
        }
        return result;
    }

    public void dispose() {
        for (Image image : this.fRegistry.values()) {
            image.dispose();
        }
        this.fRegistry.clear();
    }

    private void hookDisplay() {
        fDisplay.disposeExec(new Runnable(){

            @Override
            public void run() {
                ImageDescriptorRegistry.this.dispose();
            }
        });
    }
}

