/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32;

import com.atmel.avr32.AVR32CorePlugin;
import com.atmel.avr32.util.UtilPlugin;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class CDTAdapter {
    public static void setConfigurations(IManagedProject newManagedProject, IConfiguration[] selectedConfigs) {
        int i = 0;
        while (i < selectedConfigs.length) {
            IConfiguration config = selectedConfigs[i];
            int id = ManagedBuildManager.getRandomNumber();
            IConfiguration newConfig = newManagedProject.createConfiguration(config, String.valueOf(config.getId()) + "." + id);
            newConfig.setArtifactName(newManagedProject.getDefaultArtifactName());
            ++i;
        }
        IConfiguration defaultCfg = null;
        IConfiguration[] newConfigs = newManagedProject.getConfigurations();
        int i2 = 0;
        while (i2 < newConfigs.length) {
            if (newConfigs[i2].isSupported()) {
                defaultCfg = newConfigs[i2];
                break;
            }
            ++i2;
        }
        if (defaultCfg == null && newConfigs.length > 0) {
            defaultCfg = newConfigs[0];
        }
        if (defaultCfg != null) {
            ManagedBuildManager.setDefaultConfiguration((IProject)newManagedProject.getOwner().getProject(), (IConfiguration)defaultCfg);
            ManagedBuildManager.setSelectedConfiguration((IProject)newManagedProject.getOwner().getProject(), (IConfiguration)defaultCfg);
        }
        ManagedBuildManager.setNewProjectVersion((IProject)newManagedProject.getOwner().getProject());
        ICDescriptor desc = null;
        try {
            desc = CCorePlugin.getDefault().getCProjectDescription(newManagedProject.getOwner().getProject(), true);
            desc.create("org.eclipse.cdt.core.ScannerInfoProvider", ManagedBuildManager.INTERFACE_IDENTITY);
        }
        catch (CoreException e) {
            UtilPlugin.error((Object)((Object)e));
        }
    }

    private static void setMCU(IProject project, String value) {
        IConfiguration[] configs;
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        IConfiguration[] iConfigurationArray = configs = info.getManagedProject().getConfigurations();
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration configuration = iConfigurationArray[n2];
            CDTAdapter.setMCU(value, configuration);
            ++n2;
        }
    }

    public static void setMCU(String value, IConfiguration configuration) {
        ITool[] tools;
        ITool[] iToolArray = tools = configuration.getTools();
        int n = tools.length;
        int n2 = 0;
        while (n2 < n) {
            IOption[] options;
            ITool tool = iToolArray[n2];
            IOption[] iOptionArray = options = tool.getOptions();
            int n3 = options.length;
            int n4 = 0;
            while (n4 < n3) {
                IOption option = iOptionArray[n4];
                if (option.getId().startsWith("avr32") && option.getId().indexOf(".option.mcu") > -1) {
                    ManagedBuildManager.setOption((IConfiguration)configuration, (IHoldsOptions)tool, (IOption)option, (String)value);
                    ManagedBuildManager.performValueHandlerEvent((IConfiguration)configuration, (int)4);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public static void setMCUOption(IProject project, String value) throws CoreException {
        if (!project.getDescription().hasNature(AVR32CorePlugin.MNG_MAKENATURE_ID)) {
            return;
        }
        CDTAdapter.setMCU(project, value);
        ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
    }
}

