/* This file is part of the ATMEL AVR32-SoftwareFramework-AT32AP7000-1.0.0 Release */

/*This file is prepared for Doxygen automatic documentation generation.*/
/*! \file *********************************************************************
 *
 * \brief NEWLIB_ADDONS exception vectors file for AVR32.
 *
 * - Compiler:           GNU GCC for AVR32
 * - Supported devices:  All AVR32 devices can be used.
 * - AppNote:
 *
 * \author               Atmel Corporation: http://www.atmel.com \n
 *                       Support and FAQ: http://support.atmel.no/
 *
 ******************************************************************************/

/* Copyright (C) 2006-2008, Atmel Corporation All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name of ATMEL may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY AND
 * SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


#define AVR32_ECR                                      0x00000010
#define AVR32_RAR_EX                                   0x00000048
#define AVR32_RAR_DBG                                  0x00000050

	.section	.exception,"ax"
	.align  9
	.global _evba
	.weak _evba
_evba:
	.org	0x0
	pushm	r8-r9, r10, r11, r12, lr
	rjmp	_handle_exception
	.org	0x4
	pushm	r8-r9, r10, r11, r12, lr
	rjmp	_handle_exception
	.org	0x8
	pushm	r8-r9, r10, r11, r12, lr
	rjmp	_handle_exception
	.org	0xc
	pushm	r8-r9, r10, r11, r12, lr
	rjmp	_handle_exception
	.org	0x10
	pushm	r8-r9, r10, r11, r12, lr
	rjmp	_handle_exception
	.org	0x14
	pushm	r8-r9, r10, r11, r12, lr
	rjmp	_handle_exception
	.org	0x18
	pushm	r8-r9, r10, r11, r12, lr
	rjmp	_handle_exception
	.org	0x1c
	pushm	r8-r9, r10, r11, r12, lr
	rjmp	_handle_breakpoint
	.org	0x20
	pushm	r8-r9, r10, r11, r12, lr
	rjmp	_handle_exception
	.org	0x24
	pushm	r8-r9, r10, r11, r12, lr
	rjmp	_handle_exception
	.org	0x28
	pushm	r8-r9, r10, r11, r12, lr
	rjmp	_handle_exception
	.org	0x2c
	pushm	r8-r9, r10, r11, r12, lr
	rjmp	_handle_exception
	.org	0x30
	pushm	r8-r9, r10, r11, r12, lr
	rjmp	_handle_exception
	.org	0x34
	pushm	r8-r9, r10, r11, r12, lr
	rjmp	_handle_exception
	.org	0x38
	pushm	r8-r9, r10, r11, r12, lr
	rjmp	_handle_exception
	.org	0x3c
	pushm	r8-r9, r10, r11, r12, lr
	rjmp	_handle_exception
	.org	0x40
	pushm	r8-r9, r10, r11, r12, lr
	rjmp	_handle_exception
	.org	0x44
	pushm	r8-r9, r10, r11, r12, lr
	rjmp	_handle_exception
	.org	0x50
	pushm	r8-r9, r10, r11, r12, lr
	rjmp	_handle_exception
	.org	0x60
	pushm	r8-r9, r10, r11, r12, lr
	rjmp	_handle_exception
	.org	0x70
	pushm	r8-r9, r10, r11, r12, lr
	rjmp	_handle_exception
	.org	0x100
	pushm	r4-r7, r8-r9, r10, r11, r12, lr
	rjmp	_handle_scall

	.align	2
	.global _int0
	.global _int1
	.global _int2
	.global _int3

.irp    priority,0,1,2,3
_int\priority:
#ifdef __AVR32_AVR32A__
	pushm	lr
#else
	pushm	r8-r9, r10, r11, r12, lr
#endif
	mov	r12, \priority
	call	_handle_interrupt
#ifdef __AVR32_AVR32A__
	popm	lr
#else
	popm	r8-r9, r10, r11, r12, lr
#endif
	rete
.endr


_handle_breakpoint:
	lda.w	r10, handler_table
#ifdef __AVR32_AVR32A__
	lddsp	r11, sp[4+6*4]
#else
	mfsr	r11, AVR32_RAR_DBG
#endif
	ld.w	r10, r10[0]
	mcall	r10[0x1c]
	cp	r12, 0
	breq	_breakpoint_unhandled
#ifdef __AVR32_AVR32A__
	stdsp	sp[4+6*4], r12
#else
	mtsr	AVR32_RAR_DBG, r12
#endif
	popm	r8-r9, r10, r11, r12, lr
	retd
_breakpoint_unhandled:
	lda.w	r12, exit
#ifdef __AVR32_AVR32A__
	stdsp	sp[4+6*4], r12
#else
	mtsr	AVR32_RAR_DBG, r12
#endif
	popm	r8-r9, r10, r11, r12, lr
	retd

_handle_exception:
	lda.w	r10, handler_table
	mfsr	r12, AVR32_ECR
#ifdef __AVR32_AVR32A__
	lddsp	r11, sp[4+6*4]
#else
	mfsr	r11, AVR32_RAR_EX
#endif
	ld.w	r10, r10[0]
	lsl	r12, 2 /* Shift to get evba offset. */
	add	r10, r10, r12
	mcall	r10[0]
_exception_return:
	cp	r12, 0
	breq	_exception_unhandled
#ifdef __AVR32_AVR32A__
	stdsp	sp[4+6*4], r12
#else
	mtsr	AVR32_RAR_EX, r12
#endif
	popm	r8-r9, r10, r11, r12,lr
	rete

_exception_unhandled:
	lda.w	lr, exit
#ifdef __AVR32_AVR32A__
	stdsp	sp[4+6*4], lr
#else
	mtsr	AVR32_RAR_EX, lr
#endif
	popm	r8-r9, r10, r11, r12, lr
	rete


_handle_scall:
	lda.w	r4, handle_scall
	icall	r4
	popm	r4-r7, r8-r9, r10, r11, r12, lr
	rets
