/* This header file is part of the ATMEL AVR32-SoftwareFramework-AT32AP7000-1.0.0 Release */

/*This file has been prepared for Doxygen automatic documentation generation.*/
/*! \file *********************************************************************
 *
 * \brief Power on and power down sequence for the LTV350QV display on the
 * STK1000.
 *
 * - Compiler:           GNU GCC for AVR32
 * - Supported devices:  All AVR32AP devices with a SIDSA LCD controller
 *
 * \author               Atmel Corporation: http://www.atmel.com \n
 *                       Support and FAQ: http://support.atmel.no/
 *
 * $Name$
 * $Revision: 595 $
 * $RCSfile$
 * $Date: 2007-08-24 09:13:07 +0100 (Fri, 24 Aug 2007) $
 *****************************************************************************/

/* Copyright (C) 2006-2008, Atmel Corporation All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name of ATMEL may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY AND
 * SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _ltv350qv_h_
#define _ltv350qv_h_

#include "spi_at32ap7000.h"
#include "pm_at32ap7000.h"
#include <stdio.h>
#include "pm_at32ap7000.h"


#define sysreg_read(addr)            __builtin_mfsr(addr)
#define sysreg_write(addr, value)    __builtin_mtsr(addr, value)


#define write_reg(spi, reg, val)        \
  do {            \
    ret = ltv350qv_write_reg(spi, reg, val);  \
    if (ret){        \
      goto out;      \
    }\
  } while (0)

/*! \brief Power on sequence for the display
 *
 *  \param spi Pointer to the SPI interface
 *  \param chip_select Chip select number
 */
extern void ltv350qv_power_on(volatile avr32_spi_t * spi, unsigned char chip_select);


/*! \brief Power off sequence for the dispaly
 *
 *  \param spi Pointer to the SPI interface
 *  \param chip_select Chip select number
 */
extern void ltv350qv_power_off(volatile avr32_spi_t * spi, unsigned char chip_select);

#endif
