/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.weirdx;

import com.jcraft.weirdx.Client;
import com.jcraft.weirdx.ClientResource;
import com.jcraft.weirdx.Key;
import java.io.IOException;
import java.util.Enumeration;

class Resource {
    static Object LOCK = class$com$jcraft$weirdx$Client == null ? (class$com$jcraft$weirdx$Client = Resource.class$("com.jcraft.weirdx.Client")) : class$com$jcraft$weirdx$Client;
    static final int RC_VANILLA = 0;
    static final int RC_CACHED = Integer.MIN_VALUE;
    static final int RC_DRAWABLE = 0x40000000;
    static final int SERVER_BIT = 0x20000000;
    static final int SERVER_MINID = 32;
    static final int RESOURCE_ID_MASK = 0x3FFFFF;
    static final int CLIENTOFFSET = 22;
    static final int CLIENTMASK = 532676608;
    static final int RC_NEVERRETAIN = 0x20000000;
    static final int RC_LASTPREDEF = 0x20000000;
    static final int RC_ANY = -1;
    static final int RT_WINDOW = -1073741823;
    static final int RT_PIXMAP = -1073741822;
    static final int RT_GC = -2147483645;
    static final int RT_FONT = 4;
    static final int RT_CURSOR = 5;
    static final int RT_COLORMAP = 6;
    static final int RT_CMAPENTRY = 7;
    static final int RT_OTHERCLIENT = 0x20000008;
    static final int RT_PASSIVEGRAB = 0x20000009;
    static final int RT_LASTPREDEF = 9;
    static final int RT_NONE = 0;
    static ClientResource[] clients = new ClientResource[128];
    static int lastResourceType = 9;
    static int lastResourceClass = 0x20000000;
    int id;
    int rtype;
    static /* synthetic */ Class class$com$jcraft$weirdx$Client;

    static synchronized int newType() {
        int n = lastResourceType + 1;
        if ((n & lastResourceClass) != 0) {
            return 0;
        }
        lastResourceType = n;
        return n;
    }

    static synchronized int newClss() {
        int n = lastResourceClass >> 1;
        if ((n & lastResourceType) != 0) {
            return 0;
        }
        lastResourceClass = n;
        return n;
    }

    Resource() {
    }

    Resource(int n, int n2) {
        this.id = n;
        this.rtype = n2;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object object) {
        if (object == null || this.id != object.hashCode()) {
            return false;
        }
        if (!(object instanceof Resource)) {
            return true;
        }
        if (!(object instanceof Key)) {
            return this.rtype == ((Resource)object).rtype;
        }
        Key key = (Key)object;
        if (key.clss == 0) {
            return this.rtype == key.rtype;
        }
        if (key.clss == -1) {
            return true;
        }
        return (this.rtype & key.clss) != 0;
    }

    static void add(Resource resource) {
        int n = (resource.id & 0x1FC00000) >> 22;
        ClientResource clientResource = clients[n];
        clientResource.put(resource, resource);
    }

    static void RemoveResource(Resource resource) {
        int n = (resource.id & 0x1FC00000) >> 22;
        ClientResource clientResource = clients[n];
        Resource.RemoveResource(clientResource, resource);
    }

    static void RemoveResource(ClientResource clientResource, Resource resource) {
        Object object = LOCK;
        synchronized (object) {
            if ((resource.rtype & Integer.MIN_VALUE) != 0) {
                Client.flushCache(resource.id);
            }
        }
        clientResource.remove(resource);
    }

    static void freeResource(int n, int n2) {
        Resource resource;
        while ((resource = Resource.lookupIDByClass(n, -1)) != null) {
            Resource.RemoveResource(resource);
            try {
                if (resource.rtype == n2) continue;
                Resource.deleteit(resource);
            }
            catch (Exception exception) {}
        }
    }

    static void freeResourceByType(int n, int n2, int n3) {
        Resource resource = Resource.lookupIDByType(n, n2);
        if (resource != null) {
            Resource.RemoveResource(resource);
            try {
                if (resource.rtype != n3) {
                    Resource.deleteit(resource);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static Resource lookupIDByClass(int n, int n2) {
        int n3 = (n & 0x1FC00000) >> 22;
        if (clients.length <= n3) {
            return null;
        }
        ClientResource clientResource = clients[n3];
        if (clientResource == null) {
            return null;
        }
        ClientResource clientResource2 = clientResource;
        synchronized (clientResource2) {
            try {
                Resource resource;
                clientResource.key.id = n;
                clientResource.key.clss = n2;
                Resource resource2 = resource = (Resource)clientResource.get(clientResource.key);
                return resource2;
            }
            catch (Exception exception) {
                Resource resource = null;
                return resource;
            }
        }
    }

    static Resource lookupIDByType(int n, int n2) {
        int n3 = (n & 0x1FC00000) >> 22;
        if (clients.length <= n3) {
            return null;
        }
        ClientResource clientResource = clients[n3];
        if (clientResource == null) {
            return null;
        }
        ClientResource clientResource2 = clientResource;
        synchronized (clientResource2) {
            Resource resource;
            clientResource.key.id = n;
            clientResource.key.clss = 0;
            clientResource.key.rtype = n2;
            Resource resource2 = resource = (Resource)clientResource.get(clientResource.key);
            return resource2;
        }
    }

    static void freeClientNeverResources(Client client) {
        if (client == null) {
            return;
        }
        ClientResource clientResource = clients[client.index];
        Object object = LOCK;
        synchronized (object) {
            Enumeration enumeration = clientResource.elements();
            while (enumeration.hasMoreElements()) {
                Resource resource = (Resource)enumeration.nextElement();
                if ((resource.rtype & 0x20000000) == 0) continue;
                Resource.deleteit(resource);
                Resource.RemoveResource(clientResource, resource);
            }
        }
    }

    static void freeClientResources(Client client) {
        if (client == null) {
            return;
        }
        ClientResource clientResource = clients[client.index];
        Object object = LOCK;
        synchronized (object) {
            Enumeration enumeration = clientResource.elements();
            while (enumeration.hasMoreElements()) {
                Resource resource = (Resource)enumeration.nextElement();
                Resource.deleteit(resource);
                Resource.RemoveResource(clientResource, resource);
            }
        }
    }

    static void deleteit(Resource resource) {
        try {
            resource.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void delete() throws IOException {
    }

    static Client lookupClient(int n) {
        Resource resource = Resource.lookupIDByClass(n, -1);
        int n2 = (n & 0x1FC00000) >> 22;
        if (n2 != 0 && resource != null && clients[n2] != null && (n & 0x20000000) == 0) {
            return Client.clients[n2];
        }
        return null;
    }

    static void initClientResource(Client client) {
        ClientResource clientResource = Resource.clients[client.index] = new ClientResource();
        clientResource.fakeID = client.clientAsMask | (client.index != 0 ? 0x20000000 : 32);
        clientResource.endFakeID = (clientResource.fakeID | 0x3FFFFF) + 1;
        clientResource.expectID = client.clientAsMask;
    }

    static int fakeClientId(Client client) {
        int n;
        if ((n = Resource.clients[client.index].fakeID++) != Resource.clients[client.index].endFakeID) {
            return n;
        }
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

