/*************************************************************************
 *
 *  $RCSfile: syswin.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2001/08/27 12:34:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_SYSWIN_HXX
#define _SV_SYSWIN_HXX

#ifndef _SV_SV_H
#include <vcl/sv.h>
#endif
#ifndef _SV_WINDOW_HXX
#include <vcl/window.hxx>
#endif

class ModalDialog;
class MenuBar;

// --------------
// - Icon-Types -
// --------------

#define ICON_DEFAULT                    0
#define ICON_SO_DEFAULT                 1
#define ICON_TEXT_DOCUMENT              2
#define ICON_TEXT_TEMPLATE              3
#define ICON_SPREADSHEET_DOCUMENT       4
#define ICON_SPREADSHEET_TEMPLATE       5
#define ICON_DRAWING_DOCUMENT           6
#define ICON_DRAWING_TEMPLATE           7
#define ICON_PRESENTATION_DOCUMENT      8
#define ICON_PRESENTATION_TEMPLATE      9
#define ICON_PRESENTATION_COMPRESSED    10
#define ICON_GLOBAL_DOCUMENT            11
#define ICON_HTML_DOCUMENT              12
#define ICON_CHART_DOCUMENT             13
#define ICON_DATABASE_DOCUMENT          14
#define ICON_MATH_DOCUMENT              15
#define ICON_TEMPLATE                   16
#define ICON_MACROLIBRARY               17
#define	ICON_PLAYER						100
#define ICON_SETUP                      500

// -------------------
// - WindowStateData -
// -------------------

#define WINDOWSTATE_MASK_X              ((ULONG)0x00000001)
#define WINDOWSTATE_MASK_Y              ((ULONG)0x00000002)
#define WINDOWSTATE_MASK_WIDTH          ((ULONG)0x00000004)
#define WINDOWSTATE_MASK_HEIGHT         ((ULONG)0x00000008)
#define WINDOWSTATE_MASK_STATE          ((ULONG)0x00000010)
#define WINDOWSTATE_MASK_POS            (WINDOWSTATE_MASK_X | WINDOWSTATE_MASK_Y)
#define WINDOWSTATE_MASK_ALL            (WINDOWSTATE_MASK_X | WINDOWSTATE_MASK_Y | WINDOWSTATE_MASK_WIDTH | WINDOWSTATE_MASK_HEIGHT | WINDOWSTATE_MASK_STATE)

#define WINDOWSTATE_STATE_NORMAL        ((ULONG)0x00000001)
#define WINDOWSTATE_STATE_MINIMIZED     ((ULONG)0x00000002)
#define WINDOWSTATE_STATE_MAXIMIZED     ((ULONG)0x00000004)
#define WINDOWSTATE_STATE_ROLLUP        ((ULONG)0x00000008)

class WindowStateData
{
private:
    ULONG       mnValidMask;
    long        mnX;
    long        mnY;
    long        mnWidth;
    long        mnHeight;
    ULONG       mnState;

public:
                WindowStateData()
                {
                    mnValidMask = mnX = mnY = mnWidth = mnHeight = mnState = 0;
                }
                WindowStateData( ULONG nValidMask, long nX, long nY, long nWidth, long nHeight, ULONG nState )
                {
                    mnValidMask = nValidMask;
                    mnX         = nX;
                    mnY         = nY;
                    mnWidth     = nWidth;
                    mnHeight    = nHeight;
                    mnState     = nState;
                }
                WindowStateData( const Point& rPos )
                {
                    mnValidMask = WINDOWSTATE_MASK_X | WINDOWSTATE_MASK_Y;
                    mnX         = rPos.X();
                    mnY         = rPos.Y();
                    mnWidth = mnHeight = mnState = 0;
                }
                WindowStateData( const Size& rSize )
                {
                    mnValidMask = WINDOWSTATE_MASK_WIDTH | WINDOWSTATE_MASK_HEIGHT;
                    mnWidth     = rSize.Width();
                    mnHeight    = rSize.Height();
                    mnX = mnY = mnState = 0;
                }
                WindowStateData( const Point& rPos, const Size& rSize )
                {
                    mnValidMask = WINDOWSTATE_MASK_X | WINDOWSTATE_MASK_Y | WINDOWSTATE_MASK_WIDTH | WINDOWSTATE_MASK_HEIGHT;
                    mnX         = rPos.X();
                    mnY         = rPos.Y();
                    mnWidth     = rSize.Width();
                    mnHeight    = rSize.Height();
                    mnState     = 0;
                }
                WindowStateData( const Point& rPos, const Size& rSize, ULONG nState )
                {
                    mnValidMask = WINDOWSTATE_MASK_X | WINDOWSTATE_MASK_Y | WINDOWSTATE_MASK_WIDTH | WINDOWSTATE_MASK_HEIGHT | WINDOWSTATE_MASK_STATE;
                    mnX         = rPos.X();
                    mnY         = rPos.Y();
                    mnWidth     = rSize.Width();
                    mnHeight    = rSize.Height();
                    mnState     = nState;
                }

    void        SetMask( ULONG nValidMask ) { mnValidMask = nValidMask; }
    ULONG       GetMask() const { return mnValidMask; }

    void        SetX( long nX ) { mnX = nX; }
    long        GetX() const { return mnX; }
    void        SetY( long nY ) { mnY = nY; }
    long        GetY() const { return mnY; }
    void        SetWidth( long nWidth ) { mnWidth = nWidth; }
    long        GetWidth() const { return mnWidth; }
    void        SetHeight( long nHeight ) { mnHeight = nHeight; }
    long        GetHeight() const { return mnHeight; }
    void        SetState( ULONG nState ) { mnState = nState; }
    ULONG       GetState() const { return mnState; }
};

// ----------------------
// - SystemWindow-Types -
// ----------------------

#define MENUBAR_MODE_NORMAL         ((USHORT)0)
#define MENUBAR_MODE_HIDE           ((USHORT)1)

#define TITLE_BUTTON_DOCKING        ((USHORT)1)
#define TITLE_BUTTON_HIDE           ((USHORT)2)

// ----------------
// - SystemWindow -
// ----------------

class SystemWindow : public Window
{
    friend class WorkWindow;

private:
    MenuBar*        mpMenuBar;
    Size            maOrgSize;
    Size            maRollUpOutSize;
    Size            maMinOutSize;
    BOOL            mbPined;
    BOOL            mbRollUp;
    BOOL            mbRollFunc;
    BOOL            mbDockBtn;
    BOOL            mbHideBtn;
    BOOL            mbSysChild;
    BOOL            mbDummy2;
    BOOL            mbDummy3;
    USHORT          mnMenuBarMode;
    USHORT          mnIcon;

protected:
                    SystemWindow( WindowType nType );

    void            SetWindowStateData( const WindowStateData& rData );
    void            GetWindowStateData( WindowStateData& rData ) const;

public:
    virtual long    Notify( NotifyEvent& rNEvt );

    virtual BOOL    Close();
    virtual void    TitleButtonClick( USHORT nButton );
    virtual void    Pin();
    virtual void    Roll();
    virtual void    Resizing( Size& rSize );

    void            SetIcon( USHORT nIcon );
    USHORT          GetIcon() const { return mnIcon; }

    void            SetZLevel( BYTE nLevel );
    BYTE            GetZLevel() const;

    void            EnableSaveBackground( BOOL bSave = TRUE );
    BOOL            IsSaveBackgroundEnabled() const;

    void            ShowTitleButton( USHORT nButton, BOOL bVisible = TRUE );
    BOOL            IsTitleButtonVisible( USHORT nButton ) const;

    void            SetPin( BOOL bPin );
    BOOL            IsPined() const { return mbPined; }

    void            RollUp();
    void            RollDown();
    BOOL            IsRollUp() const { return mbRollUp; }

    void            SetRollUpOutputSizePixel( const Size& rSize ) { maRollUpOutSize = rSize; }
    Size            GetRollUpOutputSizePixel() const { return maRollUpOutSize; }

    void            SetMinOutputSizePixel( const Size& rSize );
    const Size&     GetMinOutputSizePixel() const { return maMinOutSize; }
    Size            GetResizeOutputSizePixel() const;

    void            SetWindowState( const ByteString& rStr );
    ByteString      GetWindowState( ULONG nMask = WINDOWSTATE_MASK_ALL ) const;

    void            SetMenuBar( MenuBar* pMenuBar );
    MenuBar*        GetMenuBar() const { return mpMenuBar; }
    void            SetMenuBarMode( USHORT nMode );
    USHORT          GetMenuBarMode() const { return mnMenuBarMode; }
};

#endif // _SV_SYSWIN_HXX
