/*************************************************************************
 *
 *  $RCSfile: scheme_setup.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/03/08 14:32:37 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef UDM_SCHEME_SETUP_HXX
#define UDM_SCHEME_SETUP_HXX


// USED SERVICES
	// BASE CLASSES
	// COMPONENTS
	// PARAMETERS


namespace udm
{


class Scheme::CheshireCat
{
  public:
    void                set_upper_bound(
                            uintt               i_nUpperBound )
                            { aMemberList.reserve(i_nUpperBound); }
    void                add_member_type(

                            uintt               i_nIndex,
                            Data::accessor_type i_eType,
                            accessor_impl_id    i_nAccessorImpl,
                            const Struct::member_name &
                                                i_sName )
                            { aMemberList.push_back(
                                member_type(i_nIndex,i_eType,i_nAccessorImpl) );
                              aMemberIndex[i_sName] =   }
  private:
    struct member_type
    {
        uintt               nIndex;
        Data::accessor_type eType;
        accessor_impl_id    nAccessorImpl;

                            MemberType(
                                uintt               nIndex,
                                Data::accessor_type eType,
                                accessor_impl_id    nAccessorImpl )
                                :   nIndex(i_nIndex),
                                    eType(i_eType),
                                    nAccessorImpl(i_nAccessorImpl) { }
    };

    // DATA
    std::vector< MemberType* >
                        aMemberList;
    std::map< csv::Struct::member_name, Struct::member_id >
                        aMemberIndex
};

class Scheme
{
  public:
    typedef std::vector< Data* >    member_list;
    typedef uintt                   accessor_impl_id;
    typedef uintt                   id;

    // LIFECYCLE
	virtual				~Scheme() {}

    // OPERATIONS
    void                connect(
                            member_list &       o_rMembers,
                            void *              io_pData ) const;
    // INQUIRY
    intt                index_of(
                            Struct::member_id   i_n ) const;
  protected:
                        Scheme(
                            TypeSystem &        i_rTypeSystem,
                            Scheme::id          i_nScheme );
  private:
    virtual void        do_Connect(
                            member_list &       o_rMembers,
                            void *              io_pData ) const = 0;

    struct CheshireCat;

    S_MemberList        aMemberTypes;
    TypeSystem *        pTypeSystem;
};


template <class TYPE>
class TypeScheme : public Scheme
{
  public:
    typedef void (*F_CONNECT)(member_list&, TYPE&);

    // LIFECYCLE
                        TypeScheme(
                            TypeSystem &        i_rTypeSystem,
                            Scheme::id          i_nScheme,
                            F_CONNECT           i_fConnect );
	virtual				~TypeScheme();

    // OPERATIONS

  private:
    virtual void        do_Connect(
                            member_list &       o_rMembers,
                            void *              io_pData ) const;
    // DATA
    F_CONNECT           fConnect;
};



// IMPLEMENTATION

inline void
Scheme::set_memids_upper_bound( Struct::member_id i_nUpperBound )
    { aMemberTypes.reserve(i_nUpperBound);

inline void
Scheme::add_member_type( uintt               i_nIndex,
                         Data::accessor_type i_eType,
                         accessor_impl_id    i_nAccessorImpl )
    {
inline void
Scheme::connect( member_list &       o_rMembers,
                 void *              io_pData ) const
    { do_connect(o_rMembers, io_pData; }
inline intt
Scheme::index_of( Struct::member_id i_n ) const
    { csv::assert(i_n < aMemberTypes.size());
      return aMemberTypes[i_n]; }



template <class TYPE>
TypeScheme<TYPE>::TypeScheme( F_BUILD             i_fBuild,
                              F_CONNECT           i_fConnect )
    :   fConnect(i_fConnect)
{
    (*i_fBuild)(*this);
}

template <class TYPE>
TypeScheme<TYPE>::~TypeScheme()
{
}

template <class TYPE>
void
TypeScheme<TYPE>::do_Connect( member_list &       o_rMembers,
                              void *              io_pData ) const
{
    csv_assert( dynamic_cast< TYPE* >(io_pData) != 0 );

    (*fConnect)( o_rMembers, *static_cast< TYPE* >(io_pData) );
}

}   // namespace udm



#endif

