/*************************************************************************
 *
 *  $RCSfile: graphctl.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2000/12/07 15:01:21 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _GRAPHCTL_HXX
#define _GRAPHCTL_HXX

// include ---------------------------------------------------------------

#ifndef _SV_CTRL_HXX //autogen
#include <vcl/ctrl.hxx>
#endif
#ifndef _SV_GRAPH_HXX //autogen
#include <vcl/graph.hxx>
#endif

#include <svx/svdview.hxx>
#include <svx/svdobj.hxx>

/*************************************************************************
|*
|*
|*
\************************************************************************/

#define WB_SDRMODE		((WinBits)0x0080)
#define WB_ANIMATION	((WinBits)0x0100)

class GraphCtrl : public Control
{
	friend class GraphCtrlView;
	friend class GraphCtrlUserCall;

	Graphic				aGraphic;
	Timer				aUpdateTimer;
	Link				aMousePosLink;
	Link				aGraphSizeLink;
	Link				aMarkObjLink;
	Link				aUpdateLink;
	MapMode				aMap100;
	Size				aGraphSize;
	Point				aMousePos;
	GraphCtrlUserCall*	pUserCall;
	WinBits				nWinStyle;
	SdrObjKind			eObjKind;
	USHORT				nPolyEdit;
	BOOL				bEditMode;
	BOOL				bSdrMode;
	BOOL				bAnim;

						DECL_LINK( UpdateHdl, Timer* );

protected:

	SdrModel*			pModel;
	SdrView*			pView;

	virtual void		Paint( const Rectangle& rRect );
	virtual void		Resize();
	virtual void		KeyInput(const KeyEvent& rKEvt);
	virtual void		MouseButtonDown(const MouseEvent& rMEvt);
	virtual void		MouseButtonUp(const MouseEvent& rMEvt);
	virtual void		MouseMove(const MouseEvent& rMEvt);

	virtual void		InitSdrModel();

	virtual void		SdrObjCreated( const SdrObject& rObj );
	virtual void		SdrObjChanged( const SdrObject& rObj );
	virtual	void		MarkListHasChanged();

	SdrObjUserCall*		GetSdrUserCall() { return (SdrObjUserCall*) pUserCall; }

public:

						GraphCtrl( Window* pParent, const WinBits nWinBits = 0 );
						GraphCtrl( Window* pParent, const ResId& rResId );
						~GraphCtrl();

	void				SetWinStyle( WinBits nWinBits );
	WinBits				GetWinStyle() const { return nWinStyle; }

	void				SetGraphic( const Graphic& rGraphic, BOOL bNewModel = TRUE );
	const Graphic&		GetGraphic() const { return aGraphic; }
	const Size&			GetGraphicSize() const { return aGraphSize; }

	const Point&		GetMousePos() const { return aMousePos; }

	void				SetEditMode( const BOOL bEditMode );
	BOOL				IsEditMode() const { return bEditMode; }

	void				SetPolyEditMode( const USHORT nPolyEdit );
	USHORT				GetPolyEditMode() const { return nPolyEdit; }

	void				SetObjKind( const SdrObjKind eObjKind );
	SdrObjKind			GetObjKind() const { return eObjKind; }

	SdrModel*			GetSdrModel() const { return pModel; }
	SdrView*			GetSdrView() const { return pView; }
	SdrObject*			GetSelectedSdrObject() const;
	BOOL				IsChanged() const { return bSdrMode ? pModel->IsChanged() : FALSE; }

	void				SetMousePosLink( const Link& rLink ) { aMousePosLink = rLink; }
	const Link&			GetMousePosLink() const { return aMousePosLink; }

	void				SetGraphSizeLink( const Link& rLink ) { aGraphSizeLink = rLink; }
	const Link&			GetGraphSizeLink() const { return aGraphSizeLink; }

	void				SetMarkObjLink( const Link& rLink ) { aMarkObjLink = rLink; }
	const Link&			GetMarkObjLink() const { return aMarkObjLink; }

	void				SetUpdateLink( const Link& rLink ) { aUpdateLink = rLink; }
	const Link&			GetUpdateLink() const { return aUpdateLink; }

	static String		GetStringFromDouble( const double& rDouble );
};

#if 0 // _SOLAR__PRIVATE

/*************************************************************************
|*
|*
|*
\************************************************************************/

class GraphCtrlUserCall : public SdrObjUserCall
{
	GraphCtrl&		rWin;

public:

					GraphCtrlUserCall( GraphCtrl& rGraphWin ) : rWin( rGraphWin ) {};
	virtual			~GraphCtrlUserCall() {};

	virtual void	Changed( const SdrObject& rObj, SdrUserCallType eType, const Rectangle& rOldBoundRect );
};

/*************************************************************************
|*
|*
|*
\************************************************************************/

class GraphCtrlView : public SdrView
{
	GraphCtrl&		rGraphCtrl;

protected:

	virtual void	MarkListHasChanged()
					{
						SdrView::MarkListHasChanged();
						rGraphCtrl.MarkListHasChanged();
					}

public:

					GraphCtrlView( SdrModel* pModel, GraphCtrl* pWindow) :
							SdrView		( pModel, pWindow ),
							rGraphCtrl	( *pWindow ) {};

	virtual			~GraphCtrlView() {};
};

#endif // __PRIVATE

#endif // _GRAPHCTL_HXX

