/*************************************************************************
 *
 *  $RCSfile: svtoxstr.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:58:53 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
// 

#ifndef _SMART_COM_SUN_STAR_IO_XCONNECTABLE_HXX_
#include <smart/com/sun/star/io/XConnectable.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XOUTPUTSTREAM_HXX_
#include <smart/com/sun/star/io/XOutputStream.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XDATAOUTPUTSTREAM_HXX_
#include <smart/com/sun/star/io/XDataOutputStream.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XACTIVEDATACONTROL_HXX_
#include <smart/com/sun/star/io/XActiveDataControl.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XDATAINPUTSTREAM_HXX_
#include <smart/com/sun/star/io/XDataInputStream.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XMARKABLESTREAM_HXX_
#include <smart/com/sun/star/io/XMarkableStream.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XINPUTSTREAM_HXX_
#include <smart/com/sun/star/io/XInputStream.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XSTREAMLISTENER_HXX_
#include <smart/com/sun/star/io/XStreamListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XACTIVEDATASINK_HXX_
#include <smart/com/sun/star/io/XActiveDataSink.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XACTIVEDATASOURCE_HXX_
#include <smart/com/sun/star/io/XActiveDataSource.hxx>
#endif

#ifndef _STREAM_HXX //autogen wg. SvStream
#include <tools/stream.hxx>
#endif

class SvToXInputStream : public XInputStream, public UsrObject
{
	SvStream &_aStream;
public:
	SvToXInputStream(SvStream &aStream)
			:_aStream(aStream){}

	virtual INT32 readBytes(Sequence< BYTE >& aData, INT32 nBytesToRead)
		THROWS( (NotConnectedException, BufferSizeExceededException, UsrSystemException) );
    virtual INT32 readSomeBytes(Sequence< BYTE >& aData, INT32 nMaxBytesToRead)
		THROWS( (NotConnectedException, BufferSizeExceededException, UsrSystemException) );
    virtual void  skipBytes(INT32 nBytesToSkip)
		THROWS( (NotConnectedException, BufferSizeExceededException, UsrSystemException) );
    virtual INT32 available(void)
		THROWS( (NotConnectedException, UsrSystemException) );
    virtual void  closeInput(void)
		THROWS( (NotConnectedException, UsrSystemException) ); 

	// XInterface
	SMART_UNO_DECLARATION( SvToXInputStream, UsrObject );
	virtual BOOL queryInterface( UsrUik aUIK, XInterfaceRef& );
	static  const XIdlClassRef&  staticGetIdlClass();
	virtual Sequence< XIdlClassRef > getIdlClasses( void ) {
		return Sequence< XIdlClassRef>( &staticGetIdlClass(), 1 ); }
};

// -----------------------------------------------------------------------------
class SvToXOutputStream : public XOutputStream, public UsrObject
{
	SvStream &_aStream;
public:
	SvToXOutputStream(SvStream &aStream)
			:_aStream(aStream){}

    virtual void writeBytes(const Sequence< BYTE >& aData) THROWS( (NotConnectedException, BufferSizeExceededException, UsrSystemException) );
    virtual void flush(void) THROWS( (NotConnectedException, BufferSizeExceededException, UsrSystemException) );
    virtual void closeOutput(void) THROWS( (NotConnectedException, BufferSizeExceededException, UsrSystemException) );

	// XInterface
	SMART_UNO_DECLARATION( SvToXOutputStream, UsrObject );
	virtual BOOL queryInterface( UsrUik aUIK, XInterfaceRef& );
	static  const XIdlClassRef&  staticGetIdlClass();
	virtual Sequence< XIdlClassRef > getIdlClasses( void ) {
		return Sequence< XIdlClassRef>( &staticGetIdlClass(), 1 ); }
};
