/*************************************************************************
 *
 *  $RCSfile: imap.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: ka $ $Date: 2001/06/28 09:13:21 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _IMAP_HXX
#define _IMAP_HXX

#ifndef _STRING_HXX //autogen
#include <tools/string.hxx>
#endif
#ifndef _STREAM_HXX //autogen
#include <tools/stream.hxx>
#endif

class Point;
class Rectangle;
class Size;
class Fraction;
class IMapObject;

/******************************************************************************
|*
|*
|*
\******************************************************************************/

class ImageMap
{
	List				maList;
	String				aName;

protected:

	// Binaer laden/speichern
	void				ImpWriteImageMap( SvStream& rOStm ) const ;
	void				ImpReadImageMap( SvStream& rIStm, USHORT nCount );

	// Im-/Export
	void				ImpWriteCERN( SvStream& rOStm ) const;
	void				ImpWriteNCSA( SvStream& rOStm ) const;
	ULONG				ImpReadCERN( SvStream& rOStm );
	ULONG				ImpReadNCSA( SvStream& rOStm );

	void				ImpReadCERNLine( const ByteString& rLine );
	Point				ImpReadCERNCoords( const char** ppStr );
	long				ImpReadCERNRadius( const char** ppStr );
	String				ImpReadCERNURL( const char** ppStr );

	void				ImpReadNCSALine( const ByteString& rLine );
	String				ImpReadNCSAURL( const char** ppStr );
	Point				ImpReadNCSACoords( const char** ppStr );

	ULONG				ImpDetectFormat( SvStream& rIStm );

public:

	TYPEINFO();

						ImageMap() {};
						ImageMap( const String& rName );
						ImageMap( const ImageMap& rImageMap );

						// Der Dtor gibt den intern belegten
						// Speicher wieder frei;
						//  alle IMapObjekte werden im Dtor zerstoert;
						~ImageMap();

	// Zuweisungsoperator
	ImageMap&			operator=( const ImageMap& rImageMap );

	// Vergleichsoperator (es wird alles auf Gleichheit geprueft)
	BOOL				operator==( const ImageMap& rImageMap );
	BOOL				operator!=( const ImageMap& rImageMap );

	// In die Map wird ein neues IMap-Obkekt ans Ende eingefuegt
	void				InsertIMapObject( const IMapObject& rIMapObject );

	// Zugriff auf einzelne IMapObjekte; die Objekte
	// duerfen von aussen _nicht_ zerstoert werden
	IMapObject*			GetFirstIMapObject() { return (IMapObject*) maList.First(); }
	IMapObject*			GetNextIMapObject() { return (IMapObject*) maList.Next(); }
	IMapObject*			GetLastIMapObject() { return (IMapObject*) maList.Last(); }
	IMapObject*			GetPrevIMapObject() { return (IMapObject*) maList.Prev(); }
	IMapObject*			GetIMapObject( USHORT nPos ) const { return (IMapObject*) maList.GetObject( nPos ); }

	// Gibt das Objekt zurueck, das zuerst getroffen wurde oder NULL;
	// Groessen- und Positionsangaben sind in 1/100mm;
	// rTotalSize ist die Originalgroesse des Bildes;
	// rDisplaySize die aktuelle Darstellungsgroesse;
	// rRelPoint bezieht sich auf die Darstellungsgroesse
	// und die linke oebere Ecke des Bildes
	IMapObject*			GetHitIMapObject( const Size& rOriginalSize,
										  const Size& rDisplaySize,
										  const Point& rRelHitPoint,
										  ULONG nFlags = 0 );

	// Gibt die Gesamtanzahl der IMap-Objekte zurueck
	UINT16				GetIMapObjectCount() const { return (UINT16) maList.Count(); }

	// Loescht alle internen Objekte
	void				ClearImageMap();

	// liefert die aktuelle Versionsnummer
	UINT16				GetVersion() const;

	// liefert / setzt den Namen der ImageMap
	const String&		GetName() const { return aName; }
	void				SetName( const String& rName ) { aName = rName; }

	// gibt das BoundRect aller IMap-Objekte in 1/100mm zurueck
	Rectangle			GetBoundRect() const;

	// skaliert alle Objekte der ImageMap entpr. dem uebergebenen Faktor
	void				Scale( const Fraction& rFractX, const Fraction& rFracY );

	// Im-/Export
	friend SvStream&	operator<<( SvStream& rOStm, const ImageMap& rImageMap );
	friend SvStream&	operator>>( SvStream& rIStm, ImageMap& rImageMap );

	void				Write( SvStream& rOStm, ULONG nFormat ) const;
	ULONG				Read( SvStream& rIStm, ULONG nFormat );
};

/******************************************************************************
|*
|*
|*
\******************************************************************************/

#if 0 // _SOLAR__PRIVATE

class IMapCompat
{
	SvStream*		pRWStm;
	ULONG			nCompatPos;
	ULONG			nTotalSize;
	USHORT			nStmMode;

					IMapCompat() {}
					IMapCompat( const IMapCompat& rCompat ) {}
	IMapCompat&		operator=( const IMapCompat& rCompat ) { return *this; }
	BOOL			operator==( const IMapCompat& rCompat ) { return FALSE; }

public:

					IMapCompat( SvStream& rStm, const USHORT nStreamMode );
					~IMapCompat();
};

#endif // __PRIVATE
#endif // _IMAP_HXX
