/*************************************************************************
 *
 *  $RCSfile: frame.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: mba $ $Date: 2001/06/26 16:15:05 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SFXFRAME_HXX
#define _SFXFRAME_HXX

#ifndef TF_NEWDESKTOP
#define TF_NEWDESKTOP 1
#endif

#ifndef _COM_SUN_STAR_UNO_REFERENCE_H_
#include <com/sun/star/uno/Reference.h>
#endif
#ifndef	_COM_SUN_STAR_UNO_ANY_HXX_
#include <com/sun/star/uno/Any.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif

namespace com
{
    namespace sun
    {
        namespace star
        {
            namespace awt
            {
                class XWindow;
            }
            namespace frame
            {
                class XFrame;
                class XFrameLoader;
                class XController;
                class XDispatchProviderInterceptor;
            }
            namespace beans
            {
                struct PropertyValue;
            }
        }
    }
}

#ifndef _LINK_HXX //autogen
#include <tools/link.hxx>
#endif

#ifndef _REF_HXX //autogen
#include <tools/ref.hxx>
#endif

#ifndef _STRING_HXX //autogen
#include <tools/string.hxx>
#endif
#ifndef _SFXBRDCST_HXX //autogen
#include <svtools/brdcst.hxx>
#endif
#ifndef _LIST_HXX //autogen
#include <tools/list.hxx>
#endif
#ifndef _SFXPOOLITEM_HXX //autogen
#include <svtools/poolitem.hxx>
#endif

class SvBorder;
class SfxWorkWindow;
class Window;
class SfxFrame;
class SfxFrame_Impl;
class SfxObjectShell;
class SfxObjectFactory;
class SfxViewFrame;
class SfxFrameDescriptor;
class SfxFrameSetDescriptor;
class SfxMedium;
class SfxFrameHistory_Impl;
class LoadEnvironment_Impl;
class SfxDispatcher;
class SfxMedium;
class SfxCancellable;
class Rectangle;
class SfxRequest;
class SfxUnoControllerItem;
class SvCompatWeakHdl;

typedef SfxFrame* SfxFramePtr;
class SfxFrameArr_Impl;

DECLARE_LIST( TargetList, String* );

#define SFXFRAME_INTERNAL     0x0001
#define SFXFRAME_EXTERNAL     0x0002
#define SFXFRAME_OWNSDOCUMENT 0x0004
#define SFXFRAME_PLUGIN       0x0008
#define SFXFRAME_HASTITLE     0x0010
#define SFXFRAME_SERVER       0x0020 // Is es ein Frame, der in einem Container steckt ?
#define SFXFRAME_FRAMESET     0x0040

#define BROWSE_NORMAL         0
#define BROWSE_FORWARD        1
#define BROWSE_BACKWARD       2
#define NO_BROWSE		      3
#define BROWSE_FRAME          4
#define BROWSE_MAX_MODE       10

#define SFX_BEAMER_OFF			0
#define SFX_BEAMER_ON 			1
#define SFX_BEAMER_KEEPSTATE	2
#define SFX_BEAMER_SET_ON		3

//==========================================================================
// Ein SfxFrame ist eine Verwaltungsklasse f"ur Fenster und deren Inhalte.
// Eine SfxApplication pr"asentiert sich als Hierarchie von SfxFrames, wobei
// die konkreten Inhalte in den abgeleiteten Klassen festgelegt werden.
// Die Basisklasse SfxFrame implementiert 2 Aspekte der Frames: Benennung und
// Kontrolle der Lebensdauer.
// Innerhalb einer Frames-Hierarchie kontrolliert immer der ParentFrame die
// Lebensdauer seiner ChildFrames, auch wenn sie in der Regel gar nicht von
// ihm selbst erzeugt wurden. Durch Aufruf vonn DoClose() an irgendeinem
// Frame in der Hierarchie kann ein Teil des "Frameworks" entfernt werden,
// wobei sich Frames an ihren ParentFrames selbst abmelden.
//==========================================================================

class SfxFrameArr_Impl;
class SfxCancelManager;
class SfxFrame
{
	friend class SfxFrameIterator;
	friend struct SfxFramePickEntry_Impl;
	friend class SfxUnoFrame;
	friend class SfxViewFrame; /*HACK!*/

private:
	String				aName;
	SfxFrame*			pParentFrame;
	SfxFrameArr_Impl*	pChildArr;
	SfxFrame_Impl*		pImp;
	SfxUnoFrame*		pUnoImp;

	void                UpdateUndoHistory_Impl(
							SfxObjectShell *pDocSh, const String* pNew, const String *pTitle = 0  );
	void                UpdateCurrentHistory_Impl(
							SfxObjectShell *pDocSh, const String* pNew  );

protected:
    virtual sal_Bool    Close() = 0;
	virtual         	~SfxFrame();

#if 0 // _SOLAR__PRIVATE
	void				SetCurrentDocument_Impl( SfxObjectShell* );
	void				InsertChildFrame_Impl( SfxFrame*, sal_uInt16 nPos = 0 );
	void				RemoveChildFrame_Impl( sal_uInt16 nPos );
	void				RemoveChildFrame_Impl( SfxFrame* );
	void				SetIsTop_Impl( sal_Bool bIsTop = sal_True );
#endif

public:
						TYPEINFO();
						SfxFrame(SfxFrame* pParent = 0);

	SvCompatWeakHdl*    GetHdl();
    sal_Bool            TransferForReplaceInProgress() const;
	virtual Window&     GetWindow() const = 0;
	void                CancelTransfers( sal_Bool bCancelLoadEnv = sal_True );
    sal_Bool            DoClose();
    sal_uInt16          GetChildFrameCount() const;
	SfxFrame*			GetChildFrame( sal_uInt16 nPos ) const;
	void				SetFrameName( const String& rName );
	const String&		GetFrameName() const
						{ return aName; }
	SfxFrame*	  		GetParentFrame() const
						{ return pParentFrame; }
	String				GetContent() const;

    static SfxFrame*    GetFirst();
    static SfxFrame*    GetNext( SfxFrame& );

    virtual sal_Bool    InsertDocument( SfxObjectShell *pDoc );
    const SfxPoolItem*  LoadDocumentSynchron( SfxItemSet& aSet );
	void                DocumentInserted( SfxObjectShell* pDoc );

    SfxBroadcaster&     GetBroadcaster() const;
	SfxObjectShell*		GetCurrentDocument() const;
	SfxViewFrame*		GetCurrentViewFrame() const;
	SfxFrame*			GetTopFrame() const;
    sal_Bool            IsParent( SfxFrame* ) const;

    SfxFrame*           findFrame( const ::rtl::OUString& aTargetFrameName, sal_Int32 nSearchFlags);
	SfxFrame*			SearchFrame( const String&, SfxMedium* pMedium = 0 );
    sal_uInt32          GetFrameType() const;
	void				GetTargetList( TargetList& ) const;
	void				ClearHistory();
	SfxFrame*           GetContainingDocFrame_Impl( SfxFrame* pSelf );
    sal_Bool            IsTop() const;
    sal_Bool            CloseChildFrames();
	void				UpdatePickEntries();
	void				UpdatePickEntries( const ::com::sun::star::uno::Any& rValue );
	void 				UpdateHistory( const ::rtl::OUString& aURL, const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& aArgs, const ::rtl::OUString& rTitle );
	void				UpdateHistory(SfxObjectShell*, const String*pNew = 0 );
	void				UpdateDescriptor( SfxObjectShell *pDoc );
	void				Resize();
    sal_Bool            HasComponent() const;
    ::com::sun::star::uno::Reference< ::com::sun::star::awt::XWindow >
                            GetComponent() const;
	void				ReleaseComponent();
    ::com::sun::star::uno::Reference< ::com::sun::star::frame::XFrame >
                            GetFrameInterface() const;
	void 				Appear();
    ::com::sun::star::uno::Reference< ::com::sun::star::frame::XController >
                            GetController() const;

    static sal_Bool     LoadSfxComponent( const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XFrame > &,
                            const ::rtl::OUString&,
                            const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >&,
                            const SfxObjectFactory* );

#if 0 // _SOLAR__PRIVATE
    void                SetFrameInterface_Impl( ::com::sun::star::uno::Reference< ::com::sun::star::frame::XFrame >& rFrame );
	void				ReleasingComponent_Impl( sal_Bool bSet );
    const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatchProviderInterceptor >
                            GetInterceptor_Impl();
    sal_Bool            ActivateNextChildWindow_Impl( sal_Bool );
	void				Clear_Impl();
    sal_uInt16          LoadComponent_Impl( const ::rtl::OUString& rURL,
                            const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& rArgs,
                            const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XFrameLoader > & rLoader,
                            SfxItemSet* pSet=0, sal_Bool bDontClose=sal_False );
	void				LoadFinished_Impl();
    DECL_STATIC_LINK(   SfxFrame, BindingHasNewPart_Impl, void* );
    SfxCancelManager*   GetCancelManager() const;
	void                SetLoadCancelable_Impl( SfxCancellable* );
	void 				GetViewData_Impl();
    sal_Bool            CheckContentForLoad_Impl();
    sal_Bool            ExecuteHistoryMenu_Impl( sal_uInt16 nWnich, const Rectangle& rRect, sal_uInt16 nFlags=0 );
    void                ActivatePickEntry_Impl( SfxFramePickEntry_Impl*, sal_uInt16 nMode, SfxFrameDescriptor *pD = NULL );
	void 				CopyHistory_Impl( SfxFrame *pFrame ) const;
	SfxFrame*			SearchChildrenForName_Impl( const String&, sal_Bool bDeep = sal_True ) const;
	void				SetFrameType_Impl( sal_uInt32 );
	void				Activate_Impl( sal_Bool bBeamerOn );
	void				Deactivate_Impl();
    sal_uInt16          PrepareClose_Impl( sal_Bool bUI, sal_Bool bForBrowsing=sal_False );
    sal_Bool            DocIsModified_Impl();
	void				SetCurrentViewFrame_Impl( SfxViewFrame* );
	SfxFrame*			SearchFrame_Impl( sal_uInt16, sal_Bool bDeep=sal_False );
	SfxFrame*			SearchFrame_Impl( const String&, sal_Bool bDeep=sal_False );
	void				SetFrameId_Impl( sal_uInt16 );
    sal_uInt16          GetFrameId_Impl() const;
	void				SetFrameIdName_Impl( const String& );
    sal_Bool            IsClosing_Impl() const;
	void				SetLoadEnvironment_Impl( LoadEnvironment_Impl *);
	LoadEnvironment_Impl* GetLoadEnvironment_Impl() const;
    sal_Bool            BrowseInFrame( int nDelta );
    sal_Bool            Browse( sal_Bool bForward, sal_uInt16 nDelta = 1, sal_Bool bNewFrame=sal_False );
    sal_Bool            CanBrowseForward() const;
    sal_Bool            CanBrowseBackward() const;

						// Methoden f"ur den Zugriff auf das aktuelle Set
	void				SetDescriptor( SfxFrameDescriptor* );
	SfxFrameDescriptor* GetDescriptor() const;

	void				Lock_Impl( sal_Bool bLock );
    sal_uInt16          GetLockCount_Impl() const;
    sal_Bool            IsLocked_Impl() const
						{ return GetLockCount_Impl() > 0; }
	void				CloseOnUnlock_Impl();
	SfxViewFrame*   	ActivateChildFrame_Impl();
	SfxDispatcher*		GetDispatcher_Impl() const;
    sal_Bool            IsAutoLoadLocked_Impl() const;

	static void         InsertTopFrame_Impl( SfxFrame* pFrame );
	static void         RemoveTopFrame_Impl( SfxFrame* pFrame );
	static void 		BeamerSwitched_Impl( sal_Bool bOn );
	static void 		BeamerSet_Impl();
    sal_uInt16          GetBeamerState_Impl() const;
	void				SetItemSet_Impl( const SfxItemSet* pSet );
	const SfxItemSet* 	GetItemSet_Impl();
	void				SetOwnsBindings_Impl( sal_Bool bSet );
    sal_Bool            OwnsBindings_Impl() const;
	void 				InvalidateUnoControllers_Impl();
	void				RegisterUnoController_Impl( SfxUnoControllerItem* );
	void				ReleaseUnoController_Impl( SfxUnoControllerItem* );
	SfxWorkWindow*		GetWorkWindow_Impl() const;
	void 				SetToolSpaceBorderPixel_Impl( const SvBorder& );
	Rectangle			GetTopOuterRectPixel_Impl() const;
	void				CreateWorkWindow_Impl();
    void                SetWorkWindow_Impl( SfxWorkWindow* pWorkwin );
	const SvBorder&		GetBorder_Impl() const;
	void				GrabFocusOnComponent_Impl();
	void				ReFill_Impl( const SfxFrameSetDescriptor* pSet );
	void 				LockFocus_Impl( sal_Bool bLock );
    sal_Bool            IsFocusLocked_Impl() const;
//	sal_Bool			IsPlugin_Impl() const;
#endif
};

SV_DECL_COMPAT_WEAK( SfxFrame )

class SfxFrameIterator
{
	const SfxFrame*			pFrame;
    sal_Bool                bRecursive;

#if 0 // _SOLAR__PRIVATE
	SfxFrame*				NextSibling_Impl( SfxFrame& rPrev );
#endif

public:
							SfxFrameIterator( const SfxFrame& rFrame, sal_Bool bRecursive=sal_True );
	SfxFrame*				FirstFrame();
	SfxFrame*				NextFrame( SfxFrame& rPrev );
};

//--------------------------------------------------------------------

class SfxFrameItem_Impl;
class SfxFrameItem: public SfxPoolItem
{
	SfxFrame*               pFrame;
	SfxFrameWeak  		    wFrame;
	void                    SetFramePtr_Impl( SfxFrame* pFrameP ) { pFrame = wFrame; }

public:
							TYPEINFO();

							SfxFrameItem( sal_uInt16 nWhich, SfxViewFrame *p );
							SfxFrameItem( SfxFrame *p ):
								SfxPoolItem( 0 ),
								pFrame( p ), wFrame( p ) {}

							SfxFrameItem( sal_uInt16 nWhich, SfxFrame *p ):
								SfxPoolItem( nWhich ),
								pFrame( p ), wFrame( p ){	}

	virtual int 			operator==( const SfxPoolItem& ) const;
	virtual String			GetValueText() const;
	virtual SfxPoolItem*	Clone( SfxItemPool *pPool = 0 ) const;

    sal_Bool                FrameKilled() const { return &wFrame != pFrame; }

	SfxFrame*				GetFrame() const
							{ return wFrame; }
};

class SfxUsrAnyItem : public SfxPoolItem
{
    ::com::sun::star::uno::Any  aValue;
public:
                                TYPEINFO();
                                SfxUsrAnyItem( sal_uInt16 nWhich, const ::com::sun::star::uno::Any& rAny );
    ::com::sun::star::uno::Any  GetValue() const
                                { return aValue; }
    virtual int                 operator==( const SfxPoolItem& ) const;
    virtual String              GetValueText() const;
    virtual SfxPoolItem*        Clone( SfxItemPool *pPool = 0 ) const;
};

typedef SfxUsrAnyItem SfxUnoAnyItem;

#endif
