/*************************************************************************
 *
 *  $RCSfile: dockwin.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: as $ $Date: 2001/11/28 11:20:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SFXDOCKWIN_HXX
#define _SFXDOCKWIN_HXX

#ifndef _DOCKWIN_HXX //autogen
#include <vcl/dockwin.hxx>
#endif
#include <sfx2/childwin.hxx>

class SfxSplitWindow;
class SfxDockingWindow_Impl;

class SfxDockingWindow : public DockingWindow
{
private:
	Rectangle               aInnerRect;
	Rectangle               aOuterRect;
	SfxBindings*            pBindings;
	Size                    aFloatSize;
	SfxChildWindow*         pMgr;
	SfxDockingWindow_Impl*  pImp;

protected:
	SfxChildAlignment   CalcAlignment(const Point& rPos, Rectangle& rRect );
	void                CalcSplitPosition(const Point rPos, Rectangle& rRect,
							SfxChildAlignment eAlign);
	virtual Size        CalcDockingSize(SfxChildAlignment);
	virtual SfxChildAlignment
						CheckAlignment(SfxChildAlignment,SfxChildAlignment);

	virtual void        Resize();
	virtual BOOL        PrepareToggleFloatingMode();
	virtual void        ToggleFloatingMode();
	virtual void        StartDocking();
	virtual BOOL        Docking( const Point& rPos, Rectangle& rRect );
	virtual void        EndDocking( const Rectangle& rRect, BOOL bFloatMode );
	virtual void        Resizing( Size& rSize );
	virtual void        Paint( const Rectangle& rRect );
	virtual BOOL        Close();

#if 0 // _SOLAR__PRIVATE
	SfxChildWindow*		GetChildWindow_Impl()	{ return pMgr; }
#endif

public:
						SfxDockingWindow( SfxBindings *pBindings,
										  SfxChildWindow *pCW,
										  Window* pParent,
										  WinBits nWinBits=0);
						SfxDockingWindow( SfxBindings *pBindings,
										  SfxChildWindow *pCW,
										  Window* pParent,
										  const ResId& rResId);
						~SfxDockingWindow();

	void                Initialize (SfxChildWinInfo* pInfo);
	virtual void        FillInfo(SfxChildWinInfo&) const;
	virtual void		StateChanged( StateChangedType nStateChange );

	void                SetDockingRects(const Rectangle& rOuter, const Rectangle& rInner)
							{ aInnerRect = rInner; aOuterRect = rOuter; }
	const Rectangle&    GetInnerRect() const					{ return aInnerRect; }
	const Rectangle&    GetOuterRect() const					{ return aOuterRect; }
	SfxBindings&        GetBindings() const						{ return *pBindings; }
	USHORT              GetType() const							{ return pMgr->GetType(); }
	SfxChildAlignment   GetAlignment() const					{ return pMgr->GetAlignment(); }
	void                SetAlignment(SfxChildAlignment eAlign)	{ pMgr->SetAlignment(eAlign); }
	Size                GetFloatingSize() const					{ return aFloatSize; }
	void                SetFloatingSize(const Size& rSize)		{ aFloatSize=rSize; }

	void                SetMinOutputSizePixel( const Size& rSize );
	Size                GetMinOutputSizePixel() const;
	virtual long		Notify( NotifyEvent& rNEvt );
	virtual void        FadeIn( BOOL );

#if 0 // _SOLAR__PRIVATE
	void                Initialize_Impl();
	USHORT              GetWinBits_Impl() const;
	void                SetItemSize_Impl( const Size& rSize );
	void 				Disappear_Impl();
	void 				Reappear_Impl();
	BOOL				IsAutoHide_Impl() const;
	BOOL				IsPinned_Impl() const;
	void				AutoShow_Impl( BOOL bShow = TRUE );
	void 				Pin_Impl( BOOL bPinned );
	SfxSplitWindow*		GetSplitWindow_Impl() const;
    void                ReleaseChildWindow_Impl();
#endif
};

#endif // #ifndef _SFXDOCKWIN_HXX

