/*************************************************************************
 *
 *  $RCSfile: ldapwrap.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:31:16 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _INET_LDAPWRAP_HXX
#define _INET_LDAPWRAP_HXX "$Revision: 1.1.1.1 $"

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#ifndef _VOS_REF_HXX_
#include <vos/ref.hxx>
#endif

#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif

#ifndef _INET_MACROS_HXX
#include <inet/macros.hxx>
#endif

class INetCoreLDAPConnection;

class INetCoreLDAPSearchRequestMessage;
class INetCoreLDAPModifyRequestMessage;

class INetCoreLDAPAttributeValuePair;
class INetCoreLDAPAttribute;
class INetCoreLDAPEntry;
class INetCoreLDAPModification;

class INetCoreLDAPAndFilter;
class INetCoreLDAPOrFilter;
class INetCoreLDAPNotFilter;

class INetCoreLDAPEqualityMatchFilter;
class INetCoreLDAPApproxMatchFilter;

class INetCoreLDAPGreaterOrEqualFilter;
class INetCoreLDAPLessOrEqualFilter;

class INetCoreLDAPPresentFilter;
class INetCoreLDAPSubstringFilter;

#ifdef _USE_NAMESPACE
namespace inet {
#endif

/*========================================================================
 *
 * INetLDAPWrapper interface.
 *
 *======================================================================*/
class INetLDAPWrapper : public NAMESPACE_VOS(OMutex)
{
	VOS_DECLARE_CLASSINFO (VOS_NAMESPACE (INetLDAPWrapper, inet));

public:
	/** Construction.
	 *  @see INetWrapper::newINetLDAPWrapper().
	 */
	INetLDAPWrapper (void);
	virtual ~INetLDAPWrapper (void);

	/** Create a new INetCoreLDAPConnection instance.
	 *  @param  rxConnection [out].
	 *  @return sal_True upon success, sal_False otherwise.
	 */
	virtual sal_Bool newLDAPConnection (
		NAMESPACE_VOS(ORef)<INetCoreLDAPConnection> &rxConnection);

	/** Create a new INetCoreLDAPSearchRequestMessage instance.
	 *  @param  rpMessage [out].
	 *  @return sal_True upon success, sal_False otherwise.
	 */
	virtual sal_Bool newLDAPSearchRequestMessage (
		INetCoreLDAPSearchRequestMessage *&rpMessage);

	/** Create a new INetCoreLDAPModifyRequestMessage instance.
	 *  @param  rpMessage [out].
	 *  @return sal_True upon success, sal_False otherwise.
	 */
	virtual sal_Bool newLDAPModifyRequestMessage (
		INetCoreLDAPModifyRequestMessage *&rpMessage);

	/** Create a new INetCoreLDAPAttributeValuePair instance.
	 *  @param  rpAttribValuePair [out].
	 *  @return sal_True upon success, sal_False otherwise.
	 */
	virtual sal_Bool newLDAPAttributeValuePair (
		INetCoreLDAPAttributeValuePair *&rpAttribValuePair);

	/** Create a new INetCoreLDAPAttribute instance.
	 *  @param  rpAttrib [out].
	 *  @return sal_True upon success, sal_False otherwise.
	 */
	virtual sal_Bool newLDAPAttribute (
		INetCoreLDAPAttribute *&rpAttrib);

	/** Create a new INetCoreLDAPEntry instance.
	 *  @param  rpEntry [out].
	 *  @return sal_True upon success, sal_False otherwise.
	 */
	virtual sal_Bool newLDAPEntry (
		INetCoreLDAPEntry *&rpEntry);

	/** Create a new INetCoreLDAPModification instance.
	 *  @param  rpModification [out].
	 *  @return sal_True upon success, sal_False otherwise.
	 */
	virtual sal_Bool newLDAPModification (
		INetCoreLDAPModification *&rpModification);

	/** Create a new INetCoreLDAPAndFilter instance.
	 *  @param  rpFilter [out].
	 *  @return sal_True upon success, sal_False otherwise.
	 */
	virtual sal_Bool newLDAPAndFilter (
		INetCoreLDAPAndFilter *&rpFilter);

	/** Create a new INetCoreLDAPOrFilter instance.
	 *  @param  rpFilter [out].
	 *  @return sal_True upon success, sal_False otherwise.
	 */
	virtual sal_Bool newLDAPOrFilter (
		INetCoreLDAPOrFilter *&rpFilter);

	/** Create a new INetCoreLDAPNotFilter instance.
	 *  @param  rpFilter [out].
	 *  @return sal_True upon success, sal_False otherwise.
	 */
	virtual sal_Bool newLDAPNotFilter (
		INetCoreLDAPNotFilter *&rpFilter);

	/** Create a new INetCoreLDAPEqualityMatchFilter instance.
	 *  @param  rpFilter [out].
	 *  @return sal_True upon success, sal_False otherwise.
	 */
	virtual sal_Bool newLDAPEqualityMatchFilter (
		INetCoreLDAPEqualityMatchFilter *&rpFilter);

	/** Create a new INetCoreLDAPApproxMatchFilter instance.
	 *  @param  rpFilter [out].
	 *  @return sal_True upon success, sal_False otherwise.
	 */
	virtual sal_Bool newLDAPApproxMatchFilter (
		INetCoreLDAPApproxMatchFilter *&rpFilter);

	/** Create a new INetCoreLDAPGreaterOrEqualFilter instance.
	 *  @param  rpFilter [out].
	 *  @return sal_True upon success, sal_False otherwise.
	 */
	virtual sal_Bool newLDAPGreaterOrEqualFilter (
		INetCoreLDAPGreaterOrEqualFilter *&rpFilter);

	/** Create a new INetCoreLDAPLessOrEqualFilter instance.
	 *  @param  rpFilter [out].
	 *  @return sal_True upon success, sal_False otherwise.
	 */
	virtual sal_Bool newLDAPLessOrEqualFilter (
		INetCoreLDAPLessOrEqualFilter *&rpFilter);

	/** Create a new INetCoreLDAPPresentFilter instance.
	 *  @param  rpFilter [out].
	 *  @return sal_True upon success, sal_False otherwise.
	 */
	virtual sal_Bool newLDAPPresentFilter (
		INetCoreLDAPPresentFilter *&rpFilter);

	/** Create a new INetCoreLDAPSubstringFilter instance.
	 *  @param  rpFilter [out].
	 *  @return sal_True upon success, sal_False otherwise.
	 */
	virtual sal_Bool newLDAPSubstringFilter (
		INetCoreLDAPSubstringFilter *&rpFilter);

private:
	/** Not implemented.
	 */
	INetLDAPWrapper (const INetLDAPWrapper&);
	INetLDAPWrapper& operator= (const INetLDAPWrapper&);
};

/*========================================================================
 *
 * The End.
 *
 *======================================================================*/
#ifdef _USE_NAMESPACE
}
#endif

extern "C" {
	NAMESPACE_INET(INetLDAPWrapper)* SAL_CALL NewINetLDAPWrapper (void);
}

#endif /* !_INET_LDAPWRAP_HXX */

