/*************************************************************************
 *
 *  $RCSfile: copyprj.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:02:59 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _COPYPRJ_HXX
#define _COPYPRJ_HXX

#include <tools/fsys.hxx>
#include <tools/string.hxx>
#include <tools/stream.hxx>
#include <tools/sstring.hxx>

// forwards

class GenericInformationList;
class GenericInformation;
class OutpathList;

//
// class ProjectCop
//

/*****************************************************************************
Purpose: copies whole project to chooseable destination path
*****************************************************************************/

#define PC_DATA_VALID					0x0000
#define PC_PROJECT_NOT_VALID 			0x0001
#define PC_VERSION_NOT_VALID 			0x0002
#define PC_DESTINATIONPATH_NOT_EXIST    0x0004
#define PC_SOURCEPATH_NOT_EXIST			0x0008
#define PC_DSTVERSION_NOT_VALID 		0x000F

#define PC_COPYACTION_OK				0x0000
#define PC_COPYACTION_FAILED			0x0001
#define PC_COPYACTION_NOMEMORY			0x0002

class ProjectCop
{
private:
	ByteString 	sProject;					// holds the project name
	ByteString 	sVersion;					// holds the source version
	ByteString  sDstVersion;				// holds destination (tskforc)
	ByteString 	sDestination;				// holds the destination path
	ByteString	sSource;					// holds source path

	GenericInformationList *pList;
	GenericInformation *pStand;

	GenericInformation *pDstVer;

	GenericInformationList *pEnvList;
	OutpathList *pDstEnvs;

	BOOL	bCopyPrj;					// specifies called CTor
	BOOL	bDontDelete;
	BOOL	bAddVerName;
	BOOL	bAddOutPath;
	BOOL	bOnlyOutPath;
	BOOL	bUpdate;
	BOOL	bFlatVersion;

	/**
		iterates over a tree
		bCopyAllDirs	copy everything regardless of switches and environment
	**/
	BOOL	CopyDirectory( DirEntry &rDir, BOOL bCopyAllDirs = FALSE );
	BOOL	CVSPatch( ByteString &rSrc, ByteString &rDest );

protected:
	virtual void PrintStatus( const char* cStatus ) = 0;

public:
	// CTor used by copyprj
	ProjectCop( ByteString &rPrj, ByteString &rVer, ByteString &rDest,
			BOOL bAddPath = TRUE, BOOL bOutPath = TRUE, BOOL bFlat = FALSE,
			BOOL bOnlyOutpath = FALSE, BOOL bUpdate = FALSE );
	// CTor used by creating taskforces
	ProjectCop( ByteString &rSrcVer, ByteString &rDstVer,
				OutpathList *pEnvs = NULL,
				GenericInformationList *pIList = NULL,
				BOOL bAddPath = TRUE, BOOL bOutPath = TRUE, BOOL bFlat=FALSE );

	~ProjectCop();

	USHORT	IsValid(); 					// checks data
	USHORT	Copy();						// copy action

	USHORT	Copy( ByteString &rPrj );		// used for taskforces
};

#endif
