/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.environments.remote;

import com.sun.star.lib.uno.environments.remote.IThreadPool;
import com.sun.star.lib.uno.environments.remote.JavaThreadPoolFactory;
import com.sun.star.lib.uno.environments.remote.Job;
import com.sun.star.lib.uno.environments.remote.JobQueue;
import com.sun.star.lib.uno.environments.remote.ThreadId;

public class JavaThreadPool
implements IThreadPool {
    private static final boolean DEBUG = false;
    JavaThreadPoolFactory _javaThreadPoolFactory;

    JavaThreadPool(JavaThreadPoolFactory javaThreadPoolFactory) {
        this._javaThreadPoolFactory = javaThreadPoolFactory;
    }

    public void attach() {
        ThreadId threadId = this._javaThreadPoolFactory.getThreadId();
        JobQueue jobQueue = this._javaThreadPoolFactory.getJobQueue(threadId);
        if (jobQueue == null) {
            jobQueue = new JobQueue(this._javaThreadPoolFactory, threadId, false);
        }
        jobQueue.acquire();
    }

    public void detach() {
        ThreadId threadId = this._javaThreadPoolFactory.getThreadId();
        JobQueue jobQueue = this._javaThreadPoolFactory.getJobQueue(threadId);
        jobQueue.release();
    }

    public Object enter() throws Throwable {
        ThreadId threadId = this._javaThreadPoolFactory.getThreadId();
        JobQueue jobQueue = this._javaThreadPoolFactory.getJobQueue(threadId);
        return jobQueue.enter(this);
    }

    public void putJob(Job job) {
        if (job.isSynchron() || job.getOperation() == null) {
            JobQueue jobQueue = this._javaThreadPoolFactory.getJobQueue(job.getThreadId());
            if (jobQueue == null) {
                jobQueue = new JobQueue(this._javaThreadPoolFactory, job.getThreadId(), true);
            }
            jobQueue.putJob(job, this);
        } else {
            JavaThreadPoolFactory javaThreadPoolFactory = this._javaThreadPoolFactory;
            synchronized (javaThreadPoolFactory) {
                JobQueue jobQueue = this._javaThreadPoolFactory.getAsyncJobQueue(job.getThreadId());
                if (jobQueue == null) {
                    jobQueue = new JobQueue(this._javaThreadPoolFactory, job.getThreadId());
                }
                jobQueue.putJob(job, this);
            }
        }
    }

    public void dispose(Throwable throwable) {
        this._javaThreadPoolFactory.dispose(this, throwable);
    }

    public void destroy() {
    }
}

