/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.helper;

import com.sun.star.lang.EventObject;
import com.sun.star.lang.XEventListener;
import com.sun.star.uno.UnoRuntime;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class InterfaceContainer
implements Cloneable {
    final boolean DEBUG = false;
    Object[] elementData;
    private int size;
    static /* synthetic */ Class class$com$sun$star$lang$XEventListener;

    public InterfaceContainer() {
        this(10);
    }

    public InterfaceContainer(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        this.elementData = new Object[n];
    }

    public synchronized void trimToSize() {
        int n = this.elementData.length;
        if (this.size < n) {
            Object[] objectArray = this.elementData;
            this.elementData = new Object[this.size];
            System.arraycopy(objectArray, 0, this.elementData, 0, this.size);
        }
    }

    public synchronized void ensureCapacity(int n) {
        int n2 = this.elementData.length;
        if (n > n2) {
            Object[] objectArray = this.elementData;
            int n3 = n2 * 3 / 2 + 1;
            if (n3 < n) {
                n3 = n;
            }
            this.elementData = new Object[n3];
            System.arraycopy(objectArray, 0, this.elementData, 0, this.size);
        }
    }

    public synchronized boolean add(Object object) {
        boolean bl = false;
        if (this.elementData != null && object != null) {
            this.ensureCapacity(this.size + 1);
            this.elementData[this.size++] = object;
            bl = true;
        }
        return bl;
    }

    public synchronized void add(int n, Object object) {
        if (this.elementData != null && object != null) {
            if (n > this.size || n < 0) {
                throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
            }
            this.ensureCapacity(this.size + 1);
            System.arraycopy(this.elementData, n, this.elementData, n + 1, this.size - n);
            this.elementData[n] = object;
            ++this.size;
        }
    }

    public synchronized boolean addAll(Collection collection) {
        int n = collection.size();
        this.ensureCapacity(this.size + n);
        Iterator iterator = collection.iterator();
        int n2 = 0;
        while (n2 < n) {
            Object e = iterator.next();
            if (e != null) {
                this.elementData[this.size++] = e;
            }
            ++n2;
        }
        return n != 0;
    }

    public synchronized boolean addAll(int n, Collection collection) {
        boolean bl = false;
        if (this.elementData != null) {
            if (n > this.size || n < 0) {
                throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
            }
            int n2 = collection.size();
            Object[] objectArray = new Object[n2];
            Iterator iterator = collection.iterator();
            int n3 = 0;
            int n4 = 0;
            while (n4 < n2) {
                Object e = iterator.next();
                if (e != null) {
                    objectArray[n3++] = e;
                }
                ++n4;
            }
            int n5 = n3;
            this.ensureCapacity(this.size + n5);
            int n6 = this.size - n;
            if (n6 > 0) {
                System.arraycopy(this.elementData, n, this.elementData, n + n5, n6);
            }
            int n7 = 0;
            while (n7 < n5) {
                this.elementData[n++] = objectArray[n7];
                ++n7;
            }
            this.size += n5;
            bl = n5 != 0;
        }
        return bl;
    }

    public synchronized void clear() {
        if (this.elementData != null) {
            int n = 0;
            while (n < this.size) {
                this.elementData[n] = null;
                ++n;
            }
            this.size = 0;
        }
    }

    public synchronized boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    public synchronized boolean containsAll(Collection collection) {
        boolean bl = true;
        if (this.elementData != null && collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (this.contains(e)) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public synchronized Object get(int n) {
        if (this.elementData != null) {
            this.RangeCheck(n);
            return this.elementData[n];
        }
        return null;
    }

    public synchronized int indexOf(Object object) {
        int n = -1;
        if (this.elementData != null && object != null) {
            int n2 = 0;
            while (n2 < this.size) {
                if (object == this.elementData[n2]) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            if (n == -1) {
                int n3 = 0;
                while (n3 < this.size) {
                    if (UnoRuntime.areSame((Object)object, (Object)this.elementData[n3])) {
                        n = n3;
                        break;
                    }
                    ++n3;
                }
            }
        }
        return n;
    }

    public synchronized boolean isEmpty() {
        return this.size == 0;
    }

    public synchronized Iterator iterator() {
        if (this.elementData != null) {
            InterfaceContainer interfaceContainer = (InterfaceContainer)this.clone();
            return new Itr(interfaceContainer);
        }
        return null;
    }

    public synchronized int lastIndexOf(Object object) {
        int n = -1;
        if (this.elementData != null && object != null) {
            int n2 = this.size - 1;
            while (n2 >= 0) {
                if (object == this.elementData[n2]) {
                    n = n2;
                    break;
                }
                --n2;
            }
            if (n == -1) {
                int n3 = this.size - 1;
                while (n3 >= 0) {
                    if (UnoRuntime.areSame((Object)object, (Object)this.elementData[n3])) {
                        n = n3;
                        break;
                    }
                    --n3;
                }
            }
        }
        return n;
    }

    public synchronized Object clone() {
        InterfaceContainer interfaceContainer = null;
        if (this.elementData != null) {
            InterfaceContainer interfaceContainer2 = new InterfaceContainer();
            interfaceContainer2.elementData = new Object[this.size];
            interfaceContainer2.size = this.size;
            System.arraycopy(this.elementData, 0, interfaceContainer2.elementData, 0, this.size);
            interfaceContainer = interfaceContainer2;
        }
        return interfaceContainer;
    }

    public synchronized ListIterator listIterator() {
        return this.listIterator(0);
    }

    public synchronized ListIterator listIterator(int n) {
        if (this.elementData != null) {
            InterfaceContainer interfaceContainer = (InterfaceContainer)this.clone();
            return new LstItr(interfaceContainer, n);
        }
        return null;
    }

    public synchronized Object remove(int n) {
        Object object = null;
        if (this.elementData != null) {
            this.RangeCheck(n);
            object = this.elementData[n];
            int n2 = this.size - n - 1;
            if (n2 > 0) {
                System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
            }
            this.elementData[--this.size] = null;
        }
        return object;
    }

    public synchronized boolean remove(Object object) {
        int n;
        boolean bl = false;
        if (this.elementData != null && object != null && (n = this.indexOf(object)) != -1) {
            bl = true;
            this.remove(n);
        }
        return bl;
    }

    public synchronized boolean removeAll(Collection collection) {
        boolean bl = false;
        if (this.elementData != null && collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                boolean bl2 = this.remove(e);
                if (!bl2) continue;
                bl = true;
            }
        }
        return bl;
    }

    public synchronized boolean retainAll(Collection collection) {
        boolean bl = false;
        if (this.elementData != null && collection != null) {
            Object[] objectArray = new Object[this.size];
            int n = 0;
            int n2 = 0;
            while (n2 < this.size) {
                Object object = this.elementData[n2];
                Iterator iterator = collection.iterator();
                boolean bl2 = false;
                while (iterator.hasNext()) {
                    if (object != iterator.next()) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        if (e == null || !UnoRuntime.areSame(e, (Object)object)) continue;
                        bl2 = true;
                        break;
                    }
                }
                if (bl2) {
                    objectArray[n++] = object;
                }
                ++n2;
            }
            boolean bl3 = bl = this.size != n;
            if (n > 0) {
                this.elementData = objectArray;
                this.size = n;
            }
        }
        return bl;
    }

    public synchronized Object set(int n, Object object) {
        Object object2 = null;
        if (this.elementData != null && object != null) {
            this.RangeCheck(n);
            object2 = this.elementData[n];
            this.elementData[n] = object;
        }
        return object2;
    }

    public synchronized int size() {
        if (this.elementData != null) {
            return this.size;
        }
        return 0;
    }

    public synchronized Object[] toArray() {
        if (this.elementData != null) {
            Object[] objectArray = new Object[this.size];
            System.arraycopy(this.elementData, 0, objectArray, 0, this.size);
            return objectArray;
        }
        return null;
    }

    public synchronized Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this.size) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.size);
        }
        if (this.elementData != null) {
            System.arraycopy(this.elementData, 0, objectArray, 0, this.size);
        }
        if (objectArray.length > this.size) {
            objectArray[this.size] = null;
        }
        return objectArray;
    }

    private void RangeCheck(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
    }

    public void disposeAndClear(EventObject eventObject) {
        Iterator iterator;
        InterfaceContainer interfaceContainer = this;
        synchronized (interfaceContainer) {
            iterator = this.iterator();
            this.clear();
            this.elementData = null;
            this.size = 0;
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                try {
                    Object e = iterator.next();
                    XEventListener xEventListener = (XEventListener)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XEventListener == null ? InterfaceContainer.class$("com.sun.star.lang.XEventListener") : class$com$sun$star$lang$XEventListener), e);
                    if (xEventListener == null) continue;
                    xEventListener.disposing(eventObject);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class LstItr
    extends Itr
    implements ListIterator {
        LstItr(InterfaceContainer interfaceContainer2, int n) {
            super(interfaceContainer2);
            this.cursor = n;
        }

        public synchronized void add(Object object) {
            InterfaceContainer.this.add(object);
            this.dataIt.add(this.cursor++, object);
            this.lastRet = -1;
            this.lastRetObj = null;
        }

        public synchronized boolean hasPrevious() {
            return this.cursor != 0;
        }

        public synchronized int nextIndex() {
            return this.cursor;
        }

        public synchronized Object previous() {
            try {
                Object object = this.dataIt.get(--this.cursor);
                this.lastRet = this.cursor;
                this.lastRetObj = object;
                return object;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        public synchronized int previousIndex() {
            return this.cursor - 1;
        }

        public synchronized void set(Object object) {
            throw new UnsupportedOperationException();
        }
    }

    private class Itr
    implements Iterator {
        InterfaceContainer dataIt;
        int cursor = 0;
        int lastRet = -1;
        Object lastRetObj = null;

        Itr(InterfaceContainer interfaceContainer2) {
            this.dataIt = interfaceContainer2;
        }

        public synchronized boolean hasNext() {
            return this.cursor != this.dataIt.size();
        }

        public synchronized Object next() {
            try {
                Object object = this.dataIt.get(this.cursor);
                this.lastRet = this.cursor++;
                this.lastRetObj = object;
                return object;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        public synchronized void remove() {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            InterfaceContainer.this.remove(this.lastRetObj);
            this.dataIt.remove(this.lastRet);
            if (this.lastRet < this.cursor) {
                --this.cursor;
            }
            this.lastRet = -1;
            this.lastRetObj = null;
        }
    }
}

