/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xmlsearch.xml.qe;

import com.sun.xmlsearch.xml.qe.QueryHit;
import java.util.Arrays;

final class HitStore {
    private final int _limit;
    private double _standard;
    private final QueryHit[] _heap;
    private int _free;
    private int _index;
    private final int _nColumns;

    public HitStore(double d, int n, int n2) {
        this._standard = d;
        this._limit = n;
        this._heap = new QueryHit[this._limit];
        this._nColumns = n2;
    }

    public final boolean goodEnough(double d, int n, int n2) {
        return this._free == this._limit ? this._heap[0].worseThan(d, n, n2) : true;
    }

    public QueryHit createQueryHit(double d, int n, int n2, int n3) {
        QueryHit queryHit = new QueryHit(this._nColumns, d, n, n2, n3);
        if (this._free == this._limit) {
            this._heap[0] = queryHit;
            this.heapify(0);
            this._standard = this._heap[0].getPenalty();
        } else if (this._free < this._limit) {
            this._heap[this._free++] = queryHit;
            if (this._free == this._limit) {
                int n4 = this._free / 2;
                while (n4 >= 0) {
                    this.heapify(n4);
                    --n4;
                }
                this._standard = this._heap[0].getPenalty();
            }
        }
        return queryHit;
    }

    private final void heapify(int n) {
        while (true) {
            int n2;
            int n3;
            int n4;
            int n5 = n4 = (n3 = (n2 = n + 1 << 1) - 1) < this._free && this._heap[n].betterThan(this._heap[n3]) ? n3 : n;
            if (n2 < this._free && this._heap[n4].betterThan(this._heap[n2])) {
                n4 = n2;
            }
            if (n4 == n) break;
            QueryHit queryHit = this._heap[n4];
            this._heap[n4] = this._heap[n];
            this._heap[n] = queryHit;
            n = n4;
        }
    }

    public QueryHit firstBestQueryHit() {
        if (this._free > 0) {
            Arrays.sort(this._heap, 0, this._free);
            this._index = 0;
            return this.nextBestQueryHit();
        }
        return null;
    }

    public final QueryHit nextBestQueryHit() {
        return this._index < this._free ? this._heap[this._index++] : null;
    }

    public final double getCurrentStandard() {
        return this._standard;
    }
}

