/*************************************************************************
*
*  $RCSfile: SimpleBeanBeanInfo.java,v $
*
*  $Revision: 1.1 $
*
*  last change: $Author: dschulten $ $Date: 2002/10/25 12:38:05 $
*
*  The Contents of this file are made available subject to the terms of
*  either of the following licenses
*
*         - GNU Lesser General Public License Version 2.1
*         - Sun Industry Standards Source License Version 1.1
*
*  Sun Microsystems Inc., October, 2000
*
*  GNU Lesser General Public License Version 2.1
*  =============================================
*  Copyright 2000 by Sun Microsystems, Inc.
*  901 San Antonio Road, Palo Alto, CA 94303, USA
*
*  This library is free software; you can redistribute it and/or
*  modify it under the terms of the GNU Lesser General Public
*  License version 2.1, as published by the Free Software Foundation.
*
*  This library is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*  Lesser General Public License for more details.
*
*  You should have received a copy of the GNU Lesser General Public
*  License along with this library; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
*  MA  02111-1307  USA
*
*
*  Sun Industry Standards Source License Version 1.1
*  =================================================
*  The contents of this file are subject to the Sun Industry Standards
*  Source License Version 1.1 (the "License"); You may not use this file
*  except in compliance with the License. You may obtain a copy of the
*  License at http://www.Office.org/license.html.
*
*  Software provided under this License is provided on an "AS IS" basis,
*  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
*  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
*  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
*  See the License for the specific provisions governing your rights and
*  obligations concerning the Software.
*
*  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
*
*  Copyright: 2000 by Sun Microsystems, Inc.
*
*  All Rights Reserved.
*
*  Contributor(s): _______________________________________
*
*
************************************************************************/
import java.beans.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.event.*;
import com.sun.star.beans.*;

/** The BeanInfo class for the bean SimpleBean. */

public class SimpleBeanBeanInfo extends BeanInfoAdapter
{
  /**
   * Public constructor
   */
	public SimpleBeanBeanInfo()
	{
	    addStandardBooleanRWPropertyDescriptor("MenuBarVisible", true, false);

	    addMethodDescriptors("load");
	    addMethodDescriptors("closeConnection");
	    addMethodDescriptors("setOfficeConnection");
	}
  
  /**
   * Returns the Bean Class
   * @return The SimpleBean class
   */
	public Class getBeanClass()
	{
		return SimpleBean.class;
	}

  /**
   * Get the Display name for the Bean
   * @return Returns a string - <code>Simple Bean</code>
   */
	public String getDisplayName()
	{
		return "Simple Bean";
	}
 
  /**
   * Gets an Icon to be displayed
   *
   * @param iconKind The kind of icon to be displayed
   * @return An Image of the icon
   */
	public java.awt.Image getIcon(int iconKind)
	{
		if (iconKind == BeanInfo.ICON_COLOR_16x16) {
			java.awt.Image img = loadImage("OfficeIconColor16.jpg");
			return img;
		}

		if (iconKind == BeanInfo.ICON_COLOR_32x32) {
			java.awt.Image img = loadImage("OfficeIconColor32.jpg");
			return img;
		}

		if (iconKind == BeanInfo.ICON_MONO_16x16) {
			java.awt.Image img = loadImage("OfficeIconMono16.jpg");
			return img;
		}

		if (iconKind == BeanInfo.ICON_MONO_32x32) {
			java.awt.Image img = loadImage("OfficeIconMono32.jpg");
			return img;
		}
		return null;
	}
}
