/*************************************************************************
 *
 *  $RCSfile: dockwin.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2000/12/07 13:37:15 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_DOCKWIN_HXX
#define _SV_DOCKWIN_HXX

#ifndef _SV_SV_H
#include <vcl/sv.h>
#endif
#ifndef _SV_FLOATWIN_HXX
#include <vcl/floatwin.hxx>
#endif

// -----------------
// - DockingWindow -
// -----------------

class DockingWindow : public Window
{
private:
	FloatingWindow* mpFloatWin;
	Window* 		mpOldBorderWin;
	Window* 		mpParent;
	Point			maFloatPos;
	Point			maDockPos;
	Point			maMouseOff;
	Point			maMouseStart;
	Size			maRollUpOutSize;
	Size			maMinOutSize;
	long			mnTrackX;
	long			mnTrackY;
	long			mnTrackWidth;
	long			mnTrackHeight;
	long			mnDockLeft;
	long			mnDockTop;
	long			mnDockRight;
	long			mnDockBottom;
	WinBits 		mnFloatBits;
	BOOL			mbDockCanceled:1,
					mbDockPrevented:1,
					mbFloatPrevented:1,
					mbDockable:1,
					mbDocking:1,
					mbDragFull:1,
					mbLastFloatMode:1,
					mbStartFloat:1,
					mbTrackDock:1,
					mbPined:1,
					mbRollUp:1,
					mbDockBtn:1,
					mbHideBtn:1,
					mbDummy1:1,
					mbDummy2:1,
					mbDummy3:1;

#if 0 // _SOLAR__PRIVATE
#ifdef _SV_DOCKWIN_CXX
	void			ImplInitData();
#endif

protected:
	void			ImplInit( Window* pParent, WinBits nStyle );
	void			ImplInitSettings();
	void			ImplLoadRes( const ResId& rResId );

public:
	BOOL			ImplStartDocking( const Point& rPos );
#endif

protected:
					DockingWindow( WindowType nType );

public:
					DockingWindow( Window* pParent, WinBits nStyle = WB_STDDOCKWIN );
					DockingWindow( Window* pParent, const ResId& rResId );
					~DockingWindow();

	virtual void	StartDocking();
	virtual BOOL	Docking( const Point& rPos, Rectangle& rRect );
	virtual void	EndDocking( const Rectangle& rRect, BOOL bFloatMode );
	virtual BOOL	PrepareToggleFloatingMode();
	virtual void	ToggleFloatingMode();

	virtual void	TitleButtonClick( USHORT nButton );
	virtual void	Pin();
	virtual void	Roll();
	virtual void	PopupModeEnd();
	virtual void	Resizing( Size& rSize );
	virtual BOOL	Close();
	virtual void	Tracking( const TrackingEvent& rTEvt );
	virtual long	Notify( NotifyEvent& rNEvt );
	virtual void	StateChanged( StateChangedType nType );
	virtual void	DataChanged( const DataChangedEvent& rDCEvt );

	void			ShowTitleButton( USHORT nButton, BOOL bVisible = TRUE );
	BOOL			IsTitleButtonVisible( USHORT nButton ) const;

	void			SetPin( BOOL bPin );
	BOOL			IsPined() const;

	void			RollUp();
	void			RollDown();
	BOOL			IsRollUp() const;

	void			SetRollUpOutputSizePixel( const Size& rSize );
	Size			GetRollUpOutputSizePixel() const;

	void			SetMinOutputSizePixel( const Size& rSize );
	const Size& 	GetMinOutputSizePixel() const;

	BOOL			IsDockingCanceled() const { return mbDockCanceled; }
	BOOL			IsDockingPrevented() const { return mbDockPrevented; }
	BOOL			IsFloatingPrevented() const { return mbFloatPrevented; }

	void			SetFloatingMode( BOOL bFloatMode = FALSE );
	BOOL			IsFloatingMode() const;
	FloatingWindow* GetFloatingWindow() const { return mpFloatWin; }

	void			SetFloatingPos( const Point& rNewPos );
	Point			GetFloatingPos() const;

	void			SetFloatStyle( WinBits nWinStyle );
	WinBits 		GetFloatStyle() const;
	void			SetTabStop();

	virtual void	SetPosSizePixel( long nX, long nY,
									 long nWidth, long nHeight,
									 USHORT nFlags = WINDOW_POSSIZE_ALL );
	void			SetPosSizePixel( const Point& rNewPos,
									 const Size& rNewSize )
						{ Window::SetPosSizePixel( rNewPos, rNewSize ); }
	Point			GetPosPixel() const;
	Size			GetSizePixel() const;
	void			SetOutputSizePixel( const Size& rNewSize );
	Size			GetOutputSizePixel() const;
};

inline void DockingWindow::SetPin( BOOL bPin )
{
	if ( mpFloatWin )
		mpFloatWin->SetPin( bPin );
	mbPined = bPin;
}

inline BOOL DockingWindow::IsPined() const
{
	if ( mpFloatWin )
		return mpFloatWin->IsPined();
	return mbPined;
}

inline void DockingWindow::RollUp()
{
	if ( mpFloatWin )
		mpFloatWin->RollUp();
	mbRollUp = TRUE;
}

inline void DockingWindow::RollDown()
{
	if ( mpFloatWin )
		mpFloatWin->RollDown();
	mbRollUp = FALSE;
}

inline BOOL DockingWindow::IsRollUp() const
{
	if ( mpFloatWin )
		return mpFloatWin->IsRollUp();
	return mbRollUp;
}

inline void DockingWindow::SetRollUpOutputSizePixel( const Size& rSize )
{
	if ( mpFloatWin )
		mpFloatWin->SetRollUpOutputSizePixel( rSize );
	maRollUpOutSize = rSize;
}

inline Size DockingWindow::GetRollUpOutputSizePixel() const
{
	if ( mpFloatWin )
		return mpFloatWin->GetRollUpOutputSizePixel();
	return maRollUpOutSize;
}

inline void DockingWindow::SetMinOutputSizePixel( const Size& rSize )
{
	if ( mpFloatWin )
		mpFloatWin->SetMinOutputSizePixel( rSize );
	maMinOutSize = rSize;
}

inline const Size& DockingWindow::GetMinOutputSizePixel() const
{
	if ( mpFloatWin )
		return mpFloatWin->GetMinOutputSizePixel();
	return maMinOutSize;
}

inline void DockingWindow::SetFloatingPos( const Point& rNewPos )
{
	if ( mpFloatWin )
		mpFloatWin->SetPosPixel( rNewPos );
	else
		maFloatPos = rNewPos;
}

inline Point DockingWindow::GetFloatingPos() const
{
	if ( mpFloatWin )
		return mpFloatWin->GetPosPixel();
	else
		return maFloatPos;
}

inline BOOL DockingWindow::IsFloatingMode() const
{
	return (mpFloatWin != NULL);
}

#endif	// _SV_DOCKWIN_HXX
