/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.beans;

import com.sun.star.beans.ContainerFactory;
import com.sun.star.beans.LocalOfficeWindow;
import com.sun.star.beans.NativeConnection;
import com.sun.star.beans.NativeService;
import com.sun.star.beans.OfficeConnection;
import com.sun.star.beans.OfficeWindow;
import com.sun.star.beans.XPropertySet;
import com.sun.star.bridge.XBridge;
import com.sun.star.bridge.XBridgeFactory;
import com.sun.star.comp.loader.JavaLoader;
import com.sun.star.connection.XConnection;
import com.sun.star.container.XSet;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XEventListener;
import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.loader.XImplementationLoader;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.awt.Container;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class LocalOfficeConnection
implements OfficeConnection {
    public static final String OFFICE_APP_NAME = "soffice";
    public static final String OFFICE_LIB_NAME = "officebean";
    public static final String OFFICE_PROP_FILE = "officebean.properties";
    public static final String OFFICE_CONN_PROT = "urp";
    public static final String OFFICE_BRIDGE_NAME = "officebridge";
    public static final String OFFICE_ID_SUFFIX = "_Office";
    private String mURL;
    private ContainerFactory mContainerFactory;
    private XMultiServiceFactory mLocalServiceFactory;
    private String mProgramPath;
    private String mLibPath;
    private String mPipeName;
    private XConnection mConnection;
    private XBridge mBridge;
    private XComponentContext mComponentContext;
    private List mComponents = new Vector();
    static /* synthetic */ Class class$com$sun$star$lang$XComponent;
    static /* synthetic */ Class class$com$sun$star$uno$XComponentContext;
    static /* synthetic */ Class class$com$sun$star$lang$XMultiServiceFactory;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;
    static /* synthetic */ Class class$com$sun$star$bridge$XBridgeFactory;
    static /* synthetic */ Class class$com$sun$star$loader$XImplementationLoader;
    static /* synthetic */ Class class$com$sun$star$lang$XSingleServiceFactory;
    static /* synthetic */ Class class$com$sun$star$lang$XInitialization;
    static /* synthetic */ Class class$com$sun$star$container$XSet;

    public LocalOfficeConnection() {
        this.mProgramPath = System.getProperty("com.sun.star.beans.path");
        this.mLibPath = System.getProperty("com.sun.star.beans.libpath");
    }

    public void setUnoUrl(String string) throws MalformedURLException {
        this.mURL = null;
        this.parseUnoUrl(string);
        this.mURL = string;
    }

    public void setContainerFactory(ContainerFactory containerFactory) {
        this.mContainerFactory = containerFactory;
    }

    public XComponentContext getComponentContext() {
        if (this.mComponentContext == null) {
            this.connect();
        }
        return this.mComponentContext;
    }

    public OfficeWindow createOfficeWindow(Container container) {
        return new LocalOfficeWindow(this);
    }

    public void dispose() {
        Iterator iterator = this.mComponents.iterator();
        while (iterator.hasNext()) {
            ((XEventListener)iterator.next()).disposing(null);
        }
        this.mComponents.clear();
        if (this.mBridge != null) {
            XComponent xComponent = (XComponent)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XComponent == null ? (class$com$sun$star$lang$XComponent = LocalOfficeConnection.class$("com.sun.star.lang.XComponent")) : class$com$sun$star$lang$XComponent), (Object)this.mBridge);
            xComponent.dispose();
            this.mComponentContext = null;
            this.mBridge = null;
            this.mConnection = null;
        }
    }

    public void addEventListener(XEventListener xEventListener) {
        this.mComponents.add(xEventListener);
    }

    public void removeEventListener(XEventListener xEventListener) {
        this.mComponents.remove(xEventListener);
    }

    private void connect() {
        block7: {
            try {
                this.buildBridge();
            }
            catch (com.sun.star.uno.Exception exception) {
                this.mConnection = null;
            }
            if (this.mBridge == null) {
                return;
            }
            XMultiServiceFactory xMultiServiceFactory = null;
            try {
                Object object = null;
                object = this.mBridge.getInstance("StarOffice.ComponentContext");
                this.mComponentContext = (XComponentContext)UnoRuntime.queryInterface((Class)(class$com$sun$star$uno$XComponentContext == null ? (class$com$sun$star$uno$XComponentContext = LocalOfficeConnection.class$("com.sun.star.uno.XComponentContext")) : class$com$sun$star$uno$XComponentContext), (Object)object);
                if (this.mComponentContext == null || this.mComponentContext.getServiceManager() == null) {
                    this.mComponentContext = null;
                    object = this.mBridge.getInstance("StarOffice.ServiceManager");
                    xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XMultiServiceFactory == null ? (class$com$sun$star$lang$XMultiServiceFactory = LocalOfficeConnection.class$("com.sun.star.lang.XMultiServiceFactory")) : class$com$sun$star$lang$XMultiServiceFactory), (Object)object);
                    XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = LocalOfficeConnection.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)object);
                    this.mComponentContext = (XComponentContext)AnyConverter.toObject((Type)new Type(class$com$sun$star$uno$XComponentContext == null ? (class$com$sun$star$uno$XComponentContext = LocalOfficeConnection.class$("com.sun.star.uno.XComponentContext")) : class$com$sun$star$uno$XComponentContext), (Object)xPropertySet.getPropertyValue("DefaultContext"));
                }
            }
            catch (Exception exception) {
                XComponent xComponent;
                if (this.mBridge == null) break block7;
                if (xMultiServiceFactory != null) {
                    xComponent = (XComponent)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XComponent == null ? (class$com$sun$star$lang$XComponent = LocalOfficeConnection.class$("com.sun.star.lang.XComponent")) : class$com$sun$star$lang$XComponent), xMultiServiceFactory);
                    xComponent.dispose();
                    xMultiServiceFactory = null;
                }
                xComponent = (XComponent)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XComponent == null ? (class$com$sun$star$lang$XComponent = LocalOfficeConnection.class$("com.sun.star.lang.XComponent")) : class$com$sun$star$lang$XComponent), (Object)this.mBridge);
                xComponent.dispose();
                this.mBridge = null;
                this.mComponentContext = null;
                this.mConnection = null;
            }
        }
    }

    private void buildBridge() throws com.sun.star.uno.Exception {
        if (this.mBridge != null) {
            return;
        }
        if (this.mConnection == null) {
            this.buildConnection();
        }
        Object object = this.mLocalServiceFactory.createInstance("com.sun.star.bridge.BridgeFactory");
        XBridgeFactory xBridgeFactory = (XBridgeFactory)UnoRuntime.queryInterface((Class)(class$com$sun$star$bridge$XBridgeFactory == null ? (class$com$sun$star$bridge$XBridgeFactory = LocalOfficeConnection.class$("com.sun.star.bridge.XBridgeFactory")) : class$com$sun$star$bridge$XBridgeFactory), (Object)object);
        this.mBridge = xBridgeFactory.createBridge(OFFICE_BRIDGE_NAME, OFFICE_CONN_PROT, this.mConnection, null);
    }

    private void buildConnection() throws com.sun.star.uno.Exception {
        if (this.mLocalServiceFactory == null) {
            this.buildEnvironment();
        }
        NativeConnection nativeConnection = new NativeConnection();
        nativeConnection.connect(new OfficeService());
        this.mConnection = nativeConnection;
    }

    private void buildEnvironment() throws com.sun.star.uno.Exception {
        this.loadNativeLibrary();
        Object object = new JavaLoader();
        XImplementationLoader xImplementationLoader = (XImplementationLoader)UnoRuntime.queryInterface((Class)(class$com$sun$star$loader$XImplementationLoader == null ? (class$com$sun$star$loader$XImplementationLoader = LocalOfficeConnection.class$("com.sun.star.loader.XImplementationLoader")) : class$com$sun$star$loader$XImplementationLoader), (Object)object);
        object = xImplementationLoader.activate("com.sun.star.comp.servicemanager.ServiceManager", null, null, null);
        XSingleServiceFactory xSingleServiceFactory = (XSingleServiceFactory)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XSingleServiceFactory == null ? (class$com$sun$star$lang$XSingleServiceFactory = LocalOfficeConnection.class$("com.sun.star.lang.XSingleServiceFactory")) : class$com$sun$star$lang$XSingleServiceFactory), (Object)object);
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XMultiServiceFactory == null ? (class$com$sun$star$lang$XMultiServiceFactory = LocalOfficeConnection.class$("com.sun.star.lang.XMultiServiceFactory")) : class$com$sun$star$lang$XMultiServiceFactory), (Object)xSingleServiceFactory.createInstance());
        XInitialization xInitialization = (XInitialization)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XInitialization == null ? (class$com$sun$star$lang$XInitialization = LocalOfficeConnection.class$("com.sun.star.lang.XInitialization")) : class$com$sun$star$lang$XInitialization), (Object)xImplementationLoader);
        Object[] objectArray = new Object[]{xMultiServiceFactory};
        xInitialization.initialize(objectArray);
        XSet xSet = (XSet)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XSet == null ? (class$com$sun$star$container$XSet = LocalOfficeConnection.class$("com.sun.star.container.XSet")) : class$com$sun$star$container$XSet), (Object)xMultiServiceFactory);
        XSingleServiceFactory xSingleServiceFactory2 = (XSingleServiceFactory)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XSingleServiceFactory == null ? (class$com$sun$star$lang$XSingleServiceFactory = LocalOfficeConnection.class$("com.sun.star.lang.XSingleServiceFactory")) : class$com$sun$star$lang$XSingleServiceFactory), (Object)xImplementationLoader.activate("com.sun.star.comp.loader.JavaLoader", null, null, null));
        xSet.insert((Object)xSingleServiceFactory2);
        xSet.insert((Object)xSingleServiceFactory);
        xSingleServiceFactory2 = (XSingleServiceFactory)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XSingleServiceFactory == null ? (class$com$sun$star$lang$XSingleServiceFactory = LocalOfficeConnection.class$("com.sun.star.lang.XSingleServiceFactory")) : class$com$sun$star$lang$XSingleServiceFactory), (Object)xImplementationLoader.activate("com.sun.star.comp.urlresolver.UrlResolver", null, null, null));
        xSet.insert((Object)xSingleServiceFactory2);
        xSingleServiceFactory2 = (XSingleServiceFactory)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XSingleServiceFactory == null ? (class$com$sun$star$lang$XSingleServiceFactory = LocalOfficeConnection.class$("com.sun.star.lang.XSingleServiceFactory")) : class$com$sun$star$lang$XSingleServiceFactory), (Object)xImplementationLoader.activate("com.sun.star.comp.bridgefactory.BridgeFactory", null, null, null));
        xSet.insert((Object)xSingleServiceFactory2);
        this.mLocalServiceFactory = xMultiServiceFactory;
    }

    private void loadNativeLibrary() {
        System.loadLibrary(OFFICE_LIB_NAME);
    }

    private String getProgramPath() {
        if (this.mProgramPath == null) {
            String string = null;
            String string2 = System.getProperty("os.name");
            if ("SunOS".equals(string2) || "Linux".equals(string2)) {
                string = System.getProperty("user.home");
                string = string + "/staroffice6.0";
            } else if (string2.startsWith("Windows")) {
                string = "c:\\Program Files\\StarOffice6.0\\program";
            } else {
                return null;
            }
            this.mProgramPath = new File(string).isDirectory() ? string : "";
        }
        return this.mProgramPath;
    }

    private String getLibPath() {
        if (this.mLibPath == null) {
            String string;
            String string2 = System.getProperty("file.separator");
            Class<?> clazz = this.getClass();
            String string3 = clazz.getResource(string = new String('/' + clazz.getName().replace('.', '/') + ".class")).getFile();
            int n = string3.indexOf(string2 + "classes" + string2 + OFFICE_LIB_NAME + ".jar");
            if (n > 0) {
                string3 = string3.substring(0, n);
                n = string3.indexOf(string2);
                string3 = string3.substring(n);
                string = System.getProperty("os.name");
                if ("SunOS".equals(string)) {
                    string3 = string3 + "/solsparc/lib";
                } else if ("Linux".equals(string)) {
                    string3 = string3 + "/linux/lib";
                } else if (string.startsWith("Windows")) {
                    string3 = string3 + string2 + "windows" + string2 + "bin";
                } else {
                    return null;
                }
                if (new File(string3).isDirectory()) {
                    this.mLibPath = string3;
                }
            }
        }
        return this.mLibPath;
    }

    private void parseUnoUrl(String string) throws MalformedURLException {
        String string2 = "uno:localoffice";
        if (!string.startsWith(string2)) {
            throw new MalformedURLException("Invalid UNO connection URL.");
        }
        int n = string.indexOf(";urp;StarOffice.NamingService");
        if (n < 0) {
            throw new MalformedURLException("Invalid UNO connection URL.");
        }
        String string3 = string.substring(string2.length(), n + 1);
        String string4 = null;
        String string5 = null;
        String string6 = null;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        n = 0;
        while (n < string3.length()) {
            char c = string3.charAt(n);
            block0 : switch (n2) {
                case 0: {
                    switch (c) {
                        case ',': {
                            stringBuffer.delete(0, stringBuffer.length());
                            n2 = 1;
                            break block0;
                        }
                        case ';': {
                            n2 = 7;
                            break block0;
                        }
                    }
                    stringBuffer.delete(0, stringBuffer.length());
                    stringBuffer.append(c);
                    n2 = 1;
                    break;
                }
                case 1: {
                    switch (c) {
                        case ' ': 
                        case '=': {
                            string4 = stringBuffer.toString();
                            n2 = c == ' ' ? 2 : 3;
                            break block0;
                        }
                        case ',': 
                        case ';': {
                            n2 = -6;
                            break block0;
                        }
                    }
                    stringBuffer.append(c);
                    break;
                }
                case 2: {
                    switch (c) {
                        case '=': {
                            n2 = 3;
                            break block0;
                        }
                        case ' ': {
                            break block0;
                        }
                    }
                    n2 = -1;
                    break;
                }
                case 3: {
                    switch (c) {
                        case ' ': {
                            break block0;
                        }
                    }
                    stringBuffer.delete(0, stringBuffer.length());
                    stringBuffer.append(c);
                    n2 = 4;
                    break;
                }
                case 4: {
                    switch (c) {
                        case ' ': 
                        case ',': 
                        case ';': {
                            --n;
                            n2 = 5;
                            if (string4.equals("path")) {
                                if (string5 == null) {
                                    string5 = stringBuffer.toString();
                                } else {
                                    n2 = -3;
                                }
                            } else if (string4.equals("pipe")) {
                                if (string6 == null) {
                                    string6 = stringBuffer.toString();
                                } else {
                                    n2 = -4;
                                }
                            } else {
                                n2 = -2;
                            }
                            stringBuffer.delete(0, stringBuffer.length());
                            break block0;
                        }
                    }
                    stringBuffer.append(c);
                    break;
                }
                case 5: {
                    switch (c) {
                        case ' ': {
                            break block0;
                        }
                        case ',': {
                            n2 = 6;
                            break block0;
                        }
                        case ';': {
                            n2 = 7;
                            break block0;
                        }
                    }
                    n2 = -5;
                    break;
                }
                case 6: {
                    switch (c) {
                        case ' ': {
                            break block0;
                        }
                    }
                    stringBuffer.delete(0, stringBuffer.length());
                    stringBuffer.append(c);
                    n2 = 1;
                    break;
                }
                default: {
                    throw new MalformedURLException("Invalid UNO connection URL.");
                }
            }
            ++n;
        }
        if (n2 != 7) {
            throw new MalformedURLException("Invalid UNO connection URL.");
        }
        if (string5 != null) {
            this.mProgramPath = string5;
        }
        if (string6 != null) {
            this.mPipeName = string6;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            String string = System.getProperty("os.name").startsWith("Windows") ? OFFICE_PROP_FILE : ".officebean.properties";
            File file = new File(System.getProperty("user.home"), string);
            if (file.canRead()) {
                Properties properties = new Properties();
                properties.load(new FileInputStream(file));
                Enumeration<?> enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    string = (String)enumeration.nextElement();
                    if (!string.startsWith("com.sun.star.beans.") || System.getProperty(string) != null) continue;
                    System.setProperty(string, properties.getProperty(string));
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class OfficeService
    implements NativeService {
        private Process mProcess;

        private OfficeService() {
        }

        public String getIdentifier() {
            return LocalOfficeConnection.this.mPipeName == null ? System.getProperty("user.name") + LocalOfficeConnection.OFFICE_ID_SUFFIX : LocalOfficeConnection.this.mPipeName;
        }

        public void startupService() throws IOException {
            String[] stringArray = new String[]{new File(LocalOfficeConnection.this.getProgramPath(), LocalOfficeConnection.OFFICE_APP_NAME).getPath(), "-invisible", "-accept=pipe,name=" + this.getIdentifier() + ";" + LocalOfficeConnection.OFFICE_CONN_PROT + ";StarOffice.NamingService"};
            this.mProcess = Runtime.getRuntime().exec(stringArray);
        }

        public int getStartupTime() {
            return 60;
        }
    }
}

