;TMA macro assembler
;Memory handling
; (c)1996 Sven Klose

	code segment
AllocMemErr:
	mov ax,3
	int 10h
	mov ah,9
	int 21h
	mov ax,4cffh
	int 21h

AllocMem:
	push ds,es
#if !_mdltiny
	mov ds,data
#else
	mov ds,cs
#endif
	mov fs,ds
	call defragm	;Speicher defragmentieren
	mov cl,33
	mov al,128	;Test auf 386 CPU
	shr al,cl
	jnz AllocMem2
	mov dx,ERR_no386
	jmp AllocMemErr
AllocMem4b:
	jmp AllocMem4
NoXMSb: jmp NoXMS
AllocMem2:
#if _mdltiny
	mov bx,3000h
	mov es,cs
	mov ah,4ah
	cmp b[flag_ed],2
	jmp >a1 ;jne >a1
	mov bx,3000h
a1:	int 21h
	jc AllocMem4b	;Fehler, Ende.
#endif
	db 66h
	xor bx,bx
	mov ah,48h	;Grsse des Speichers holen
	mov bx,-1
	int 21h
	cmp al,8
	jne AllocMem4b
	mov w[DOSlen],bx
	mov ah,48h
	int 21h
	jc AllocMem4b
	mov w[dossegstart],ax
	mov w[dosstart],ax
	mov w[DOSptr],ax
	add ax,w[doslen]
	mov w[dosend],ax

	mov ax,4300h	;XMS installiert ?
	int 2fh
	cmp al,80h
	jne NoXMSb
	mov ax,4310h	;Adresse fr Aufrufe holen.
	int 2fh
	mov w[XMSdriver],bx
	mov w[XMSdriver+2],es

ka:	mov ah,3	;A20 freischalten
	callf [XMSdriver]
	mov ah,8	;freien Speicher holen
	callf [XMSdriver]
	mov dx,ax	;freien Speicher reservieren
	shr dx,1	;Nur die Hlfte verwenden, Rest ist fr Segmente
	push ax
	xor eax,eax
	pop ax
	shl eax,10
	mov d[FreeXMS],eax ;freien Speicher vermerken
	mov ah,9
	callf [XMSdriver]
	mov w[XMShandle],dx
	pop es,ds
	ret			;Das war's.


NoXMS:	mov ax,3
	int 10h
	mov dx,ERR_noXMS
	mov ah,9
	int 21h
	xor ax,ax
	int 16h
	cmp al,"r"
	je mmreset
	cmp al,"R"
	je mmreset
	call Reallocmem
	mov ax,4cffh
	int 21h

mmreset:int 19h

AllocMem4:
	push ax
	mov ax,3
	int 10h
	pop ax
	jmp DOSerrorRoutine

ReallocMem:
#if !_mdltiny
	mov ds,data
#else
	mov ds,cs
#endif
	mov ah,49h	;DOS zurckholen
	mov es,w[DOSstart]
	int 21h
	jc AllocMem4

ReallocXMS:		;XMS zurckholen
	mov dx,w[XMShandle]
	mov ah,0ah	;Block freigeben
	callf [XMSdriver]

free_segments:
	mov cx,[segments]	;Segmente freigeben
	mov bx,segflags
l1:	push cx,bx
	mov dx,seg_xmshandle[bx]
	mov w seg_xmshandle[bx],0
	or dx,dx
	je >n1
	mov ah,0ah
	callf [XMSdriver]
n1:	pop bx,cx
	add bx,seg_size
	loop l1 	       ;** Momentan nur 1 Segment verfgbar
	ret

;Defragment memory
defragm:push ds
	mov ah,52h
	int 21h
	mov bx,w[es:bx-2]
	xor si,si
dfm2:	mov ds,bx
	call dfmcb
	jne dfm7
	mov dh,al
	cmp w[1],0
	jne dfm6
dfm3:	mov ax,ds
	inc ax
	add ax,cx
	mov ds,ax
	call dfmcb
	jne dfm4
	mov dh,al
	cmp w[1],0
	je dfm3
dfm4:	mov cx,ds
	sub cx,bx
	dec cx
	push ds
	mov ds,bx
	cmp cx,w[3]
	je dfm5
	inc si
	mov w[3],cx
	mov b[0],dh
dfm5:	pop bx
	jmp dfm2
dfm6:	inc cx
	add bx,cx
	jmp dfm2
dfm7:	pop ds
	ret

dfmcb:	mov al,b[0]
	cmp al,"M"
	je dfmcb2
	cmp al,"Z"
	jne dfmcb3
dfmcb2: mov cx,w[3]
dfmcb3: ret

xmscopy:push ds
#if !_mdltiny
	mov ds,data
#else
	mov ds,cs
#endif
	pushad
	mov si,xmsstruc
	mov ah,0bh
	callf [XMSdriver]
	or ax,ax
	je xmserror
	popad
	pop ds
	ret

xmserror:
#if !_mdltiny
	mov ds,data
#else
	mov ds,cs
#endif
	cld
	mov es,ds
	mov si,err_xms
l1:	lodsb
	cmp al,-1
	je >e1
	cmp al,bl
	je >f1
	xor al,al
	mov cx,-1
	mov di,si
	repne scasb
	mov si,di
	jmp l1
f1:	call asciiz
e1:	jmp break

#if !_mdltiny
_text	segment para
#endif

#if lang_english
ERR_noXMS:
	db"No XMS driver (e.g. HIMEM.SYS) found.",10,13
	db"Please install one and try again.",10,13,10
	db"'R'=Reset; [ENTER]=Continue anyway :$"
err_xms:db"XMS-Error ",0
ERR_no386:
	db"No 386-CPU detected. Time to upgrade !",10,13,"$"
ERR_nomem:
	db"Not enough memory. See documentation for details.",10,13,"$"
#endif
#if lang_german
ERR_noXMS:
	db"Es ist kein XMS-Treiber (z.B. Himem.Sys) installiert.",10,13
	db"Bitte installieren Sie einen und versuchen Sie es nochmals.",10,13,10
	db"'R'=Reset; [ENTER]=Weiter :$"
err_xms:db"XMS-Fehler ",0
ERR_no386:
	db"Keine 80386-CPU gefunden. Zeit zum aufrsten !",10,13,"$"
ERR_nomem:
	db"Zu wenig Speicher. Bitte lesen Sie im Handbuch nach.",10,13,"$"
#endif

xmserrorlist:
	db 80h,"Function not implemented",0
	db 81h,"VDISK device detected",0
	db 82h,"A20 error occured",0
	db 8Eh,"General driver error occured",0
	db 8Fh,"Unrecoverable driver error occured",0
	db 90h,"HMA does not exist",0
	db 91h,"HMA already in use",0
	db 92h,"DX is less than the /HMAMIN= parameter",0
	db 93h,"HMA is not allocated",0
	db 94h,"A20 line is still enabled",0
	db 0A0h,"All extended memory is allocated",0
	db 0A1h,"All available extended memory handles are in use",0
	db 0A2h,"Handle is invalid",0
	db 0A3h,"SourceHandle is invalid",0
	db 0A4h,"SourceOffset is invalid",0
	db 0A5h,"DestHandle is invalid",0
	db 0A6h,"DestOffset is invalid",0
	db 0A7h,"Length is invalid",0
	db 0A8h,"Move has an invalid overlap",0
	db 0A9h,"Parity error occured",0
	db 0AAh,"Block is not locked",0
	db 0ABh,"Block is locked",0
	db 0ACh,"Block's lock count overflowed",0
	db 0ADh,"Lock failed",0
	db 0B0h,"Smaller UMB is available",0
	db 0B1h,"No UMBs are available",0
	db 0B2h,"UMB segment number is invalid",0
	db -1

einfotab:
	db"Register information",0
	db"EAX:",0," EBX:",0," ECX:",0," EDX:",0
	db 10,13," ESI:",0," EDI:",0
	db 10,13,"CS:",0," DS:",0," ES:",0," FS:",0," GS:",0
	db 10,13,"SS:",0," SP:",0," IP:",0," Flags:",0
	db 10,13,"Stack:",10,13,0

	.data
;[xmscopy]
xmsstruc:
xmscopylen	dd ?
xmshandle2	dw ?
xmssource	dd ?
xmshandle3	dw ?
xmsdest 	dd ?
		;
XMSsize:	dd ?
xmsptr: 	dd ?		 ;Pointer to free memory in XMS
FreeXMS:	dd ?
XMShandle:	dw ?
dossegstart:	dw ?
dosptr: 	dw ?
dosend: 	dw ?
doslen: 	dw ?
dosstart:	dw ?
;DOSsize:	dd ?
XMSdriver	dd ?

