/* gWatch.c - main module of the Gator Watcher utility
//  This program is intended as a host-side utility to allow the host to
//  make a list of the Gators in a game, their position, etc. It is
//  distributed as an example program for host-side utilities and add-ons,
//  which can be made with the
//            RLSystems VGA Planets Software Development Kit
*/
/*
//  RLSystems Gator Watcher V1.00F - a VGA Planets host-side utility
//  Copyright (C) 2000  Dlanor Blytkerchan
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/*****************************************************************Includes*/
#include "gWatch.h"
#include "engine.h"
#include <stdio.h>
/******************************************************************Dummies*/
void dummy(void) { // see comment 1
  flength(0);
} // dummy()
/******************************************************************Globals*/
bool rc = true;
char *gamePath,
#ifndef debugging
     *basePath,
#else
     *basePath = "z:/planets.32/",
#endif
      logFileName[260];
/*********************************************************************Main*/
int main(int argc, char **argv) {
  int i;

  // let's say hello first..
  printf("%s %s\nby: %s\nCompiled: %s %s\n", gWatch_program, gWatch_version, gWatch_author, __DATE__, __TIME__);
  // fire up Swing
  if (rc) rc = initSwing();
  // get some info on how we're running
#ifndef debugging
  if (rc) rc = ((basePath = (char*)malloc(strlen(argv[0]) + 1)) != NULL);
  if (rc) rc = (strcpy(basePath, argv[0]) != NULL);
  for (i = 0; basePath[i]; i++) if (basePath[i] == '\\') basePath[i] = '/'; // redundant, but just in case this code is ever used in another compiler..
  for (i = strlen(basePath) - 1; (basePath[i] != '/') && (i > 0); i--) basePath[i] = 0;
#endif
  if (argc == 1) {
    if (rc) rc = ((gamePath = (char*)malloc(strlen(basePath) + 1)) != NULL);
    if (rc) rc = (strcpy(gamePath, basePath) != NULL);
  } else {
    if (rc) rc = ((gamePath = (char*)malloc(strlen(argv[1]) + 2)) != NULL);
    if (rc) rc = (strcpy(gamePath, argv[1]) != NULL);
    for (i = 0; gamePath[i]; i++) if (gamePath[i] == '\\') gamePath[i] = '/';
    if (rc && (gamePath[strlen(gamePath) - 1] != '/')) rc = (strcat(gamePath, "/") != NULL);
  } // if
  // and fire up the VGAP I/O library
  if (rc) rc = initVPL3(USE_SHIPS, gamePath, basePath, &numberOfShips, 0);
  // now open the log file
  if (rc) rc = (strcpy(logFileName, gamePath) != NULL);
  if (rc) rc = (strcat(logFileName, "GWATCH.LOG") != NULL);
  if (rc) rc = openLogFile(logFileName, true);
  // now fire up the engine
  if (rc) rc = runGWatch();
  // close the log file
  if (rc) rc = closeLogFile();

  if (rc) {
    return(0);
  } else done(errCode);
} // main()
/*****************************************************************Comments**
// 1. As described in the libvgap.doc documentation file, the VPL3 library
//    uses the flength() method from the Swing library, but the linker won't
//    understand that unless I make a specific call to that method from the
//    program itself. Whether or not the dummy in which I do that is
//    actually called in the program doesn't matter.
***************************************************************************/

