/* messages.h
// header file for messages.c. Holds all message-specific definitions.
*/
#if !defined(__SPY3__) && !defined(__ENH2__) && !defined(__GTR3__) && !defined(__VPL3__) && !defined(VPL3) && !defined(__FLN1__)
#error This header was not intended for use by non-RLSystems software!
#endif
#ifndef VPL3_MESSAGES_H
#define VPL3_MESSAGES_H
/*****************************************************************Includes*/
#include <vpl3/gators.h>
#include <vpl3/gtr3Structures.h>
#include <vpl3/globalVGAPInfo.h>
#include <vpl3/rlssbenh.h>
#include <vpl3/gtr3FileDispatchers.h>
/******************************************************************Defines*/
// message types
// 0x0000 thru 0x000F : generic/general messages
/*=******************************************************Gators version 3=*/
#define msg_config                                 0x0000 // configuration message
#define msg_reminder                               0x0001 // reminder that Gators is here
#define msg_gatorExploded                          0x0002 // Gator exploding - general message
#define msg_miniGateExploded                       0x0003 // MiniGate exploding - general message
#define msg_gatorDestroyed                         0x0004 // Gator exploding - owner message
#define msg_miniGateDestroyed                      0x0005 // MiniGate exploding - owner message
#define msg_shipUFOMumbles                         0x0006 // ShipUFO randting to it's former owner
#define msg_issueGatorInfo                         0x0007 // General Gator info for the owner
#define msg_issueMiniGateInfo                      0x0008 // General MiniGate info for the owner
#define msg_issueGTR3Info                          0x0009 // Encoded record for player-side add-on
// 0x0010 thru 0x00FF : ship messages
#define msg_towedMiniGate                          0x0010 // MiniGate towed by a ship
#define msg_towedGator                             0x0011 // Gator towed by a ship
#define msg_shipAttacksGator                       0x0012 // Gator attacked by ship
#define msg_shipAttacksMiniGate                    0x0013 // MiniGate attacked by ship
#define msg_shipAttackingGator                     0x0014 // Gator attacked by ship
#define msg_shipAttackingMiniGate                  0x0015 // MiniGate attacked by ship
#define msg_shipExploded                           0x0016 // Ship exploding - general message
#define msg_shipDestroyed                          0x0017 // Ship exploding - owner message
#define msg_couldNotBuildGator_lackResources       0x0018 // Ship could not build Gators due to lack of resources
#define msg_couldNotBuildMiniGate_lackResources    0x0019 // Ship could not build Gators due to lack of resources
#define msg_couldNotBuildGator_slotsFull           0x001A // Ship could not build Gators - all Gator slots were full
#define msg_couldNotBuildMiniGate_slotsFull        0x001B // Ship could not build Gators - all Gator slots were full
#define msg_gatorBuilt                             0x001C // Ship built a Gator
#define msg_miniGateBuilt                          0x001D // Ship built a MiniGate
#define msg_notRepaired_noDamagedGatorOrMiniGate   0x001E // Ship could not repair a Gator or MiniGate because no damaged Gators or MiniGates were present
#define msg_notRepaired_gator_lackSupplies         0x001F // Ship could not repair a Gator because it didn't have the resources
#define msg_notRepaired_miniGate_lackSupplies      0x0020 // Ship could not repair a MiniGate because it didn't have the resources
#define msg_repairedGator                          0x0021 // Ship repaired a Gator
#define msg_repairedMiniGate                       0x0022 // Ship repaired a MiniGate
#define msg_gatorRepaired                          0x0023 // Gator was repaired
#define msg_miniGateRepaired                       0x0024 // MiniGate was repaired
#define msg_couldNotUpgradeMiniGate_lackResources  0x0025 // Ship could not upgrade a MiniGate due to lack of resources
#define msg_couldNotUpgradeMiniGate_nonePresent    0x0026 // Ship could not upgrade a MiniGate - none present
#define msg_couldNotUpgradeMiniGate_isDamaged      0x0027 // Ship could not upgrade a MiniGate - it is damaged
#define msg_upgradedMiniGate                       0x0028 // Ship upgraded a MiniGate to a Gator
#define msg_miniGateUpgraded                       0x0029 // MiniGates was upgraded to a Gator
#define msg_couldNotArmGator_lackResources         0x002A // Ship could not arm a Gator due to lack of resources
#define msg_couldNotArmGator_nonePresent           0x002B // Ship could not arm a Gator - no unarmed Gators present
#define msg_couldNotArmGator_isDamaged             0x002C // Ship could not arm a Gator - it is damaged
#define msg_armedGator                             0x002D // Ship armed a Gator
#define msg_gatorArmed                             0x002E // Gator was armed
#define msg_gatorStolen                            0x002F // Gator was stolen
#define msg_miniGateStolen                         0x0030 // MiniGate was stolen
#define msg_stoleGator                             0x0031 // Ship stole a Gator
#define msg_stoleMiniGate                          0x0032 // Ship stole a MiniGate
#define msg_scannedGator_300_thru_150              0x0033 // Ship scanned a Gator at 300 to 150 LY
#define msg_scannedMiniGate_300_thru_150           0x0034 // Ship scanned a MiniGate at 300 to 150 LY
#define msg_scannedGator_150_thru_25               0x0035 // Ship scanned a Gator at 150 to 25 LY
#define msg_scannedMiniGate_150_thru_25            0x0036 // Ship scanned a MiniGate at 150 to 25 LY
#define msg_scannedGator_25_thru_10                0x0037 // Ship scanned a Gator at 25 to 10 LY
#define msg_scannedMiniGate_25_thru_10             0x0038 // Ship scanned a MiniGate at 25 to 10 LY
#define msg_scannedGator_10_thru_0_noFCode         0x0039 // Ship scanned a Gator at 10 to 0 LY
#define msg_scannedMiniGate_10_thru_0_noFCode      0x003A // Ship scanned a MiniGate at 10 to 0 LY
#define msg_scannedGator_10_thru_0_withFCode       0x003B // Ship scanned a Gator at 10 to 0 LY and hacked the fCode
#define msg_scannedMiniGate_10_thru_0_withFCode    0x003C // Ship scanned a MiniGate at 10 to 0 LY and hacked the fCode
#define msg_gatorScanned_300_thru_150              0x003D // Ship scanned a Gator at 300 to 150 LY
#define msg_miniGateScanned_300_thru_150           0x003E // Ship scanned a MiniGate at 300 to 150 LY
#define msg_gatorScanned_150_thru_25               0x003F // Ship scanned a Gator at 150 to 25 LY
#define msg_miniGateScanned_150_thru_25            0x0040 // MiniGate was scanned at 150 to 25 LY
#define msg_gatorScanned_25_thru_10                0x0041 // Gator was scanned at 25 to 10 LY
#define msg_miniGateScanned_25_thru_10             0x0042 // MiniGate was scanned at 25 to 10 LY
#define msg_gatorScanned_10_thru_0_noFCode         0x0043 // Gator was scanned at 10 to 0 LY
#define msg_miniGateScanned_10_thru_0_noFCode      0x0044 // MiniGate was scanned at 10 to 0 LY
#define msg_gatorScanned_10_thru_0_withFCode       0x0045 // Gator was scanned at 10 to 0 LY and hacked the fCode
#define msg_miniGateScanned_10_thru_0_withFCode    0x0046 // MiniGate was scanned at 10 to 0 LY and hacked the fCode
#define msg_gatorRandomized                        0x0047 // Ship randomized a Gator ID & fCode
#define msg_miniGateRandomized                     0x0048 // Ship randomized a MiniGate ID & fCode
#define msg_miniGateNotSwitched_lackResources      0x0049 // Ship could not switch a MiniGate's mdoe - none present
#define msg_miniGateNotSwitched_nonePresent        0x004A // Ship could not switch a MiniGate's mdoe - none present
#define msg_miniGateSwitched                       0x004B // Ship switched a Minigate's mode
#define msg_notJumped_notFound                     0x004C // Ship could not jump - there was no Gator/MiniGate present
#define msg_notJumped_noDest                       0x004D // Ship could not jump - there was no Gator/MiniGate to jump to
#define msg_jumped                                 0x004E // Ship jumped though a Gator/MiniGate
#define msg_dragged                                0x004F // Ship was dragged through a Gator/MiniGate
#define msg_shipArrivedGator                       0x0050 // An alien ship has arrived at a Gator
#define msg_shipArrivedMiniGate                    0x0051 // An alien ship has arrived at a MiniGate
#define msg_shipUFOAttacksShip                     0x0052 // A warped ship is attacking a normal ship
#define msg_shipUFOAttacksPlanet                   0x0053 // A warped ship is attacking a planet
#define msg_shipUFOAttacksStarbase                 0x0054 // A warped ship is attacking a starbase
#define msg_shipArrivedFromSubspace                0x0055 // A linked ship has arrived
#define msg_shipStaffedGator                       0x0056 // Ship manned (staffed) a Gator
#define msg_shipLoadFuelOntoGator                  0x0057 // Ship loaded fuel onto Gator
#define msg_shipUnloadFuelFromGator                0x0058 // Ship unloaded fuel from Gator
// 0x0100 thru 0x017F : Starbase messages
#define msg_starbaseBuildGatorFailed_doubleBuild   0x0100 // Starbase was already building a ship - couldn't build a deployable Gator
#define msg_starbaseBuildGatorFailed_lackResources 0x0101 // Starbase doesn't have the resources to build a deployable Gator
#define msg_starbaseBuildGatorFailed_slotsFull     0x0102 // Starbase couldn't build a deployable Gator because all ship slots are full
#define msg_starbaseGatorBuilt                     0x0103 // Starbase built a deployable Gator
// 0x0180 thru 0x0200 : deployable Gator messages
#define msg_gatorDeployed                          0x0180 // Gator Deployed
#define msg_gatorNotDeployed_noFuel                0x0181 // Gator not deployed - too little fuel
#define msg_gatorNotFolded_noSlots                 0x0182 // Gator was not folded - all ship slots are full.
#define msg_gatorNotFolded_noFuel                  0x0183 // Gator not folded - too little fuel
#define msg_gatorNotFolded_noCrew                  0x0184 // Gator not folded - no crew aboard
#define msg_gatorFolded                            0x0185 // Gator folded
/*=====================================================Enhancer version 2=*/
#define msg_loadedComponents                       0x1001 // loaded components
#define msg_towingStarbase                         0x1002 // started towing components
#define msg_handedStarbase                         0x1003 // handed a starbase through a Gator
#define msg_receivedStarbase                       0x1004 // received a starbase through a Gator
#define msg_starbaseExploded                       0x1005 // starbase the ship was towing exploded
#define msg_shipExplosion                          0x1006 // distress call and explosion
#define msg_starbaseLost                           0x1007 // lost starbase in tow
#define msg_componentLost                          0x1008 // lost a component in tow
#define msg_builtMiniBase                          0x1009 // built a minibase
#define msg_moneyTransferred                       0x100A // message about the total amount of money transferred
#define msg_resourcesSent                          0x100B // resources sent by ship
#define msg_resourcesReceived                      0x100C // resources received by planet
#define msg_handedComponents                       0x100D // components handed through Gator/MiniGate
#define msg_receivedComponents                     0x100E // components handed through Gator/MiniGate received
#define msg_resourcesReceivedByShip                0x100F // resources received by ship
#define msg_refueledShip                           0x1010 // refueled a distant ship
#define msg_unloadedShip                           0x1011 // unloaded a distant ship
#define msg_rearmedShip                            0x1012 // rearmed a distance ship
#define msg_fCodeRandomized                        0x1013 // ships friendly code randomized - cloning cancelled
#define msg_buildingCancelled                      0x1014 // starbase cancelled building
#define msg_alienShipBuilt                         0x1015 // alien ship build at starbase
#define msg_shipRepaired                           0x1016 // distant ship repaired
#define msg_hullArrived                            0x1017 // hull arrived
#define msg_engineArrived                          0x1018 // engine arrived
#define msg_beamWeaponArrived                      0x1019 // beam weapon arrived
#define msg_torpedoTubeArrived                     0x1020 // torpedo tube arrived
#define msg_driftingStarbaseCrashed                0x1021 // drifting starbase crashed into an exiting one
#define msg_starbaseInOrbit                        0x1022 // drifting starabse pulled into orbit by gravity well
/*============================================Trampoline Device version 2=*/
#define msg_trampolineDeviceBuilt                  0x2000 // Gator being scanned at < 300 but > 150 LY
#define msg_shipDestroyedByTrampolineS             0x2001 // ship destroyed in battle against Trampoline Device
#define msg_tplShipExploded                        0x2002 // Distress call from an exploding ship
#define msg_shipDestroyedByTrampolineT             0x2003 // Trampoline Device saying it has destroyed an enemy ship
#define msg_trampolineDestroyedByShip              0x2004 // Ship saying it has destroyed a Trampoline Device
#define msg_trampolineBoom                         0x2005 // Trampoline Device saying it has been destroyed by a ship
#define msg_shipAttackedTrampoline                 0x2006 // ship saying it has attacked a Trampoline Device
#define msg_trampolineAttackedByShip               0x2007 // Trampoline Device saying it has been attacked by a ship
#define msg_tplCloakInstalled                      0x2008 // Cloaking device installed
#define msg_tplFortifiedRiot                       0x2009 // Trampoline Device has been fortified - riot protection
#define msg_tplFortifiedDamage                     0x200A // Trampoline Device has been fortified - damage & alteration protection
#define msg_tplExtraction                          0x200B // Extraction unit installed
#define msg_tplExtractionUpgrade                   0x200C // Extraction unit upgraded
/*===============================================Freelan People Add-on V1=*/
#define msg_firstContact                           0x3000 // First contact message from the Freelan people
/**********************************************structural type definitions*/
typedef struct _messageDataType {
  short  recipient;         // ID# of the recipient race
  short  kind;              // The kind of message being sent
  short  ID;                // The ID of whatever is sending the message
  short  xCoord;            // The xCoord of whatever the subject is
  short  yCoord;            // The yCoord of whatever the subject is
  short  oldXCoord;         // The old xCoord of whatever the subject is
  short  oldYCoord;         // The old yCoord of whatever the subject is
  char   name[21];          // Storage place for a name
  char   name2[21];         // Storage place for a name
  char   longName[31];      // Storage place for a long race name
  char   pluralName[21];    // Storage place for a plural race name
  char   adjectiveName[13]; // Storage place for an adjective race name
  char   fCode[4];          // Storage place for a friendly code. fCode[3] should be set to 0
  short  ID2, ID3, ID4;     // Storage place for an additional ID#
  short  neutronium;        // Storage place for a neutronium amount
  short  tritanium;         // Storage place for a tritanium amount
  short  duranium;          // Storage place for a duranium amount
  short  molybdenum;        // Storage place for a molybdenum amount
  short  colonists;         // Storage place for an amount of colonist clans
  short  supplies;          // Storage place for an amount of supplies
  long   megaCredits;       // Storage place for an amount of money
  short  damage;            // Storage place for an amount of damage (%)
  short  crew;
  char   tString[3];        // type string ("s0", "x0", "p0", etc.)
  bool   isReceiving;
  bool   isArmed;
  bool   isProtected;
  bool   isFoldable;
  bool   isFolded;
  long   distance;
  short  trampolineType;    // type of device being referred to
  void   *data;
  long   size;
} messageDataType;

typedef struct _messagePointerType {
  short ID;
  short recipient;
  short sender;
  long  offsetInFile;
  short lengthOfMessage;
} messagePointerType;
/*********************************************************Subspace Methods*/
void setMessage(short messageType, messageDataType *message, shipRecordType *ship, planetRecordType *planet, starbaseRecordType *starbase, raceRecordType *race, gatorType *gator);
bool getMessagePointer(messagePointerType *ptr, short record);
bool putMessage(short cc, char xzstr[], short ID, char gG[]);
bool issueMessage(messageDataType *message) __attribute__((weak));
// bool issueMessage(messageDataType *message) __attribute__((weak, alias("_issueMessage")));
/**************************************************************************/
#endif // VPL3_MESSAGES_H

