/* filters.h - header to filters.c
// Normally, you will not need to include this file in your own program or
// make any calls to the methods in this header. (In fact: you won't be able
// to include this header!
*/
#if !defined(VPL3) && !defined(__VPL3__)
#error This header is internal to the VGA Planets I/O library V3 and should not be used by other software!
#endif
#ifndef VPL3_FILTERS_H
#define VPL3_FILTERS_H
/*****************************************************************Includes*/
#include <vpl3.h>
#include <vgap.h>
/************************************************VGAP3 buffer/data filters*/
/*====================================================planet data filters=*/
bool planetXY2buffer(void *buffer, planetXYType *planetXY);
bool buffer2planetXY(planetXYType *planetXY, void *buffer);
bool planet2buffer(void *buffer, planetType *planet);
bool buffer2planet(planetType *planet, void *buffer);
/*======================================================ship data filters=*/
bool buffer2ship(shipType *ship, void *buffer);
bool ship2buffer(void *buffer, shipType *ship);
bool shipXY2buffer(void *buffer, shipXYType *shipXY);
bool buffer2shipXY(shipXYType *shipXY, void *buffer);
/*==================================================starbase data filters=*/
bool base2buffer(void *buffer, baseType *base);
bool buffer2base(baseType *base, void *buffer);
/*====================================================config data filters=*/
bool raceName2buffer(void *buffer, raceNameType *raceNames);
bool buffer2raceName(raceNameType *raceNames, void *buffer);
bool hullSpec2buffer(void *buffer, hullSpecType *hullSpec);
bool buffer2hullSpec(hullSpecType *hullSpec, void *buffer);
bool engineSpec2buffer(void *buffer, engineSpecType *engineSpec);
bool buffer2engineSpec(engineSpecType *engineSpec, void *buffer);
bool beamSpec2buffer(void *buffer, beamSpecType *beamSpec);
bool buffer2beamSpec(beamSpecType *beamSpec, void *buffer);
bool torpSpec2buffer(void *buffer, torpSpecType *torpSpec);
bool buffer2torpSpec(torpSpecType *torpSpec, void *buffer);
bool hConfig2buffer(void *buffer, hConfigType *hConfig);
bool buffer2hConfig(hConfigType *hConfig, void *buffer);
/*==============================================miscelanious data filters=*/
bool VCR2buffer(void *buffer, VCRType *VCR);
bool buffer2VCR(VCRType *VCR, void *buffer);
bool mine2buffer(void *buffer, mineType *mine);
bool buffer2mine(mineType *mine, void *buffer);
bool UFO2buffer(void *buffer, UFOType *UFO);
bool buffer2UFO(UFOType *UFO, void *buffer);
bool ion2buffer(void *buffer, ionType *ion);
bool buffer2ion(ionType *ion, void *buffer);
bool alliance2buffer(void *buffer, allianceType *alliance);
bool buffer2alliance(allianceType *alliance, void *buffer);
/*********************************************************<vpl3.h> filters*/
bool UFORecord2UFO(UFOType *UFO, UFORecordType *UFORecord);
bool UFO2UFORecord(UFORecordType *UFORecord, UFOType *UFO);
bool ion2ionstormRecord(ionstormRecordType *ionstormRecord, ionType *ion);
bool ionstormRecord2ion(ionType *ion, ionstormRecordType *ionstormRecord);
bool base2starbaseRecord(starbaseRecordType *starbaseRecord, baseType *base);
bool starbaseRecord2base(baseType *base, starbaseRecordType *starbaseRecord);
/**************************************************************************/
#endif // VPL3_FILTERS_H
