/* dateAndTime.h - date and time methods for the Swing library
*/
#ifndef LSW1_DATE_AND_TIME_H
#define LSW1_DATE_AND_TIME_H
/*********************************************************Type definitions*/
typedef enum {
  _sunday_,
  _monday_,
  _tuesday_,
  _wednesday_,
  _thursday_,
  _friday_,
  _saturday_
} dayType;
/*******************************************************************Macros*/
// date validation macros - see comment 1
#define isLeap(Y) ((((Y) % 100) == 0) ? ((Y % 400) == 0) : ((Y % 4) == 0))
#define daysInYear(Y) (365 + isLeap(Y))
#define daysInMonth(M, Y) (((M) < 8) ? (((M) == 2) ? (28 + isLeap(Y)) :    \
                                       (((M) % 2) ? (31) : (30))) :        \
                          (((M) % 2) ? (30) : (31)))
#define isValidYear(Y) ((Y) > 0)
#define isValidMonth(M) (((M) >= 1) && ((M) <= 12))
#define isValidDay(D, M, Y) (((D) >= 1) && ((D) <= daysInMonth((M),(Y))))
#define isValidDate(D, M, Y) (isValidDay((D), (M), (Y)) && isValidMonth(M) && isValidYear(Y))
/****************************************************Date and time methods*/
void numToDate(int N, int *D, int *M, int *Y);
int dateToNum(int D, int M, int Y);
dayType numToDay(int n);
dayType dateToDay(int D, int M, int Y);
long timeToNum(int H, int M, int S);
bool isValidTime(int H, int M, int S);
void numToTime(int N, int *H, int *M, int *S);
long currentTimeNum(void);
void currentTime(int *H, int *M, int *S);
/*****************************************************************Comments**
// 1. Since the beginning of the modern calendar, we have had twelve months
//    per year, each moth having 31 (Jan, Mar, May, Jul, Aug, Oct, Dec), 30
//    (Apr, Jun, Sep, Nov) or 28 days (Feb). Once every four years, there's
//    a day to spare. Once every 100 years, that extra day is not there.
//    Once every 400 years, it is.
***************************************************************************/
#endif // LSW1_DATE_AND_TIME_H
