/* --------------------------------------------------------------------------
   Project S.W.O.R.D
   V2.10

   SubSystem : Samples programs : Mandelbrot fractal
   File      : Samples/Mandel/Mandel.CC
   Author    : Eric NICOLAS, Cedric JOULAIN
   Overview  : Mandel sample program main file
   UpDate    : Apr 14, 1996

** Copyright (C) 1993-1996 Eric NICOLAS
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** ------------------------------------------------------------------------*/

#include "Sword.h"
#include "ToolBox/Image/Image.h"
#include "ManView.h"

#ifdef __TURBOC__
  #error This demo program will not work with TurboC because of memory limitations
#endif

// Commands

#define cmNewViewer 	     10000
#define cmParameters      10001

// Structs

// ==== APPLICATION OBJECT ==================================================

// This object is the application object.

class TMandelApp : public TApp
{ DECLARE(TMandelApp);
  DECLARE_EVENTS_TABLE;
  // --- Datas
  protected:
  // --- Functions
  public:
  // Public constructors
          TMandelApp(void);
          TMandelApp(char *argv0);
  // Construction / Destruction
          void Init(char *argv0);
  // Overridables
  virtual void    CreateMenuChoices(TMenu *Menu);
  virtual boolean CanClose(void);
  // Events handling
          boolean doNewViewer(void);
          boolean doParameters(void);
};

DEFINE(TMandelApp)

DEFINE_EVENTS_TABLE(TMandelApp,TApp)
  COMMAND(cmNewViewer,doNewViewer)
  COMMAND(cmParameters,doParameters)
END_EVENTS_TABLE

TMandelApp::TMandelApp(void)
{ Defaults();
}

TMandelApp::TMandelApp(char *argv0)
{ Defaults();
  Init(argv0);
}

void TMandelApp::Init(char *argv0)
{ // Herited constructions
  TApp::Init(argv0);
  // Register new objects
  RegisterObject(new TMandelScroller(),&RegTMandelScroller);
  RegisterObject(new TMandelImage(),   &RegTMandelImage);
  RegisterObject(new TMandelViewer(),  &RegTMandelViewer);
}

void TMandelApp::CreateMenuChoices(TMenu *Menu)
{ Menu->Insert(new TMenuChoice("&New viewer",ScanAltN,cmNewViewer));
  Menu->Insert(new TMenuChoice("&Parameters...",ScanAltP,cmParameters));
  Menu->Insert(new TMenuChoice());
  Menu->Insert(new TMenuChoice("&Quit",ScanAltQ,cmQuit));
}

boolean TMandelApp::doNewViewer(void)
{ TMandelImage *Image=new TMandelImage(400,400);
  Desktop->Insert(new TMandelViewer(100,100,400,400,Image));
  return TRUE;
}

boolean TMandelApp::doParameters(void)
{ MessageBox("Sorry !","Nothing is implemented for this menu entry",
             "This is only a sample program...",mbOK);
  return TRUE;
}

boolean TMandelApp::CanClose(void)
{ if (MessageBox("Confirmation","Are you sure that you want to quit",
					  "Mandelbrot fractal viewer program from SWORD package ?",
					  mbYes | mbNo)==cmYes) return TRUE;
  else return FALSE;
}

// ==== MAIN PROGRAMM ========================================================

int main(char , char *argv[])
{ TMandelApp *MyDialogApp;

  // Application identification
  ShortVersion="Mandelbrot";
  LongVersion ="Mandelbrot Sample. Copyright (C) 1993-1996 The SWORD Group";

  // Execute Application
  MyDialogApp=new TMandelApp(argv[0]);
  MyDialogApp->Run();
  delete MyDialogApp;

  return 0;
}