/* --------------------------------------------------------------------------
	Project S.W.O.R.D
	V2.10

	SubSystem : Little usefull graphical objects
	File      : Include/Gadgets/Box.H
	Author    : Eric NICOLAS
	Overview  : TGroupBox, TItemBox, TCheckBox, TRadioBox : Common controls
	UpDate    : Apr 08, 1996

** Copyright (C) 1993-1996 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** ------------------------------------------------------------------------*/

#ifndef _GADGETS_BOX_H_
#define _GADGETS_BOX_H_

class TGroupBox;
class TItemBox;
class TCheckBox;
class TRadioBox;

// ----- TGroupBox

extern short RegTGroupBox;
extern char *IdentTGroupBox;

class TGroupBox : public TZone
{ DECLARE(TGroupBox);
  // -- Datas
  protected:
    char *Text;
  public:
    int  Value;
  // -- Functions
  public:
  // Public constructors
          TGroupBox(void);
          TGroupBox(int X, int Y, int L, int H, char *_Text=NULL);
          TGroupBox(TRect R, char *_Text=NULL);
  // Creation / Destruction
          void     Defaults(void);
          void     Init(int X, int Y, int L, int H, char *_Text);
          void     Done(void);
  // Graphics
  virtual void     Draw(TRect Clip);
  // Data exchange
  virtual long     DataSize(void);
  virtual void     SetData(void *Rec);
  virtual void     GetData(void *Rec);
  // Objects streams
  virtual void     Read(TDisk *file);
  virtual void     Write(TDisk *file);
};

// ----- TItemBox

extern short RegTItemBox;
extern char *IdentTItemBox;

class TItemBox : public TButton
{ DECLARE(TItemBox);
  DECLARE_EVENTS_TABLE;
  // --- Datas
  protected:
    char *Text;
  // --- Functions
  public:
  // Public constructors
          TItemBox(void);
          TItemBox(int X, int Y, int L, int _Options, char *_Text);
          TItemBox(TRect R, int _Options, char *_Text);
  // Creation / Destruction
          void     Defaults(void);
          void     Init(int X, int Y, int L, int _Options, char *_Text);
          void     Done(void);
  // Events
          boolean   KeyDown(int ScanCode, int Toggle);
  // Graphics
  virtual void      DrawSelect(int Depl);
  virtual void      Draw(TRect Rect);
  // Linked lists
         TGroupBox* Father(void);
  // Objects streams
  virtual void     Read(TDisk *file);
  virtual void     Write(TDisk *file);
};

// ----- TCheckBox

extern short RegTCheckBox;
extern char *IdentTCheckBox;

class TCheckBox : public TItemBox
{ DECLARE(TCheckBox);
  // --- Datas
  protected:
    int        Mask;
    TSysIcone *Check;
  // --- Functions
  public:
  // Public constructors
          TCheckBox(void);
          TCheckBox(int X, int Y, int L, int _Options, int _Mask, char *_Text);
  // Creation / Destruction
          void     Defaults(void);
          void     Init(int X, int Y, int L, int _Options, int _Mask, char *_Text);
          void     Done(void);
  // Graphics
  virtual void     DrawInside(int D);
  // Action
  virtual void     Action(void);
  // Objects streams
  virtual void     Read(TDisk *file);
  virtual void     Write(TDisk *file);
};

// ----- TRadioBox

extern short RegTRadioBox;
extern char *IdentTRadioBox;

class TRadioBox : public TItemBox
{ DECLARE(TRadioBox);
  // --- Datas
  protected:
    int     Value;
    TSysIcone *I1,*I2,*I3;
  // --- Functions
  public:
  // Public constructors
          TRadioBox(void);
          TRadioBox(int X, int Y, int L, int _Options, int _Value, char *_Text);
  // Construction / Destruction
          void     Defaults(void);
          void     Init(int X, int Y, int L, int _Options, int _Value, char *_Text);
          void     Done(void);
  // Graphics
  virtual int      DrawFrame(void);
  virtual void     DrawInside(int D);
  // Linked lists
        TRadioBox *First();
        TRadioBox *Next();
  // Action
  virtual void     Action(void);
  // Objects streams
  virtual void     Read(TDisk *file);
  virtual void     Write(TDisk *file);
};

// Inline functions

inline TGroupBox* TItemBox::Father(void)
{ return (TGroupBox*)(TButton::Father());
}

inline TRadioBox* TRadioBox::First()
{ return (TRadioBox*)(TItemBox::First());
}

inline TRadioBox* TRadioBox::Next()
{ return (TRadioBox*)(TItemBox::Next());
}

#endif // _GADGETS_BOX_H_

/* --------------------------------------------------------------------------
** HISTORY
** --------------------------------------------------------------------------
** 2.10:
**   21/02/96 :EN: First History remark. Copying code V2.00->V2.10
**   29/02/96 :EN: Moving from struct to class. New Defaults() method.
**   03/03/96 :EN: Changing color scheme so that it can be user-modified
**   08/04/96 :EN: Adding DECLARE_EVENTS_TABLE... macros
** ------------------------------------------------------------------------*/
