// Associated include file : Tools\MsgBox.H

#include "common/common.h"
#include "drivers/drivers.h"
#include "mecanism/mecanism.h"
#include "graphics/graphics.h"
#include "gadgets/gadgets.h"
#include "tools/msgbox.h"

long MessageBox(char *Title, char *Msg1, char *Msg2, int Options)
{ TDialog *Dialog;
  int      ButtonLength, NButtons;
  int      TextLength1,TextLength2;
  int      L,H,X,Y;
  long     Result;
  // Compute the length of the buttons line
  ButtonLength=0;
  NButtons=0;
  if (Options & mbOK)     { ButtonLength+=80; NButtons++; }
  if (Options & mbCancel) { ButtonLength+=80; NButtons++; }
  if (Options & mbYes)    { ButtonLength+=80; NButtons++; }
  if (Options & mbNo)     { ButtonLength+=80; NButtons++; }
  ButtonLength+=(NButtons-1)*5;
  // Compute the length of the text line
  TextLength1=FontSystem->WidthStr(Msg1);
  TextLength2=FontSystem->WidthStr(Msg2);
  // Create the dialog
  if (ButtonLength>TextLength1) L=ButtonLength; else L=TextLength1;
  if (L<TextLength2) L=TextLength2;
  L+=20;
  H=109;
  X=(GrMaxX()-L)/2;
  Y=(GrMaxY()-H)/2;
  Dialog=new TDialog(X,Y,L,H,Title);
  X=(L-TextLength1)/2;  Dialog->Insert(new TStaticText(X,30,TextLength1,18,Msg1));
  X=(L-TextLength2)/2;  Dialog->Insert(new TStaticText(X,53,TextLength2,18,Msg2));
  X=(L-ButtonLength)/2;
  if (Options & mbYes)
  { Dialog->Insert(new TYesButton(X,76));
    X+=85;
  }
  if (Options & mbNo)
  { Dialog->Insert(new TNoButton(X,76));
    X+=85;
  }
  if (Options & mbOK)
  { Dialog->Insert(new TOKButton(X,76));
    X+=85;
  }
  if (Options & mbCancel) Dialog->Insert(new TCancelButton(X,76));
  // Execute the dialog
  Desktop->Insert(Dialog);
  Result=Application->EventsLoop(Dialog);
  // Destroy the dialog
  delete Dialog;
  //
  return Result;
}