// Associated include file : Graphics/TitleBox.H

#include "common/common.h"
#include "drivers/drivers.h"
#include "mecanism/mecanism.h"
#include "graphics/graphics.h"
#include "gadgets/gadgets.h"

// --- TTitleBox

DEFINE(TTitleBox);

short RegTTitleBox;
char *IdentTTitleBox = "TTitleBox";

TTitleBox::TTitleBox()
{ Defaults();
}

TTitleBox::TTitleBox(int X, int Y, TWindow *W, int Command, int ScanCode, TMapping *_Mapp)
{ Defaults();
  Init(X,Y,W,Command,ScanCode,_Mapp);
}

void TTitleBox::Defaults()
{ // Object identification
  Register=RegTTitleBox;
  Ident=IdentTTitleBox;
  // Other default values
  SetOptions(opCSLoX | opCSHiX);
}

void TTitleBox::Init(int X, int Y, TWindow *W, int Command, int ScanCode, TMapping *_Mapp)
{ Window=W;
  // Herited constructions
  TStdButton::Init(X,Y,15,15,Command,ScanCode,0,NULL,_Mapp);
  // New constructions
}

void TTitleBox::Action(void)
{ SetCommand(Command,Window);
}

// ---

TCloseBox::TCloseBox(int X, int Y, TWindow *W) :
  TTitleBox(X,Y,W,cmDestroyWindow,ScanAltF3,new TSysIcone(9,9,ICO_Close))
{ }

TMinimizeBox::TMinimizeBox(int X, int Y, TWindow *W) :
  TTitleBox(X,Y,W,cmMinimizeWindow,0,new TSysIcone(9,9,ICO_Minimize))
{ }

TMaximizeBox::TMaximizeBox(int X, int Y, TWindow *W) :
  TTitleBox(X,Y,W,cmMaximizeWindow,ScanF5,new TSysIcone(9,9,ICO_Maximize))
{ }

