// Associated include file : Graphics/PerfView.H

#include "common/common.h"
#include "drivers/drivers.h"
#include "mecanism/mecanism.h"
#include "graphics/graphics.h"
#include "gadgets/gadgets.h"

// --- Object TPerfViewer

char *IdentTPerfViewer = "TPerfViewer";
short RegTPerfViewer;

DEFINE(TPerfViewer);

TPerfViewer::TPerfViewer(void)
{ Defaults();
}

TPerfViewer::TPerfViewer(int X, int Y, int L, int H)
{ Defaults();
  Init(X,Y,L,H);
}

TPerfViewer::TPerfViewer(TRect R)
{ Defaults();
  Init(R.X1(),R.Y1(),R.Width(),R.Height());
}

// Construction / Destruction

void TPerfViewer::Defaults(void)
{ // Object Identification
  Register=RegTPerfViewer;
  Ident=IdentTPerfViewer;
  // Other default values
  Datas=NULL;
  Max=0;
}

void TPerfViewer::Init(int X, int Y, int L, int H)
{ // Herited constructions
  TZone::Init(X,Y,L,H);
  // New constructions
  int i;
  LDatas=L;
  Datas=new long[LDatas];
  for(i=0;i<LDatas;i++) Datas[i]=-1;
}

void TPerfViewer::Done(void)
{ // Herited destructions
  TZone::Done();
  // New destructions
  if (Datas!=NULL) delete Datas;
}

void TPerfViewer::Step(long Data)
{ int i;
  // Shift datas to the left
  for(i=0;i<LDatas;i++) Datas[i]=Datas[i+1];
  // Store new data
  Datas[LDatas-1]=Data;
  // Compute Maximum
  Max=0;
  for(i=0;i<LDatas;i++)
    if (Datas[i]>Max) Max=Datas[i];
  //
  Invalidate();
}

void TPerfViewer::Draw(TRect )
{ int i,H;
  for(i=0;i<LDatas;i++)
    if (Datas[i]<0)
    { SetSysColor(FaceGray);
      LineY(i,0,Where.Height()-1);
    }
    else
    { if (Max==0) H=0;
             else H=(int)((float)Where.Height()*Datas[i]/Max);
      SetSysColor(DarkGray);
      LineY(i,Where.Height()-H,Where.Height()-1);
      SetSysColor(FaceGray);
      LineY(i,0,Where.Height()-H-1);
    }
}
