#include <stdio.h>

#define FALSE 0
#define TRUE  1

typedef int boolean;

#define DECLARE(a)                          \
  public:                                   \
	virtual ~a(void);                   \

#define DEFINE(a)                           \
	a::~a(void)                         \
	{ if (!Destroyed)                   \
	  { Done();                         \
                 Destroyed=TRUE;            \
	  }                                 \
	}                                   \

// --- TBase object

class TBase
{ DECLARE(TBase)
  // -- Datas
  protected:
    boolean Destroyed;
    int     Value;
  // -- Functions
  public:
  // Public constructors
            TBase(void);
            TBase(int _Value);
  // Creation / Destruction
            void Defaults(void);
            void Init(int _Value);
            void Done(void);
  // Virtual functions
  protected:
    virtual void FooConstruct(void);
    virtual void FooDestruct(void);
};

DEFINE(TBase);

TBase::TBase(void)
{ Defaults();
}

TBase::TBase(int _Value)
{ Defaults();
  Init(_Value);
}

void TBase::Defaults(void)
{ printf("  Begin: TBase::Defaults\n");
  // Set defaults values
  Value=0;
  Destroyed=FALSE;
  printf("  End:   TBase::Defaults\n");
}

void TBase::Init(int _Value)
{ printf("  Begin: TBase::Init\n");
  Value=_Value;
  FooConstruct();
  printf("  End:   TBase::Init\n");
}

void TBase::Done(void)
{ printf("  Begin: TBase::Done\n");
  FooDestruct();
  printf("  End:   TBase::Done\n");
}

void TBase::FooConstruct(void)
{ printf("    TBase::FooConstruct\n");
}

void TBase::FooDestruct(void)
{ printf("    TBase::FooDestruct\n");
}

// --- TDerived object

class TDerived : public TBase
{ DECLARE(TDerived)
  // -- Datas
  protected:
  // -- Functions
  public:
  // Public constructors
            TDerived(void);
            TDerived(int _Value);
  // Creation / Destruction
            void Defaults(void);
            void Init(int _Value);
  // Virtual functions
  protected:
    virtual void FooConstruct(void);
    virtual void FooDestruct(void);
};

DEFINE(TDerived);

TDerived::TDerived(void)
{ Defaults();
}

TDerived::TDerived(int _Value)
{ Defaults();
  Init(_Value);
}

void TDerived::Defaults(void)
{ printf("  Begin: TDerived::Defaults\n");
  printf("  End:   TDerived::Defaults\n");
}

void TDerived::Init(int _Value)
{ printf("  Begin: TDerived::Init\n");
  // Base constructions
  TBase::Init(_Value);
  // Other constructions
  // ...
  printf("  End:   TDerived::Init\n");
}

void TDerived::FooConstruct(void)
{ printf("    TDerived::FooConstruct\n");
}

void TDerived::FooDestruct(void)
{ printf("    TDerived::FooDestruct\n");
}

// --- Example

void main(void)
{ TBase    *B;
  TDerived *D;

  printf("\nTBase construction : \n");
  B=new TBase(2);
  getc(stdin);

  printf("\nTDerived construction : \n");
  D=new TDerived(2);
  getc(stdin);

  printf("\nTBase destruction : \n");
  delete B;
  getc(stdin);

  printf("\nTDerived destruction : \n");
  delete D;
  getc(stdin);
}
