/*
    Load-time dynamic linking of DLL functions and data

    To use data by load-time linking, **data must be used (dlltest.h).
*/

#define STRICT
#define WIN32_LEAN_AND_MEAN

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include "dlltest.h"

int main(int argc, char **argv)
{
    struct stat fStat;

    if (argc > 1) {
	printf("external data in dll %d\n\n", VariableDll);

	if (DllAccess(argv[1]) == 0) {
	    puts("dll access ok");

	    if (DllStat(argv[1], &fStat) == 0) {
		printf("file mode %d\n", fStat.st_mode);
		printf("file size %lu\n", fStat.st_size);
		printf("file attr %lu\n", fStat.st_attr);
	    }
	    else
		puts("dll stat error");
	}
	else
	    printf("file not found\n");

    } else
	puts("usage: calldll <filename>");

    return 0;
}
